/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil.util;

import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.level.format.anvil.util.NibbleArray;
import cn.nukkit.level.util.PalettedBlockStorage;
import cn.nukkit.utils.BinaryStream;

public class BlockStorage {
    private static final int SECTION_SIZE = 4096;
    private final byte[] blockIds;
    private final NibbleArray blockData;

    public BlockStorage() {
        this.blockIds = new byte[4096];
        this.blockData = new NibbleArray(4096);
    }

    private BlockStorage(byte[] blockIds, NibbleArray blockData) {
        this.blockIds = blockIds;
        this.blockData = blockData;
    }

    private static int getIndex(int x, int y, int z) {
        int index = (x << 8) + (z << 4) + y;
        if (index < 0 || index >= 4096) {
            throw new IllegalArgumentException("Invalid index");
        }
        return index;
    }

    public int getBlockData(int x, int y, int z) {
        return this.blockData.get(BlockStorage.getIndex(x, y, z)) & 0xF;
    }

    public int getBlockId(int x, int y, int z) {
        return this.blockIds[BlockStorage.getIndex(x, y, z)] & 0xFF;
    }

    public void setBlockId(int x, int y, int z, int id) {
        this.blockIds[BlockStorage.getIndex((int)x, (int)y, (int)z)] = (byte)(id & 0xFF);
    }

    public void setBlockData(int x, int y, int z, int data) {
        this.blockData.set(BlockStorage.getIndex(x, y, z), (byte)data);
    }

    public int getFullBlock(int x, int y, int z) {
        return this.getFullBlock(BlockStorage.getIndex(x, y, z));
    }

    public void setFullBlock(int x, int y, int z, int value) {
        this.setFullBlock(BlockStorage.getIndex(x, y, z), value);
    }

    public int getAndSetFullBlock(int x, int y, int z, int value) {
        return this.getAndSetFullBlock(BlockStorage.getIndex(x, y, z), value);
    }

    private int getAndSetFullBlock(int index, int value) {
        int block = value >> 6;
        int meta = value & 0x3F;
        if ((value = (block << 4) + Math.min(meta, 15)) >= 8191) {
            throw new IllegalArgumentException("Invalid full block " + value);
        }
        int oldBlock = this.blockIds[index] & 0xFF;
        byte oldData = this.blockData.get(index);
        byte newData = (byte)(value & 0xF);
        if (oldBlock != block) {
            this.blockIds[index] = (byte)(block & 0xFF);
        }
        if (oldData != newData) {
            this.blockData.set(index, newData);
        }
        return oldBlock << 6 | oldData;
    }

    private int getFullBlock(int index) {
        int b = this.blockIds[index] & 0xFF;
        return b << 6 | this.blockData.get(index);
    }

    private void setFullBlock(int index, int value) {
        int block = value >> 6;
        int meta = value & 0x3F;
        if ((value = (block << 4) + Math.min(meta, 15)) >= 8191) {
            throw new IllegalArgumentException("Invalid full block " + value);
        }
        this.blockIds[index] = (byte)(block & 0xFF);
        this.blockData.set(index, (byte)(value & 0xF));
    }

    public void writeTo(BinaryStream stream) {
        stream.putByte((byte)8);
        PalettedBlockStorage layer = PalettedBlockStorage.createFromBlockPalette();
        for (int i = 0; i < 4096; ++i) {
            layer.setBlock(i, GlobalBlockPalette.getOrCreateRuntimeId(this.blockIds[i] & 0xFF, this.blockData.get(i)));
        }
        stream.putByte((byte)1);
        layer.writeTo(stream);
    }

    public BlockStorage copy() {
        return new BlockStorage((byte[])this.blockIds.clone(), this.blockData.copy());
    }
}

