/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil.palette;

import java.util.Arrays;

public class IntPalette {
    private static final int[] INT0 = new int[0];
    private int[] keys = INT0;
    private int lastIndex = Integer.MIN_VALUE;

    public void add(int key) {
        this.keys = this.insert(key);
        this.lastIndex = Integer.MIN_VALUE;
    }

    private int[] insert(int val) {
        this.lastIndex = Integer.MIN_VALUE;
        if (this.keys.length == 0) {
            return new int[]{val};
        }
        if (val < this.keys[0]) {
            int[] s2 = new int[this.keys.length + 1];
            System.arraycopy(this.keys, 0, s2, 1, this.keys.length);
            s2[0] = val;
            return s2;
        }
        if (val > this.keys[this.keys.length - 1]) {
            int[] s3 = Arrays.copyOf(this.keys, this.keys.length + 1);
            s3[this.keys.length] = val;
            return s3;
        }
        int[] s4 = Arrays.copyOf(this.keys, this.keys.length + 1);
        for (int i = 0; i < s4.length; ++i) {
            if (this.keys[i] < val) continue;
            System.arraycopy(this.keys, i, s4, i + 1, s4.length - i - 1);
            s4[i] = val;
            break;
        }
        return s4;
    }

    public int getKey(int index) {
        return this.keys[index];
    }

    public int getValue(int key) {
        int index;
        boolean hasLast;
        int lastTmp = this.lastIndex;
        boolean bl = hasLast = lastTmp != Integer.MIN_VALUE;
        if (hasLast) {
            int lastKey = this.keys[lastTmp];
            if (lastKey == key) {
                return lastTmp;
            }
            index = lastKey > key ? this.binarySearch0(0, lastTmp, key) : this.binarySearch0(lastTmp + 1, this.keys.length, key);
        } else {
            index = this.binarySearch0(0, this.keys.length, key);
        }
        if (index >= this.keys.length || index < 0) {
            this.lastIndex = Integer.MIN_VALUE;
            return Integer.MIN_VALUE;
        }
        this.lastIndex = index;
        return this.lastIndex;
    }

    private int binarySearch0(int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = this.keys[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int length() {
        return this.keys.length;
    }

    public IntPalette clone() {
        IntPalette p = new IntPalette();
        p.keys = this.keys != INT0 ? (int[])this.keys.clone() : INT0;
        p.lastIndex = this.lastIndex;
        return p;
    }
}

