/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil;

import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLayer;
import cn.nukkit.level.format.anvil.util.BlockStorage;
import cn.nukkit.level.format.anvil.util.NibbleArray;
import cn.nukkit.level.format.generic.EmptyChunkSection;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.Binary;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.Utils;
import cn.nukkit.utils.Zlib;
import java.io.IOException;
import java.util.Arrays;

public class ChunkSection
implements cn.nukkit.level.format.ChunkSection {
    private final int y;
    private final BlockStorage storage;
    protected byte[] blockLight;
    protected byte[] skyLight;
    protected byte[] compressedLight;
    protected boolean hasBlockLight;
    protected boolean hasSkyLight;

    public ChunkSection(int y, BlockStorage storage, byte[] blockLight, byte[] skyLight, byte[] compressedLight, boolean hasBlockLight, boolean hasSkyLight) {
        this.y = y;
        this.storage = storage;
        this.blockLight = blockLight;
        this.skyLight = skyLight;
        this.compressedLight = compressedLight;
        this.hasBlockLight = hasBlockLight;
        this.hasSkyLight = hasSkyLight;
    }

    public ChunkSection(int y) {
        this(y, new BlockStorage(), null, null, null, false, true);
    }

    public ChunkSection(CompoundTag nbt) {
        this.y = nbt.getByte("Y");
        byte[] blocks = nbt.getByteArray("Blocks");
        NibbleArray data = new NibbleArray(nbt.getByteArray("Data"));
        this.storage = new BlockStorage();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    int index = ChunkSection.getAnvilIndex(x, y, z);
                    this.storage.setBlockData(x, y, z, data.get(index));
                    int b = blocks[index] & 0xFF;
                    this.storage.setBlockId(x, y, z, b);
                }
            }
        }
        this.blockLight = nbt.getByteArray("BlockLight");
        this.skyLight = nbt.getByteArray("SkyLight");
    }

    private static int getAnvilIndex(int x, int y, int z) {
        return (y << 8) + (z << 4) + x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBlockId(int x, int y, int z, BlockLayer layer) {
        if (layer != BlockLayer.NORMAL) {
            return 0;
        }
        BlockStorage blockStorage = this.storage;
        synchronized (blockStorage) {
            return this.storage.getBlockId(x, y, z);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlockId(int x, int y, int z, BlockLayer layer, int id) {
        if (layer != BlockLayer.NORMAL) {
            return;
        }
        BlockStorage blockStorage = this.storage;
        synchronized (blockStorage) {
            this.storage.setBlockId(x, y, z, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setFullBlockId(int x, int y, int z, BlockLayer layer, int fullId) {
        if (layer != BlockLayer.NORMAL) {
            return true;
        }
        BlockStorage blockStorage = this.storage;
        synchronized (blockStorage) {
            this.storage.setFullBlock(x, y, z, fullId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBlockData(int x, int y, int z, BlockLayer layer) {
        if (layer != BlockLayer.NORMAL) {
            return 0;
        }
        BlockStorage blockStorage = this.storage;
        synchronized (blockStorage) {
            return this.storage.getBlockData(x, y, z);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlockData(int x, int y, int z, BlockLayer layer, int data) {
        if (layer != BlockLayer.NORMAL) {
            return;
        }
        BlockStorage blockStorage = this.storage;
        synchronized (blockStorage) {
            this.storage.setBlockData(x, y, z, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFullBlock(int x, int y, int z, BlockLayer layer) {
        if (layer != BlockLayer.NORMAL) {
            return 0;
        }
        BlockStorage blockStorage = this.storage;
        synchronized (blockStorage) {
            return this.storage.getFullBlock(x, y, z);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBlock(int x, int y, int z, int blockId) {
        BlockStorage blockStorage = this.storage;
        synchronized (blockStorage) {
            return this.setBlock(x, y, z, blockId, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block getAndSetBlock(int x, int y, int z, BlockLayer layer, Block block) {
        if (layer != BlockLayer.NORMAL) {
            return Block.get(0);
        }
        BlockStorage blockStorage = this.storage;
        synchronized (blockStorage) {
            int fullId = this.storage.getAndSetFullBlock(x, y, z, block.getFullId());
            return Block.get(fullId, null, x, y, z, layer);
        }
    }

    @Override
    public boolean setBlock(int x, int y, int z, int blockId, int meta) {
        return this.setBlockAtLayer(x, y, z, Block.LAYER_NORMAL, blockId, meta);
    }

    @Override
    public boolean setBlockAtLayer(int x, int y, int z, BlockLayer layer, int blockId) {
        return this.setBlockAtLayer(x, y, z, layer, blockId, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBlockAtLayer(int x, int y, int z, BlockLayer layer, int blockId, int meta) {
        if (layer != BlockLayer.NORMAL) {
            return true;
        }
        BlockStorage blockStorage = this.storage;
        synchronized (blockStorage) {
            int fullId = blockId << 6 | meta;
            return this.storage.getAndSetFullBlock(x, y, z, fullId) != fullId;
        }
    }

    @Override
    public int getBlockSkyLight(int x, int y, int z) {
        if (this.skyLight == null) {
            if (!this.hasSkyLight) {
                return 0;
            }
            if (this.compressedLight == null) {
                return 15;
            }
        }
        this.skyLight = this.getSkyLightArray();
        int sl = this.skyLight[y << 7 | z << 3 | x >> 1] & 0xFF;
        if ((x & 1) == 0) {
            return sl & 0xF;
        }
        return sl >> 4;
    }

    @Override
    public void setBlockSkyLight(int x, int y, int z, int level) {
        if (this.skyLight == null) {
            if (this.hasSkyLight && this.compressedLight != null) {
                this.skyLight = this.getSkyLightArray();
            } else {
                if (level == (this.hasSkyLight ? 15 : 0)) {
                    return;
                }
                this.skyLight = new byte[2048];
                if (this.hasSkyLight) {
                    Arrays.fill(this.skyLight, (byte)-1);
                }
            }
        }
        int i = y << 7 | z << 3 | x >> 1;
        int old = this.skyLight[i] & 0xFF;
        this.skyLight[i] = (x & 1) == 0 ? (byte)(old & 0xF0 | level & 0xF) : (byte)((level & 0xF) << 4 | old & 0xF);
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        if (this.blockLight == null && !this.hasBlockLight) {
            return 0;
        }
        this.blockLight = this.getLightArray();
        int l = this.blockLight[y << 7 | z << 3 | x >> 1] & 0xFF;
        if ((x & 1) == 0) {
            return l & 0xF;
        }
        return l >> 4;
    }

    @Override
    public void setBlockLight(int x, int y, int z, int level) {
        if (this.blockLight == null) {
            if (this.hasBlockLight) {
                this.blockLight = this.getLightArray();
            } else {
                if (level == 0) {
                    return;
                }
                this.blockLight = new byte[2048];
            }
        }
        int i = y << 7 | z << 3 | x >> 1;
        int old = this.blockLight[i] & 0xFF;
        this.blockLight[i] = (x & 1) == 0 ? (byte)(old & 0xF0 | level & 0xF) : (byte)((level & 0xF) << 4 | old & 0xF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getIdArray() {
        BlockStorage blockStorage = this.storage;
        synchronized (blockStorage) {
            byte[] anvil = new byte[4096];
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 16; ++y) {
                        int index = ChunkSection.getAnvilIndex(x, y, z);
                        anvil[index] = (byte)this.storage.getBlockId(x, y, z);
                    }
                }
            }
            return anvil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getDataArray() {
        BlockStorage blockStorage = this.storage;
        synchronized (blockStorage) {
            NibbleArray anvil = new NibbleArray(4096);
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 16; ++y) {
                        int index = ChunkSection.getAnvilIndex(x, y, z);
                        anvil.set(index, (byte)this.storage.getBlockData(x, y, z));
                    }
                }
            }
            return anvil.getData();
        }
    }

    @Override
    public byte[] getSkyLightArray() {
        if (this.skyLight != null) {
            return this.skyLight;
        }
        if (this.hasSkyLight && this.compressedLight != null) {
            this.inflate();
            if (this.skyLight != null) {
                return this.skyLight;
            }
        }
        return EmptyChunkSection.EMPTY_SKY_LIGHT_ARR;
    }

    private void inflate() {
        try {
            if (this.compressedLight != null && this.compressedLight.length != 0) {
                byte[] inflated = Zlib.inflate(this.compressedLight);
                this.blockLight = Arrays.copyOfRange(inflated, 0, 2048);
                if (inflated.length > 2048) {
                    this.skyLight = Arrays.copyOfRange(inflated, 2048, 4096);
                } else {
                    this.skyLight = new byte[2048];
                    if (this.hasSkyLight) {
                        Arrays.fill(this.skyLight, (byte)-1);
                    }
                }
                this.compressedLight = null;
            } else {
                if (this.blockLight == null) {
                    this.blockLight = new byte[2048];
                }
                this.skyLight = new byte[2048];
                if (this.hasSkyLight) {
                    Arrays.fill(this.skyLight, (byte)-1);
                }
            }
        }
        catch (IOException e) {
            Server.getInstance().getLogger().logException(e);
        }
    }

    @Override
    public byte[] getLightArray() {
        if (this.blockLight != null) {
            return this.blockLight;
        }
        if (this.hasBlockLight) {
            this.inflate();
            if (this.blockLight != null) {
                return this.blockLight;
            }
        }
        return EmptyChunkSection.EMPTY_LIGHT_ARR;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(BinaryStream stream) {
        BlockStorage blockStorage = this.storage;
        synchronized (blockStorage) {
            this.storage.writeTo(stream);
        }
    }

    public boolean compress() {
        if (this.blockLight != null) {
            byte[] arr2;
            byte[] arr1 = this.blockLight;
            boolean bl = this.hasBlockLight = !Utils.isByteArrayEmpty(arr1);
            if (this.skyLight != null) {
                arr2 = this.skyLight;
                this.hasSkyLight = !Utils.isByteArrayEmpty(arr2);
            } else if (this.hasSkyLight) {
                arr2 = EmptyChunkSection.EMPTY_SKY_LIGHT_ARR;
            } else {
                arr2 = EmptyChunkSection.EMPTY_LIGHT_ARR;
                this.hasSkyLight = false;
            }
            this.blockLight = null;
            this.skyLight = null;
            byte[] toDeflate = null;
            if (this.hasBlockLight && this.hasSkyLight && arr2 != EmptyChunkSection.EMPTY_SKY_LIGHT_ARR) {
                toDeflate = Binary.appendBytes(arr1, (byte[][])new byte[][]{arr2});
            } else if (this.hasBlockLight) {
                toDeflate = arr1;
            }
            if (toDeflate != null) {
                try {
                    this.compressedLight = Zlib.deflate(toDeflate, 1);
                }
                catch (Exception e) {
                    Server.getInstance().getLogger().logException(e);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public ChunkSection copy() {
        return new ChunkSection(this.y, this.storage.copy(), this.blockLight == null ? null : (byte[])this.blockLight.clone(), this.skyLight == null ? null : (byte[])this.skyLight.clone(), this.compressedLight == null ? null : (byte[])this.compressedLight.clone(), this.hasBlockLight, this.hasSkyLight);
    }

    @Override
    public ChunkSection copyForChunkSending() {
        return new ChunkSection(this.y, this.storage.copy(), null, null, null, false, false);
    }
}

