/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil;

import cn.nukkit.Server;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.anvil.Chunk;
import cn.nukkit.level.format.anvil.ChunkSection;
import cn.nukkit.level.format.anvil.RegionLoader;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.format.generic.BaseLevelProvider;
import cn.nukkit.level.format.generic.BaseRegionLoader;
import cn.nukkit.level.generator.Generator;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.ChunkException;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public class Anvil
extends BaseLevelProvider {
    private int lastPosition = 0;

    public Anvil(Level level, String path) throws IOException {
        super(level, path);
    }

    public static String getProviderName() {
        return "anvil";
    }

    public static boolean usesChunkSection() {
        return true;
    }

    public static boolean isValid(String path) {
        boolean isValid;
        boolean bl = isValid = new File(path + "/level.dat").exists() && new File(path + "/region/").isDirectory();
        if (isValid) {
            for (File file : new File(path + "/region/").listFiles((dir, name) -> Pattern.matches("^.+\\.mc[r|a]$", name))) {
                if (file.getName().endsWith(".mca")) continue;
                isValid = false;
                break;
            }
        }
        return isValid;
    }

    public static void generate(String path, String name, long seed, Class<? extends Generator> generator) throws IOException {
        Anvil.generate(path, name, seed, generator, new HashMap<String, String>());
    }

    public static void generate(String path, String name, long seed, Class<? extends Generator> generator, Map<String, String> options) throws IOException {
        if (!new File(path + "/region").exists()) {
            new File(path + "/region").mkdirs();
        }
        CompoundTag levelData = new CompoundTag("Data").putCompound("GameRules", new CompoundTag()).putLong("DayTime", 0L).putInt("GameType", 0).putString("generatorName", Generator.getGeneratorName(generator)).putString("generatorOptions", options.getOrDefault("preset", "")).putInt("generatorVersion", 1).putBoolean("hardcore", false).putBoolean("initialized", true).putLong("LastPlayed", System.currentTimeMillis() / 1000L).putString("LevelName", name).putBoolean("raining", false).putInt("rainTime", 0).putLong("RandomSeed", seed).putInt("SpawnX", 128).putInt("SpawnY", 70).putInt("SpawnZ", 128).putBoolean("thundering", false).putInt("thunderTime", 0).putInt("version", 19133).putLong("Time", 0L).putLong("SizeOnDisk", 0L);
        NBTIO.writeGZIPCompressed(new CompoundTag().putCompound("Data", levelData), Files.newOutputStream(Paths.get(path + "level.dat", new String[0]), new OpenOption[0]), ByteOrder.BIG_ENDIAN);
    }

    @Override
    public Chunk getEmptyChunk(int chunkX, int chunkZ) {
        return Chunk.getEmptyChunk(chunkX, chunkZ, this);
    }

    @Override
    public void requestChunkTask(int x, int z) throws ChunkException {
        Chunk chunk = (Chunk)this.getChunk(x, z, false);
        if (chunk == null) {
            throw new ChunkException("Invalid chunk set (" + x + ", " + z + ')');
        }
        long timestamp = chunk.getChanges();
        this.level.asyncChunk(chunk.cloneForChunkSending(), timestamp, x, z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGarbageCollection(long time) {
        int i;
        long start = System.currentTimeMillis();
        int maxIterations = this.size();
        if (this.lastPosition > maxIterations) {
            this.lastPosition = 0;
        }
        Long2ObjectMap long2ObjectMap = this.chunks;
        synchronized (long2ObjectMap) {
            Iterator iter = this.chunks.values().iterator();
            if (this.lastPosition != 0) {
                iter.skip(this.lastPosition);
            }
            for (i = 0; i < maxIterations; ++i) {
                if (!iter.hasNext()) {
                    iter = this.chunks.values().iterator();
                }
                if (!iter.hasNext()) break;
                BaseFullChunk chunk = (BaseFullChunk)iter.next();
                if (chunk == null || !chunk.isGenerated() || !chunk.isPopulated() || !(chunk instanceof Chunk)) continue;
                chunk.compress();
                if (System.currentTimeMillis() - start >= time) break;
            }
        }
        this.lastPosition += i;
    }

    @Override
    public synchronized BaseFullChunk loadChunk(long index, int chunkX, int chunkZ, boolean create) {
        int regionX = Anvil.getRegionIndexX(chunkX);
        int regionZ = Anvil.getRegionIndexZ(chunkZ);
        BaseRegionLoader region = this.loadRegion(regionX, regionZ);
        BaseFullChunk chunk = null;
        try {
            chunk = region.readChunk(chunkX - (regionX << 5), chunkZ - (regionZ << 5));
        }
        catch (IOException ex) {
            Server.getInstance().getLogger().error("Failed to read chunk " + chunkX + ", " + chunkZ, ex);
        }
        if (chunk == null) {
            if (create) {
                chunk = this.getEmptyChunk(chunkX, chunkZ);
                this.putChunk(index, chunk);
            }
        } else {
            this.putChunk(index, chunk);
        }
        return chunk;
    }

    @Override
    public synchronized void saveChunk(int X, int Z) {
        BaseFullChunk chunk = this.getChunk(X, Z);
        if (chunk != null) {
            try {
                this.loadRegion(X >> 5, Z >> 5).writeChunk(chunk);
            }
            catch (Exception e) {
                throw new ChunkException("Error saving chunk (" + X + ", " + Z + ')', e);
            }
        }
    }

    @Override
    public synchronized void saveChunk(int x, int z, FullChunk chunk) {
        if (!(chunk instanceof Chunk)) {
            throw new ChunkException("Invalid chunk class (" + x + ", " + z + ')');
        }
        int regionX = x >> 5;
        int regionZ = z >> 5;
        this.loadRegion(regionX, regionZ);
        chunk.setX(x);
        chunk.setZ(z);
        try {
            this.getRegion(regionX, regionZ).writeChunk(chunk);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ChunkSection createChunkSection(int y) {
        return new ChunkSection(y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized BaseRegionLoader loadRegion(int x, int z) {
        BaseRegionLoader tmp = (BaseRegionLoader)this.lastRegion.get();
        if (tmp != null && x == tmp.getX() && z == tmp.getZ()) {
            return tmp;
        }
        long index = Level.chunkHash(x, z);
        Long2ObjectMap long2ObjectMap = this.regions;
        synchronized (long2ObjectMap) {
            BaseRegionLoader region = (BaseRegionLoader)this.regions.get(index);
            if (region == null) {
                try {
                    region = new RegionLoader(this, x, z);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.regions.put(index, region);
            }
            this.lastRegion.set(region);
            return region;
        }
    }
}

