/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLayer;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.entity.Entity;
import cn.nukkit.level.biome.Biome;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.level.util.PalettedBlockStorage;
import java.io.IOException;
import java.util.Map;

public interface FullChunk
extends Cloneable {
    public int getX();

    public int getZ();

    default public void setPosition(int x, int z) {
        this.setX(x);
        this.setZ(z);
    }

    public void setX(int var1);

    public void setZ(int var1);

    public long getIndex();

    public LevelProvider getProvider();

    public void setProvider(LevelProvider var1);

    default public int getFullBlock(int x, int y, int z) {
        return this.getFullBlock(x, y, z, Block.LAYER_NORMAL);
    }

    public int getFullBlock(int var1, int var2, int var3, BlockLayer var4);

    default public Block getAndSetBlock(int x, int y, int z, Block block) {
        return this.getAndSetBlock(x, y, z, Block.LAYER_NORMAL, block);
    }

    public Block getAndSetBlock(int var1, int var2, int var3, BlockLayer var4, Block var5);

    default public boolean setFullBlockId(int x, int y, int z, int fullId) {
        return this.setFullBlockId(x, y, z, Block.LAYER_NORMAL, fullId);
    }

    default public boolean setFullBlockId(int x, int y, int z, BlockLayer layer, int fullId) {
        return this.setBlockAtLayer(x, y, z, layer, fullId >> 6, fullId & 0x3F);
    }

    public boolean setBlock(int var1, int var2, int var3, int var4);

    public boolean setBlock(int var1, int var2, int var3, int var4, int var5);

    public boolean setBlockAtLayer(int var1, int var2, int var3, BlockLayer var4, int var5);

    public boolean setBlockAtLayer(int var1, int var2, int var3, BlockLayer var4, int var5, int var6);

    default public int getBlockId(int x, int y, int z) {
        return this.getBlockId(x, y, z, Block.LAYER_NORMAL);
    }

    public int getBlockId(int var1, int var2, int var3, BlockLayer var4);

    default public void setBlockId(int x, int y, int z, int id) {
        this.setBlockId(x, y, z, Block.LAYER_NORMAL, id);
    }

    public void setBlockId(int var1, int var2, int var3, BlockLayer var4, int var5);

    default public int getBlockData(int x, int y, int z) {
        return this.getBlockData(x, y, z, Block.LAYER_NORMAL);
    }

    public int getBlockData(int var1, int var2, int var3, BlockLayer var4);

    default public void setBlockData(int x, int y, int z, int data) {
        this.setBlockData(x, y, z, Block.LAYER_NORMAL, data);
    }

    public void setBlockData(int var1, int var2, int var3, BlockLayer var4, int var5);

    public int getBlockExtraData(int var1, int var2, int var3);

    public void setBlockExtraData(int var1, int var2, int var3, int var4);

    public int getBlockSkyLight(int var1, int var2, int var3);

    public void setBlockSkyLight(int var1, int var2, int var3, int var4);

    public int getBlockLight(int var1, int var2, int var3);

    public void setBlockLight(int var1, int var2, int var3, int var4);

    public int getHighestBlockAt(int var1, int var2);

    public int getHighestBlockAt(int var1, int var2, boolean var3);

    public int getHeightMap(int var1, int var2);

    public void setHeightMap(int var1, int var2, int var3);

    public void recalculateHeightMap();

    public void populateSkyLight();

    default public boolean has3dBiomes() {
        return false;
    }

    default public PalettedBlockStorage getBiomeStorage(int y) {
        return null;
    }

    public int getBiomeId(int var1, int var2);

    default public int getBiomeId(int x, int y, int z) {
        return this.getBiomeId(x, z);
    }

    default public void setBiomeId(int x, int y, int z, int biomeId) {
        this.setBiomeId(x, y, z, (byte)biomeId);
    }

    default public void setBiomeId(int x, int z, int biomeId) {
        this.setBiomeId(x, z, (byte)biomeId);
    }

    default public void setBiomeId(int x, int y, int z, byte biomeId) {
        this.setBiomeId(x, z, biomeId);
    }

    public void setBiomeId(int var1, int var2, byte var3);

    default public void setBiome(int x, int z, Biome biome) {
        this.setBiomeId(x, z, biome.getId());
    }

    public boolean isLightPopulated();

    public void setLightPopulated();

    public void setLightPopulated(boolean var1);

    public boolean isPopulated();

    public void setPopulated();

    public void setPopulated(boolean var1);

    public boolean isGenerated();

    public void setGenerated();

    public void setGenerated(boolean var1);

    public void addEntity(Entity var1);

    public void removeEntity(Entity var1);

    public void addBlockEntity(BlockEntity var1);

    public void removeBlockEntity(BlockEntity var1);

    public Map<Long, Entity> getEntities();

    public Map<Long, BlockEntity> getBlockEntities();

    public BlockEntity getTile(int var1, int var2, int var3);

    public boolean isLoaded();

    public boolean load() throws IOException;

    public boolean load(boolean var1) throws IOException;

    public boolean unload() throws Exception;

    public boolean unload(boolean var1) throws Exception;

    public boolean unload(boolean var1, boolean var2) throws Exception;

    public void initChunk();

    public byte[] getBiomeIdArray();

    public void setBiomeIdArray(byte[] var1);

    public byte[] getHeightMapArray();

    @Deprecated
    public byte[] getBlockIdArray();

    @Deprecated
    public byte[] getBlockDataArray();

    public Map<Integer, Integer> getBlockExtraDataArray();

    @Deprecated
    public byte[] getBlockSkyLightArray();

    @Deprecated
    public byte[] getBlockLightArray();

    public byte[] toBinary();

    @Deprecated
    public byte[] toFastBinary();

    public boolean hasChanged();

    public void setChanged();

    public void setChanged(boolean var1);
}

