/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.biome.type;

import cn.nukkit.level.biome.Biome;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.Normal;

public abstract class CoveredBiome
extends Biome {
    public int getCoverId(int x, int z) {
        return 0;
    }

    public int getSurfaceDepth(int x, int y, int z) {
        return 1;
    }

    public abstract int getSurfaceId(int var1, int var2, int var3);

    public int getGroundDepth(int x, int y, int z) {
        return 4;
    }

    public abstract int getGroundId(int var1, int var2, int var3);

    public void doCover(int x, int z, FullChunk chunk) {
        int fullX = chunk.getX() << 4 | x;
        int fullZ = chunk.getZ() << 4 | z;
        int coverBlock = this.getCoverId(fullX, fullZ);
        boolean hasCovered = false;
        for (int y = 254; y > 32; --y) {
            if (chunk.getFullBlock(x, y, z) == 64) {
                block8: {
                    if (!hasCovered) {
                        int realY;
                        int i;
                        if (y >= Normal.seaHeight) {
                            chunk.setFullBlockId(x, y + 1, z, coverBlock);
                            int surfaceDepth = this.getSurfaceDepth(fullX, y, fullZ);
                            for (i = 0; i < surfaceDepth; ++i) {
                                realY = y - i;
                                if (chunk.getFullBlock(x, realY, z) == 64) {
                                    chunk.setFullBlockId(x, realY, z, this.getSurfaceId(fullX, realY, fullZ));
                                    continue;
                                }
                                break block8;
                            }
                            y -= surfaceDepth;
                        }
                        int groundDepth = this.getGroundDepth(fullX, y, fullZ);
                        for (i = 0; i < groundDepth; ++i) {
                            realY = y - i;
                            if (chunk.getFullBlock(x, realY, z) == 64) {
                                chunk.setFullBlockId(x, realY, z, this.getGroundId(fullX, realY, fullZ));
                                continue;
                            }
                            break block8;
                        }
                        y -= groundDepth - 1;
                    }
                }
                hasCovered = true;
                continue;
            }
            if (!hasCovered) continue;
            hasCovered = false;
        }
    }
}

