/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.biome.impl.taiga;

import cn.nukkit.level.biome.impl.taiga.TaigaBiome;
import cn.nukkit.level.generator.noise.nukkit.f.SimplexF;
import cn.nukkit.level.generator.populator.impl.PopulatorForestRock;
import cn.nukkit.level.generator.populator.impl.PopulatorSmallMushroom;
import cn.nukkit.level.generator.populator.impl.tree.SpruceBigTreePopulator;
import cn.nukkit.math.NukkitRandom;

public class MegaSpruceTaigaBiome
extends TaigaBiome {
    private static final SimplexF podzolNoise = new SimplexF(new NukkitRandom(), 2.0f, 0.25f, 0.03125f);

    public MegaSpruceTaigaBiome() {
        SpruceBigTreePopulator bigTrees = new SpruceBigTreePopulator();
        bigTrees.setBaseAmount(6);
        this.addPopulator(bigTrees);
        PopulatorForestRock rock = new PopulatorForestRock();
        rock.setRandomAmount(2);
        this.addPopulator(rock);
        PopulatorSmallMushroom smallMushroom = new PopulatorSmallMushroom();
        smallMushroom.setRandomAmount(3);
        this.addPopulator(smallMushroom);
    }

    @Override
    public String getName() {
        return "Mega Spruce Taiga";
    }

    @Override
    public int getSurfaceId(int x, int y, int z) {
        return podzolNoise.noise2D(x, z, true) < 0.0f ? 15552 : 128;
    }
}

