/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.biome.impl.forest;

import cn.nukkit.level.biome.type.GrassyBiome;
import cn.nukkit.level.generator.populator.impl.PopulatorFallenTree;
import cn.nukkit.level.generator.populator.impl.PopulatorTree;

public class ForestBiome
extends GrassyBiome {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_BIRCH = 1;
    public static final int TYPE_BIRCH_TALL = 2;
    public final int type;

    public ForestBiome() {
        this(0);
    }

    public ForestBiome(int type) {
        this.type = type;
        PopulatorTree trees = new PopulatorTree(type == 2 ? 10 : 2);
        trees.setBaseAmount(type == 0 ? 3 : 10);
        trees.setRandomAmount(3);
        this.addPopulator(trees);
        if (type == 0) {
            trees = new PopulatorTree(0);
            trees.setBaseAmount(4);
            trees.setRandomAmount(3);
            this.addPopulator(trees);
        }
        PopulatorFallenTree fallenTree = new PopulatorFallenTree();
        fallenTree.setType(type);
        this.addPopulator(fallenTree);
    }

    @Override
    public String getName() {
        switch (this.type) {
            case 1: {
                return "Birch Forest";
            }
            case 2: {
                return "Birch Forest M";
            }
        }
        return "Forest";
    }
}

