/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.biome.impl.extremehills;

import cn.nukkit.level.biome.impl.extremehills.ExtremeHillsPlusBiome;
import cn.nukkit.level.generator.noise.nukkit.f.SimplexF;
import cn.nukkit.math.NukkitRandom;

public class ExtremeHillsMBiome
extends ExtremeHillsPlusBiome {
    private static final SimplexF gravelNoise = new SimplexF(new NukkitRandom(), 1.0f, 0.25f, 0.015625f);

    public ExtremeHillsMBiome() {
        this(true);
    }

    public ExtremeHillsMBiome(boolean tree) {
        super(tree);
        this.setBaseHeight(1.0f);
        this.setHeightVariation(0.5f);
    }

    @Override
    public String getName() {
        return "Extreme Hills M";
    }

    @Override
    public int getSurfaceId(int x, int y, int z) {
        return gravelNoise.noise2D(x, z, true) < -0.75f ? 832 : super.getSurfaceId(x, y, z);
    }

    @Override
    public int getSurfaceDepth(int x, int y, int z) {
        return gravelNoise.noise2D(x, z, true) < -0.75f ? 4 : super.getSurfaceDepth(x, y, z);
    }

    @Override
    public int getGroundDepth(int x, int y, int z) {
        return gravelNoise.noise2D(x, z, true) < -0.75f ? 0 : super.getGroundDepth(x, y, z);
    }

    @Override
    public boolean doesOverhang() {
        return false;
    }
}

