/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.biome;

import cn.nukkit.level.biome.Biome;
import cn.nukkit.level.biome.EnumBiome;
import cn.nukkit.level.generator.noise.nukkit.f.SimplexF;
import cn.nukkit.math.NukkitRandom;

public class BiomeSelector {
    private final SimplexF temperature;
    private final SimplexF rainfall;
    private final SimplexF river;
    private final SimplexF ocean;
    private final SimplexF hills;

    public BiomeSelector(NukkitRandom random) {
        this.temperature = new SimplexF(random, 2.0f, 0.125f, 4.8828125E-4f);
        this.rainfall = new SimplexF(random, 2.0f, 0.125f, 4.8828125E-4f);
        this.river = new SimplexF(random, 6.0f, 0.5f, 9.765625E-4f);
        this.ocean = new SimplexF(random, 6.0f, 0.5f, 4.8828125E-4f);
        this.hills = new SimplexF(random, 2.0f, 0.5f, 4.8828125E-4f);
    }

    public Biome pickBiome(int x, int z) {
        return this.pickBiome(x, z, 0);
    }

    public Biome pickBiome(int x, int z, int version) {
        EnumBiome biome;
        float noiseOcean = this.ocean.noise2D(x, z, true);
        float noiseRiver = this.river.noise2D(x, z, true);
        float temperature = this.temperature.noise2D(x, z, true);
        float rainfall = this.rainfall.noise2D(x, z, true);
        if (version < 2) {
            if (noiseOcean < -0.15f) {
                biome = noiseOcean < -0.65f ? EnumBiome.MUSHROOM_ISLAND_SHORE : (rainfall < 0.0f ? (temperature < -0.4f ? EnumBiome.FROZEN_OCEAN : (temperature < 0.5f ? EnumBiome.OCEAN : EnumBiome.WARM_OCEAN)) : EnumBiome.DEEP_OCEAN);
            } else if (Math.abs(noiseRiver) < 0.04f) {
                biome = temperature < -0.4f ? EnumBiome.FROZEN_RIVER : EnumBiome.RIVER;
            } else {
                float hills = this.hills.noise2D(x, z, true);
                biome = temperature < -0.379f ? (noiseOcean < -0.12f ? EnumBiome.COLD_BEACH : (rainfall < 0.0f ? (hills < -0.1f ? EnumBiome.COLD_TAIGA : (hills < 0.5f ? EnumBiome.COLD_TAIGA_HILLS : EnumBiome.COLD_TAIGA_M)) : (hills < 0.7f ? EnumBiome.ICE_PLAINS : EnumBiome.ICE_PLAINS_SPIKES))) : (noiseOcean < -0.12f ? EnumBiome.BEACH : (temperature < 0.0f ? (hills < 0.2f ? (rainfall < -0.5f ? EnumBiome.EXTREME_HILLS_M : (rainfall > 0.5f ? EnumBiome.EXTREME_HILLS_PLUS_M : (rainfall < 0.0f ? EnumBiome.EXTREME_HILLS : EnumBiome.EXTREME_HILLS_PLUS))) : ((double)rainfall < -0.6 ? EnumBiome.MEGA_TAIGA : ((double)rainfall > 0.6 ? EnumBiome.MEGA_SPRUCE_TAIGA : (rainfall < 0.2f ? EnumBiome.TAIGA : EnumBiome.TAIGA_M)))) : (temperature < 0.5f ? (temperature < 0.25f ? (rainfall < 0.0f ? (noiseOcean < 0.0f ? EnumBiome.SUNFLOWER_PLAINS : EnumBiome.PLAINS) : (rainfall < 0.25f ? (noiseOcean < 0.0f ? EnumBiome.FLOWER_FOREST : EnumBiome.FOREST) : (noiseOcean < 0.0f ? EnumBiome.BIRCH_FOREST_M : EnumBiome.BIRCH_FOREST))) : (rainfall < -0.2f ? (noiseOcean < 0.0f ? EnumBiome.SWAMPLAND_M : EnumBiome.SWAMP) : (rainfall > 0.1f ? (noiseOcean < 0.155f ? EnumBiome.JUNGLE_M : EnumBiome.JUNGLE) : (noiseOcean < 0.0f ? EnumBiome.ROOFED_FOREST_M : EnumBiome.ROOFED_FOREST)))) : (rainfall < 0.0f ? (noiseOcean < 0.0f ? EnumBiome.DESERT_M : (hills < 0.0f ? EnumBiome.DESERT_HILLS : EnumBiome.DESERT)) : (rainfall > 0.4f ? (noiseOcean < 0.155f ? (hills < 0.0f ? EnumBiome.SAVANNA_PLATEAU_M : EnumBiome.SAVANNA_M) : (hills < 0.0f ? EnumBiome.SAVANNA_PLATEAU : EnumBiome.SAVANNA)) : (noiseOcean < 0.0f ? (hills < 0.0f ? EnumBiome.MESA_PLATEAU_F : EnumBiome.MESA_PLATEAU_F_M) : (hills < 0.0f ? (noiseOcean < 0.2f ? EnumBiome.MESA_PLATEAU_M : EnumBiome.MESA_PLATEAU) : (noiseOcean < 0.1f ? EnumBiome.MESA_BRYCE : EnumBiome.MESA))))))));
            }
        } else if (noiseOcean < -0.15f) {
            biome = noiseOcean < -0.65f ? EnumBiome.MUSHROOM_ISLAND_SHORE : (rainfall < 0.0f ? (temperature < -0.45f ? EnumBiome.FROZEN_OCEAN : (temperature < -0.15f ? EnumBiome.COLD_OCEAN : (temperature < 0.2f ? EnumBiome.OCEAN : (temperature < 0.55f ? EnumBiome.LUKEWARM_OCEAN : EnumBiome.WARM_OCEAN)))) : (temperature < -0.45f ? EnumBiome.DEEP_FROZEN_OCEAN : (temperature < -0.15f ? EnumBiome.DEEP_COLD_OCEAN : (temperature < 0.2f ? EnumBiome.DEEP_OCEAN : (temperature < 0.55f ? EnumBiome.DEEP_LUKEWARM_OCEAN : EnumBiome.WARM_OCEAN)))));
        } else if (Math.abs(noiseRiver) < 0.04f) {
            biome = temperature < -0.379f ? EnumBiome.FROZEN_RIVER : EnumBiome.RIVER;
        } else {
            float hills = this.hills.noise2D(x, z, true);
            biome = temperature < -0.379f ? (noiseOcean < -0.12f ? EnumBiome.COLD_BEACH : (rainfall < 0.0f ? (hills < -0.1f ? EnumBiome.COLD_TAIGA : (hills < 0.5f ? EnumBiome.COLD_TAIGA_HILLS : EnumBiome.COLD_TAIGA_M)) : (hills < 0.0f ? EnumBiome.ICE_MOUNTAINS : (hills < 0.7f ? EnumBiome.ICE_PLAINS : EnumBiome.ICE_PLAINS_SPIKES)))) : (noiseOcean < -0.12f ? EnumBiome.BEACH : (temperature < 0.0f ? (hills < 0.2f ? (rainfall < -0.5f ? EnumBiome.EXTREME_HILLS_M : (rainfall > 0.5f ? EnumBiome.EXTREME_HILLS_PLUS_M : (rainfall < 0.0f ? EnumBiome.EXTREME_HILLS : EnumBiome.EXTREME_HILLS_PLUS))) : (rainfall < -0.6f ? (hills < 0.6f ? EnumBiome.MEGA_TAIGA_HILLS : EnumBiome.MEGA_TAIGA) : (rainfall > 0.6f ? (hills < 0.6f ? EnumBiome.MEGA_SPRUCE_TAIGA_HILLS : EnumBiome.MEGA_SPRUCE_TAIGA) : (rainfall < 0.2f ? (hills < 0.6f ? EnumBiome.TAIGA_HILLS : EnumBiome.TAIGA) : EnumBiome.TAIGA_M)))) : (temperature < 0.5f ? (temperature < 0.25f ? (rainfall < 0.0f ? (noiseOcean < 0.0f ? EnumBiome.SUNFLOWER_PLAINS : EnumBiome.PLAINS) : (rainfall < 0.25f ? (noiseOcean < 0.0f ? EnumBiome.FLOWER_FOREST : (hills < 0.0f ? EnumBiome.FOREST_HILLS : EnumBiome.FOREST)) : (noiseOcean < 0.0f ? (hills < 0.0f ? EnumBiome.BIRCH_FOREST_HILLS_M : EnumBiome.BIRCH_FOREST_M) : (hills < 0.0f ? EnumBiome.BIRCH_FOREST_HILLS : EnumBiome.BIRCH_FOREST)))) : (rainfall < -0.2f ? (noiseOcean < 0.0f ? EnumBiome.SWAMPLAND_M : EnumBiome.SWAMP) : (rainfall > 0.1f ? (noiseOcean < 0.155f ? EnumBiome.JUNGLE_M : (hills < 0.0f ? (rainfall < 0.2f ? EnumBiome.BAMBOO_JUNGLE_HILLS : EnumBiome.JUNGLE_HILLS) : (rainfall < 0.2f ? EnumBiome.BAMBOO_JUNGLE : EnumBiome.JUNGLE))) : (noiseOcean < 0.0f ? EnumBiome.ROOFED_FOREST_M : EnumBiome.ROOFED_FOREST)))) : (rainfall < 0.0f ? (noiseOcean < 0.0f ? EnumBiome.DESERT_M : (hills < 0.0f ? EnumBiome.DESERT_HILLS : EnumBiome.DESERT)) : (rainfall > 0.4f ? (noiseOcean < 0.155f ? (hills < 0.0f ? EnumBiome.SAVANNA_PLATEAU_M : EnumBiome.SAVANNA_M) : (hills < 0.0f ? EnumBiome.SAVANNA_PLATEAU : EnumBiome.SAVANNA)) : (noiseOcean < 0.0f ? (hills < 0.0f ? EnumBiome.MESA_PLATEAU_F : EnumBiome.MESA_PLATEAU_F_M) : (hills < 0.0f ? (noiseOcean < 0.2f ? EnumBiome.MESA_PLATEAU_M : EnumBiome.MESA_PLATEAU) : (noiseOcean < 0.1f ? EnumBiome.MESA_BRYCE : EnumBiome.MESA))))))));
        }
        return biome.biome;
    }
}

