/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockBed;
import cn.nukkit.block.BlockGrass;
import cn.nukkit.block.BlockLayer;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockObserver;
import cn.nukkit.block.BlockRedstoneDiode;
import cn.nukkit.block.BlockScaffolding;
import cn.nukkit.block.BlockShulkerBox;
import cn.nukkit.block.BlockSlab;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.custom.EntityDefinition;
import cn.nukkit.entity.custom.EntityManager;
import cn.nukkit.entity.item.EntityItem;
import cn.nukkit.entity.item.EntityXPOrb;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.entity.weather.EntityLightning;
import cn.nukkit.event.block.BlockBreakEvent;
import cn.nukkit.event.block.BlockPlaceEvent;
import cn.nukkit.event.block.BlockUpdateEvent;
import cn.nukkit.event.level.ChunkLoadEvent;
import cn.nukkit.event.level.ChunkPopulateEvent;
import cn.nukkit.event.level.ChunkUnloadEvent;
import cn.nukkit.event.level.LevelSaveEvent;
import cn.nukkit.event.level.LevelUnloadEvent;
import cn.nukkit.event.level.SpawnChangeEvent;
import cn.nukkit.event.level.ThunderChangeEvent;
import cn.nukkit.event.level.WeatherChangeEvent;
import cn.nukkit.event.player.PlayerInteractEvent;
import cn.nukkit.event.weather.LightningStrikeEvent;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.item.ItemBucket;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.level.AsyncChunkData;
import cn.nukkit.level.AsyncChunkThread;
import cn.nukkit.level.ChunkLoader;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.DimensionData;
import cn.nukkit.level.EnumLevel;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.GameRules;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.level.ParticleEffect;
import cn.nukkit.level.Position;
import cn.nukkit.level.Sound;
import cn.nukkit.level.biome.Biome;
import cn.nukkit.level.format.Chunk;
import cn.nukkit.level.format.ChunkSection;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.level.format.anvil.Anvil;
import cn.nukkit.level.format.generic.BaseChunk;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.format.generic.EmptyChunkSection;
import cn.nukkit.level.generator.Generator;
import cn.nukkit.level.generator.GeneratorTaskFactory;
import cn.nukkit.level.generator.PopChunkManager;
import cn.nukkit.level.generator.task.GenerationTask;
import cn.nukkit.level.generator.task.PopulationTask;
import cn.nukkit.level.particle.DestroyBlockParticle;
import cn.nukkit.level.particle.ItemBreakParticle;
import cn.nukkit.level.particle.Particle;
import cn.nukkit.level.persistence.PersistentDataContainer;
import cn.nukkit.level.persistence.impl.DelegatePersistentDataContainer;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.MathHelper;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector2;
import cn.nukkit.math.Vector3;
import cn.nukkit.math.Vector3f;
import cn.nukkit.metadata.BlockMetadataStore;
import cn.nukkit.metadata.MetadataValue;
import cn.nukkit.metadata.Metadatable;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.network.protocol.AddEntityPacket;
import cn.nukkit.network.protocol.BatchPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.GameRulesChangedPacket;
import cn.nukkit.network.protocol.LevelEventPacket;
import cn.nukkit.network.protocol.LevelSoundEventPacket;
import cn.nukkit.network.protocol.MoveEntityAbsolutePacket;
import cn.nukkit.network.protocol.MovePlayerPacket;
import cn.nukkit.network.protocol.PlaySoundPacket;
import cn.nukkit.network.protocol.SetSpawnPositionPacket;
import cn.nukkit.network.protocol.SetTimePacket;
import cn.nukkit.network.protocol.SpawnParticleEffectPacket;
import cn.nukkit.network.protocol.UpdateBlockPacket;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.scheduler.AsyncTask;
import cn.nukkit.scheduler.BlockUpdateScheduler;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.BlockUpdateEntry;
import cn.nukkit.utils.Hash;
import cn.nukkit.utils.LevelException;
import cn.nukkit.utils.MainLogger;
import cn.nukkit.utils.TextFormat;
import cn.nukkit.utils.Utils;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.ref.SoftReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import lombok.Generated;

public class Level
implements ChunkManager,
Metadatable,
GeneratorTaskFactory {
    private static int levelIdCounter = 1;
    private static int chunkLoaderCounter = 1;
    public static final int BLOCK_UPDATE_NORMAL = 1;
    public static final int BLOCK_UPDATE_RANDOM = 2;
    public static final int BLOCK_UPDATE_SCHEDULED = 3;
    public static final int BLOCK_UPDATE_WEAK = 4;
    public static final int BLOCK_UPDATE_TOUCH = 5;
    public static final int BLOCK_UPDATE_REDSTONE = 6;
    public static final int BLOCK_UPDATE_TICK = 7;
    public static final int TIME_DAY = 0;
    public static final int TIME_NOON = 6000;
    public static final int TIME_SUNSET = 12000;
    public static final int TIME_NIGHT = 14000;
    public static final int TIME_MIDNIGHT = 18000;
    public static final int TIME_SUNRISE = 23000;
    public static final int TIME_FULL = 24000;
    public static final int DIMENSION_OVERWORLD = 0;
    public static final int DIMENSION_NETHER = 1;
    public static final int DIMENSION_THE_END = 2;
    public static final int MAX_BLOCK_CACHE = 1024;
    private static final int LCG_CONSTANT = 1013904223;
    private static final boolean[] randomTickBlocks = new boolean[Block.MAX_BLOCK_ID];
    private final Long2ObjectOpenHashMap<BlockEntity> blockEntities = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<Player> players = new Long2ObjectOpenHashMap();
    public final Long2ObjectOpenHashMap<Entity> entities = new Long2ObjectOpenHashMap();
    public final Long2ObjectOpenHashMap<Entity> updateEntities = new Long2ObjectOpenHashMap();
    private final ConcurrentLinkedQueue<BlockEntity> updateBlockEntities = new ConcurrentLinkedQueue();
    private final Server server;
    private final int levelId;
    private LevelProvider provider;
    private final Int2ObjectMap<ChunkLoader> loaders = new Int2ObjectOpenHashMap<ChunkLoader>();
    private final Int2IntMap loaderCounter = new Int2IntOpenHashMap();
    private final Long2ObjectOpenHashMap<Map<Integer, ChunkLoader>> chunkLoaders = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<Map<Integer, Player>> playerLoaders = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<Deque<DataPacket>> chunkPackets = new Long2ObjectOpenHashMap();
    private final Long2LongMap unloadQueue = Long2LongMaps.synchronize(new Long2LongOpenHashMap());
    private int time;
    public boolean stopTime;
    public int sleepTicks;
    public float skyLightSubtracted;
    public boolean lightUpdatesEnabled = true;
    private final String folderName;
    private final Long2ObjectOpenHashMap<SoftReference<Map<Integer, Object>>> changedBlocks = new Long2ObjectOpenHashMap();
    private final Object changeBlocksPresent = new Object();
    private final Int2ObjectOpenHashMap<Object> changeBlocksFullMap = new Int2ObjectOpenHashMap();
    private final BlockUpdateScheduler updateQueue;
    private final Queue<Block> normalUpdateQueue = new ConcurrentLinkedDeque<Block>();
    private final Map<Long, Set<Integer>> lightQueue = new ConcurrentHashMap<Long, Set<Integer>>(8, 0.9f, 1);
    private final ConcurrentMap<Long, Int2ObjectMap<Player>> chunkSendQueue = new ConcurrentHashMap<Long, Int2ObjectMap<Player>>();
    private final LongSet chunkSendTasks = new LongOpenHashSet();
    private final LongOpenHashSet chunkPopulationQueue = new LongOpenHashSet();
    private final LongOpenHashSet chunkPopulationLock = new LongOpenHashSet();
    private final LongOpenHashSet chunkGenerationQueue = new LongOpenHashSet();
    private final int chunkGenerationQueueSize;
    private final int chunkPopulationQueueSize;
    private boolean autoSave;
    private boolean saveOnUnloadEnabled = true;
    public boolean isBeingConverted;
    private BlockMetadataStore blockMetadata;
    private final boolean useSections;
    private boolean useChunkLoaderApi;
    private final Vector3 temporalVector = new Vector3(0.0, 0.0, 0.0);
    private final int chunkTickRadius;
    private final Long2IntMap chunkTickList = new Long2IntOpenHashMap();
    private final int chunksPerTicks;
    private final boolean clearChunksOnTick;
    private int updateLCG = ThreadLocalRandom.current().nextInt();
    private int tickRate = 1;
    public int tickRateTime;
    public int tickRateCounter;
    private long levelCurrentTick;
    private boolean raining;
    private int rainTime;
    private boolean thundering;
    private int thunderTime;
    private Class<? extends Generator> generatorClass;
    private ThreadLocal<Generator> generators = new ThreadLocal<Generator>(){

        @Override
        public Generator initialValue() {
            try {
                Generator generator = (Generator)Level.this.generatorClass.getConstructor(Map.class).newInstance(Level.this.provider.getGeneratorOptions());
                NukkitRandom rand = new NukkitRandom(Level.this.getSeed());
                if (Server.getInstance().isPrimaryThread()) {
                    generator.init(Level.this, rand);
                }
                generator.init(new PopChunkManager(Level.this.getSeed(), Level.this::getDimensionData), rand);
                return generator;
            }
            catch (Throwable e) {
                Server.getInstance().getLogger().logException(e);
                return null;
            }
        }
    };
    private DimensionData dimensionData;
    public GameRules gameRules;
    private final AsyncChunkThread asyncChunkThread;
    private GeneratorTaskFactory generatorTaskFactory = this;
    private int lastUnloadIndex;

    public Level(Server server, String name, String path, Class<? extends LevelProvider> provider) {
        this.levelId = levelIdCounter++;
        this.server = server;
        this.folderName = name;
        this.autoSave = server.getAutoSave();
        this.blockMetadata = new BlockMetadataStore(this);
        try {
            this.provider = provider.getConstructor(Level.class, String.class).newInstance(this, path);
        }
        catch (Exception e) {
            throw new LevelException("Caused by " + Utils.getExceptionMessage(e));
        }
        this.provider.updateLevelName(name);
        this.server.getLogger().info(this.server.getLanguage().translateString("nukkit.level.preparing", (Object)((Object)TextFormat.GREEN) + name + (Object)((Object)TextFormat.WHITE)));
        if (this.provider instanceof Anvil) {
            this.server.getLogger().warning("Level \"" + name + "\" is in old format. Convert it to enable new features. Type 'convert " + name + "' to get started.");
        }
        this.generatorClass = Generator.getGenerator(this.provider.getGenerator());
        try {
            this.useSections = (Boolean)provider.getMethod("usesChunkSection", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.time = (int)this.provider.getTime();
        this.raining = this.provider.isRaining();
        this.rainTime = this.provider.getRainTime();
        if (this.rainTime <= 0) {
            this.setRainTime(ThreadLocalRandom.current().nextInt(168000) + 12000);
        }
        this.thundering = this.provider.isThundering();
        this.thunderTime = this.provider.getThunderTime();
        if (this.thunderTime <= 0) {
            this.setThunderTime(ThreadLocalRandom.current().nextInt(168000) + 12000);
        }
        this.levelCurrentTick = this.provider.getCurrentTick();
        this.updateQueue = new BlockUpdateScheduler(this, this.levelCurrentTick);
        this.chunkTickRadius = Math.min(this.server.getViewDistance(), Math.max(1, this.server.getConfig("chunk-ticking.tick-radius", 3)));
        this.chunksPerTicks = this.server.getConfig("chunk-ticking.per-tick", 40);
        this.chunkGenerationQueueSize = this.server.getConfig("chunk-generation.queue-size", 8);
        this.chunkPopulationQueueSize = this.server.getConfig("chunk-generation.population-queue-size", 8);
        this.clearChunksOnTick = this.server.getConfig("chunk-ticking.clear-tick-list", false);
        this.skyLightSubtracted = this.calculateSkylightSubtracted(1.0f);
        this.asyncChunkThread = new AsyncChunkThread(name);
    }

    public static long chunkHash(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public static long blockHash(int x, int y, int z, DimensionData dimensionData) {
        return ((long)x & 0xFFFFFFFL) << 36 | (long)(Level.capWorldY(y, dimensionData) - dimensionData.getMinHeight()) << 28 | (long)z & 0xFFFFFFFL;
    }

    public static int localBlockHash(double x, double y, double z, DimensionData dimensionData) {
        byte hi = (byte)(((int)x & 0xF) + (((int)z & 0xF) << 4));
        short lo = (short)(Level.capWorldY((int)y, dimensionData) - dimensionData.getMinHeight());
        return (hi & 0xFF) << 16 | lo;
    }

    public static Vector3 getBlockXYZ(long chunkHash, int blockHash, DimensionData dimensionData) {
        byte hi = (byte)(blockHash >>> 16);
        short lo = (short)blockHash;
        int y = Level.capWorldY(lo + dimensionData.getMinHeight(), dimensionData);
        int x = (hi & 0xF) + (Level.getHashX(chunkHash) << 4);
        int z = (hi >> 4 & 0xF) + (Level.getHashZ(chunkHash) << 4);
        return new Vector3(x, y, z);
    }

    public static BlockVector3 blockHash(double x, double y, double z) {
        return new BlockVector3((int)x, (int)y, (int)z);
    }

    public static int chunkBlockHash(int x, int y, int z) {
        return x << 13 | z << 9 | y + 64;
    }

    public static int getHashX(long hash) {
        return (int)(hash >> 32);
    }

    public static int getHashZ(long hash) {
        return (int)hash;
    }

    public static Vector3 getBlockXYZ(BlockVector3 hash) {
        return new Vector3(hash.x, hash.y, hash.z);
    }

    public static Chunk.Entry getChunkXZ(long hash) {
        return new Chunk.Entry(Level.getHashX(hash), Level.getHashZ(hash));
    }

    private static int capWorldY(int y, DimensionData dimensionData) {
        return Math.max(Math.min(y, dimensionData.getMaxHeight()), dimensionData.getMinHeight());
    }

    public static int generateChunkLoaderId(ChunkLoader loader) {
        if (loader.getLoaderId() == 0) {
            return chunkLoaderCounter++;
        }
        throw new IllegalStateException("ChunkLoader has a loader id already assigned: " + loader.getLoaderId());
    }

    public int getTickRate() {
        return this.tickRate;
    }

    public int getTickRateTime() {
        return this.tickRateTime;
    }

    public void setTickRate(int tickRate) {
        this.tickRate = tickRate;
    }

    public void initLevel() {
        Generator generator = this.generators.get();
        this.dimensionData = generator.getDimensionData();
        if (this.dimensionData.getDimensionId() == 0 && this.provider instanceof Anvil) {
            this.dimensionData = DimensionData.LEGACY_DIMENSION;
        }
        this.gameRules = this.provider.getGamerules();
    }

    public Generator getGenerator() {
        return this.generators.get();
    }

    public BlockMetadataStore getBlockMetadata() {
        return this.blockMetadata;
    }

    public Server getServer() {
        return this.server;
    }

    public final LevelProvider getProvider() {
        return this.provider;
    }

    public final int getId() {
        return this.levelId;
    }

    public void close() {
        if (this.asyncChunkThread != null) {
            this.asyncChunkThread.shutdown();
        }
        this.saveLevelData();
        this.provider.close();
        this.provider = null;
        this.blockMetadata = null;
        this.server.getLevels().remove(this.levelId);
    }

    public void addSound(Vector3 pos, Sound sound) {
        this.addSound(pos, sound, 1.0f, 1.0f, (Player[])null);
    }

    public void addSound(Vector3 pos, Sound sound, float volume, float pitch) {
        this.addSound(pos, sound, volume, pitch, (Player[])null);
    }

    public void addSound(Vector3 pos, Sound sound, float volume, float pitch, Collection<Player> players) {
        this.addSound(pos, sound, volume, pitch, players.toArray(new Player[0]));
    }

    public void addSound(Vector3 pos, Sound sound, float volume, float pitch, Player ... players) {
        if (volume < 0.0f || volume > 1.0f) {
            throw new IllegalArgumentException("Sound volume must be between 0 and 1");
        }
        if (pitch < 0.0f) {
            throw new IllegalArgumentException("Sound pitch must be higher than 0");
        }
        PlaySoundPacket packet = new PlaySoundPacket();
        packet.name = sound.getSound();
        packet.volume = volume;
        packet.pitch = pitch;
        packet.x = pos.getFloorX();
        packet.y = pos.getFloorY();
        packet.z = pos.getFloorZ();
        if (players == null || players.length == 0) {
            this.addChunkPacket(pos.getChunkX(), pos.getChunkZ(), packet);
        } else {
            Server.broadcastPacket(players, (DataPacket)packet);
        }
    }

    public void addLevelEvent(Vector3 pos, int event) {
        this.addLevelEvent(pos, event, 0);
    }

    public void addLevelEvent(Vector3 pos, int event, int data) {
        LevelEventPacket pk = new LevelEventPacket();
        pk.evid = event;
        pk.x = (float)pos.x;
        pk.y = (float)pos.y;
        pk.z = (float)pos.z;
        pk.data = data;
        this.addChunkPacket(pos.getChunkX(), pos.getChunkZ(), pk);
    }

    public void addLevelSoundEvent(Vector3 pos, int type, int data, int entityType) {
        this.addLevelSoundEvent(pos, type, data, entityType, false, false);
    }

    public void addLevelSoundEvent(Vector3 pos, int type, int data, int entityType, boolean isBaby, boolean isGlobal) {
        String identifier = AddEntityPacket.LEGACY_IDS.get(entityType);
        if (identifier == null) {
            EntityDefinition definition = EntityManager.get().getDefinition(entityType);
            identifier = definition == null ? ":" : definition.getIdentifier();
        }
        this.addLevelSoundEvent(pos, type, data, identifier, isBaby, isGlobal);
    }

    public void addLevelSoundEvent(Vector3 pos, int type) {
        this.addLevelSoundEvent(pos, type, -1);
    }

    public void addLevelSoundEvent(Vector3 pos, int type, int data) {
        this.addLevelSoundEvent(pos, type, data, "", false, false);
    }

    public void addLevelSoundEvent(Vector3 pos, int type, int data, String identifier, boolean isBaby, boolean isGlobal) {
        LevelSoundEventPacket pk = new LevelSoundEventPacket();
        pk.sound = type;
        pk.extraData = data;
        pk.entityIdentifier = identifier;
        pk.x = (float)pos.x;
        pk.y = (float)pos.y;
        pk.z = (float)pos.z;
        pk.isGlobal = isGlobal;
        pk.isBabyMob = isBaby;
        this.addChunkPacket(pos.getChunkX(), pos.getChunkZ(), pk);
    }

    public void addParticle(Particle particle) {
        this.addParticle(particle, (Player[])null);
    }

    public void addParticle(Particle particle, Player player) {
        this.addParticle(particle, new Player[]{player});
    }

    public void addParticle(Particle particle, Player[] players) {
        this.addParticle(particle, players, 1);
    }

    public void addParticle(Particle particle, Player[] players, int count) {
        DataPacket[] packets;
        if (players == null) {
            players = this.getChunkPlayers(particle.getChunkX(), particle.getChunkZ()).values().toArray(new Player[0]);
        }
        if ((packets = particle.encode()) != null) {
            for (int i = 0; i < count; ++i) {
                for (DataPacket pk : packets) {
                    Server.broadcastPacket(players, pk);
                }
            }
        }
    }

    public void addParticle(Particle particle, Collection<Player> players) {
        this.addParticle(particle, players.toArray(new Player[0]));
    }

    public void addParticleEffect(Vector3 pos, ParticleEffect particleEffect) {
        this.addParticleEffect(pos, particleEffect, -1L, this.getDimension(), (Player[])null);
    }

    public void addParticleEffect(Vector3 pos, ParticleEffect particleEffect, long uniqueEntityId) {
        this.addParticleEffect(pos, particleEffect, uniqueEntityId, this.getDimension(), (Player[])null);
    }

    public void addParticleEffect(Vector3 pos, ParticleEffect particleEffect, long uniqueEntityId, int dimensionId) {
        this.addParticleEffect(pos, particleEffect, uniqueEntityId, dimensionId, (Player[])null);
    }

    public void addParticleEffect(Vector3 pos, ParticleEffect particleEffect, long uniqueEntityId, int dimensionId, Collection<Player> players) {
        this.addParticleEffect(pos, particleEffect, uniqueEntityId, dimensionId, players.toArray(new Player[0]));
    }

    public void addParticleEffect(Vector3 pos, ParticleEffect particleEffect, long uniqueEntityId, int dimensionId, Player ... players) {
        this.addParticleEffect(pos.asVector3f(), particleEffect.getIdentifier(), uniqueEntityId, dimensionId, players);
    }

    public void addParticleEffect(Vector3f pos, String identifier, long uniqueEntityId, int dimensionId, Player ... players) {
        SpawnParticleEffectPacket pk = new SpawnParticleEffectPacket();
        pk.identifier = identifier;
        pk.uniqueEntityId = uniqueEntityId;
        pk.dimensionId = dimensionId;
        pk.position = pos;
        if (players == null || players.length == 0) {
            this.addChunkPacket(pos.getFloorX() >> 4, pos.getFloorZ() >> 4, pk);
        } else {
            Server.broadcastPacket(players, (DataPacket)pk);
        }
    }

    public boolean getAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public boolean unload() {
        return this.unload(false);
    }

    public boolean unload(boolean force) {
        LevelUnloadEvent ev = new LevelUnloadEvent(this);
        if (this == this.server.getDefaultLevel() && !force) {
            ev.setCancelled(true);
        }
        this.server.getPluginManager().callEvent(ev);
        if (!force && ev.isCancelled()) {
            return false;
        }
        this.server.getLogger().info(this.server.getLanguage().translateString("nukkit.level.unloading", (Object)((Object)TextFormat.GREEN) + this.getName() + (Object)((Object)TextFormat.WHITE)));
        Level defaultLevel = this.server.getDefaultLevel();
        for (Player player : new ArrayList<Player>(this.getPlayers().values())) {
            if (this == defaultLevel || defaultLevel == null) {
                player.close(player.getLeaveMessage(), "Forced default level unload");
                continue;
            }
            player.teleport(this.server.getDefaultLevel().getSafeSpawn());
        }
        if (this == defaultLevel) {
            this.server.setDefaultLevel(null);
        }
        this.close();
        return true;
    }

    public Map<Integer, Player> getChunkPlayers(int chunkX, int chunkZ) {
        long index = Level.chunkHash(chunkX, chunkZ);
        Map<Integer, Player> map = this.playerLoaders.get(index);
        if (map != null) {
            return new HashMap<Integer, Player>(map);
        }
        return new HashMap<Integer, Player>();
    }

    public ChunkLoader[] getChunkLoaders(int chunkX, int chunkZ) {
        long index = Level.chunkHash(chunkX, chunkZ);
        Map<Integer, ChunkLoader> map = this.chunkLoaders.get(index);
        if (map != null) {
            return map.values().toArray(new ChunkLoader[0]);
        }
        return new ChunkLoader[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChunkPacket(int chunkX, int chunkZ, DataPacket packet) {
        long index = Level.chunkHash(chunkX, chunkZ);
        Long2ObjectOpenHashMap<Deque<DataPacket>> long2ObjectOpenHashMap = this.chunkPackets;
        synchronized (long2ObjectOpenHashMap) {
            Deque packets = this.chunkPackets.computeIfAbsent(index, i -> new ArrayDeque());
            packets.add(packet);
        }
    }

    public void registerChunkLoader(ChunkLoader loader, int chunkX, int chunkZ) {
        this.registerChunkLoader(loader, chunkX, chunkZ, true);
    }

    public void registerChunkLoader(ChunkLoader loader, int chunkX, int chunkZ, boolean autoLoad) {
        if (!(loader instanceof Player) && !this.useChunkLoaderApi) {
            this.server.getLogger().debug("registerChunkLoader: full ChunkLoader API enabled");
            this.useChunkLoaderApi = true;
        }
        int hash = loader.getLoaderId();
        long index = Level.chunkHash(chunkX, chunkZ);
        Map<Integer, ChunkLoader> map = this.chunkLoaders.get(index);
        if (map == null) {
            HashMap<Integer, ChunkLoader> newChunkLoader = new HashMap<Integer, ChunkLoader>();
            newChunkLoader.put(hash, loader);
            this.chunkLoaders.put(index, (Map<Integer, ChunkLoader>)newChunkLoader);
            HashMap<Integer, Player> newPlayerLoader = new HashMap<Integer, Player>();
            if (loader instanceof Player) {
                newPlayerLoader.put(hash, (Player)loader);
            }
            this.playerLoaders.put(index, (Map<Integer, Player>)newPlayerLoader);
        } else {
            if (map.containsKey(hash)) {
                return;
            }
            map.put(hash, loader);
            if (loader instanceof Player) {
                this.playerLoaders.get(index).put(hash, (Player)loader);
            }
        }
        if (!this.loaders.containsKey(hash)) {
            this.loaderCounter.put(hash, 1);
            this.loaders.put(hash, loader);
        } else {
            this.loaderCounter.put(hash, this.loaderCounter.get(hash) + 1);
        }
        this.cancelUnloadChunkRequest(hash);
        if (autoLoad) {
            this.loadChunk(chunkX, chunkZ);
        }
    }

    public void unregisterChunkLoader(ChunkLoader loader, int chunkX, int chunkZ) {
        ChunkLoader oldLoader;
        int hash = loader.getLoaderId();
        long index = Level.chunkHash(chunkX, chunkZ);
        Map<Integer, ChunkLoader> chunkLoadersIndex = this.chunkLoaders.get(index);
        if (chunkLoadersIndex != null && (oldLoader = chunkLoadersIndex.remove(hash)) != null) {
            if (chunkLoadersIndex.isEmpty()) {
                this.chunkLoaders.remove(index);
                this.playerLoaders.remove(index);
                this.unloadChunkRequest(chunkX, chunkZ, true);
            } else {
                Map<Integer, Player> playerLoadersIndex = this.playerLoaders.get(index);
                playerLoadersIndex.remove(hash);
            }
            int count = this.loaderCounter.get(hash);
            if (--count <= 0) {
                this.loaderCounter.remove(hash);
                this.loaders.remove(hash);
            } else {
                this.loaderCounter.put(hash, count);
            }
        }
    }

    public void checkTime() {
        if (!this.stopTime && this.gameRules.getBoolean(GameRule.DO_DAYLIGHT_CYCLE)) {
            this.time += this.tickRate;
            if (this.time < 0) {
                this.time = 0;
            }
        }
    }

    public void sendTime(Player ... players) {
        SetTimePacket pk = new SetTimePacket();
        pk.time = this.time;
        Server.broadcastPacket(players, (DataPacket)pk);
    }

    public void sendTime() {
        this.sendTime(this.players.values().toArray(new Player[0]));
    }

    public GameRules getGameRules() {
        return this.gameRules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTick(int currentTick) {
        Block block;
        Long2ObjectMap.Entry entry;
        Long2ObjectOpenHashMap<Deque<DataPacket>> fastChunks;
        AsyncChunkData data;
        int sendCount = (this.players.size() + 1) * this.server.chunksPerTick;
        for (int i = 0; i < sendCount && (data = this.asyncChunkThread.out.poll()) != null; ++i) {
            this.chunkRequestCallback(data.timestamp, data.x, data.z, data.count, data.data, data.hash);
        }
        this.updateBlockLight(this.lightQueue);
        this.checkTime();
        if (currentTick % 6000 == 0) {
            this.sendTime();
        }
        if (this.getDimension() != 1 && this.getDimension() != 2 && this.gameRules.getBoolean(GameRule.DO_WEATHER_CYCLE)) {
            --this.rainTime;
            if (this.rainTime <= 0 && !this.setRaining(!this.raining)) {
                if (this.raining) {
                    this.setRainTime(ThreadLocalRandom.current().nextInt(12000) + 12000);
                } else {
                    this.setRainTime(ThreadLocalRandom.current().nextInt(168000) + 12000);
                }
            }
            --this.thunderTime;
            if (this.thunderTime <= 0 && !this.setThundering(!this.thundering)) {
                if (this.thundering) {
                    this.setThunderTime(ThreadLocalRandom.current().nextInt(12000) + 3600);
                } else {
                    this.setThunderTime(ThreadLocalRandom.current().nextInt(168000) + 12000);
                }
            }
            if (this.isThundering()) {
                Map<Long, ? extends FullChunk> chunks = this.getChunks();
                if (chunks instanceof Long2ObjectOpenHashMap) {
                    fastChunks = (Long2ObjectOpenHashMap)chunks;
                    ObjectIterator longIterator = fastChunks.long2ObjectEntrySet().fastIterator();
                    while (longIterator.hasNext()) {
                        entry = (Long2ObjectMap.Entry)longIterator.next();
                        this.performThunder(entry.getLongKey(), (FullChunk)entry.getValue());
                    }
                } else {
                    for (Map.Entry entry2 : chunks.entrySet()) {
                        this.performThunder((Long)entry2.getKey(), (FullChunk)entry2.getValue());
                    }
                }
            }
        }
        this.skyLightSubtracted = this.calculateSkylightSubtracted(1.0f);
        ++this.levelCurrentTick;
        this.unloadChunks();
        this.updateQueue.tick(this.levelCurrentTick);
        while ((block = this.normalUpdateQueue.poll()) != null) {
            block.onUpdate(1);
        }
        if (!this.updateEntities.isEmpty()) {
            fastChunks = new ArrayList<Long>(this.updateEntities.keySet()).iterator();
            while (fastChunks.hasNext()) {
                long l = (Long)fastChunks.next();
                Entity entity = this.updateEntities.get(l);
                if (entity == null) {
                    this.updateEntities.remove(l);
                    continue;
                }
                if (!entity.closed && entity.onUpdate(currentTick)) continue;
                this.updateEntities.remove(l);
            }
        }
        this.updateBlockEntities.removeIf(blockEntity -> !blockEntity.isValid() || !blockEntity.onUpdate());
        this.tickChunks();
        fastChunks = this.changedBlocks;
        synchronized (fastChunks) {
            if (!this.changedBlocks.isEmpty()) {
                if (!this.players.isEmpty()) {
                    ObjectIterator objectIterator = this.changedBlocks.long2ObjectEntrySet().fastIterator();
                    while (objectIterator.hasNext()) {
                        entry = (Long2ObjectMap.Entry)objectIterator.next();
                        long index = entry.getLongKey();
                        Map blocks = (Map)((SoftReference)entry.getValue()).get();
                        int chunkX = Level.getHashX(index);
                        int chunkZ = Level.getHashZ(index);
                        if (blocks == null || blocks.size() > 1024) {
                            BaseFullChunk chunk = this.getChunkIfLoaded(chunkX, chunkZ);
                            if (chunk == null) continue;
                            for (Player p : this.getChunkPlayers(chunkX, chunkZ).values()) {
                                p.onChunkChanged(chunk);
                            }
                            continue;
                        }
                        Player[] playerArray = this.getChunkPlayers(chunkX, chunkZ).values().toArray(new Player[0]);
                        Vector3[] blocksArray = new Vector3[blocks.size()];
                        int i = 0;
                        Iterator iterator = blocks.keySet().iterator();
                        while (iterator.hasNext()) {
                            int blockHash = (Integer)iterator.next();
                            Vector3 hash = Level.getBlockXYZ(index, blockHash, this.getDimensionData());
                            blocksArray[i++] = hash;
                        }
                        this.sendBlocks(playerArray, blocksArray, 3);
                    }
                }
                this.changedBlocks.clear();
            }
        }
        this.processChunkRequest();
        if (this.sleepTicks > 0 && --this.sleepTicks <= 0) {
            this.checkSleep();
        }
        fastChunks = this.chunkPackets;
        synchronized (fastChunks) {
            LongIterator longIterator = this.chunkPackets.keySet().iterator();
            while (longIterator.hasNext()) {
                int chunkZ;
                long index = (Long)longIterator.next();
                int chunkX = Level.getHashX(index);
                Map<Integer, Player> map = this.getChunkPlayers(chunkX, chunkZ = Level.getHashZ(index));
                if (map.isEmpty()) continue;
                Player[] chunkPlayers = map.values().toArray(new Player[0]);
                for (DataPacket pk : this.chunkPackets.get(index)) {
                    Server.broadcastPacket(chunkPlayers, pk);
                }
            }
            this.chunkPackets.clear();
        }
        if (this.gameRules.isStale()) {
            GameRulesChangedPacket packet = new GameRulesChangedPacket();
            packet.gameRulesMap = this.gameRules.getGameRules();
            Server.broadcastPacket(this.players.values(), (DataPacket)packet);
            this.gameRules.refresh();
        }
    }

    private void performThunder(long index, FullChunk chunk) {
        if (Utils.random.nextInt(100000) < 1) {
            int chunkZ;
            if (this.areNeighboringChunksLoaded(index)) {
                return;
            }
            int LCG = this.getUpdateLCG() >> 2;
            int chunkX = chunk.getX() << 4;
            Vector3 vector = this.adjustPosToNearbyEntity(new Vector3(chunkX + (LCG & 0xF), 0.0, (chunkZ = chunk.getZ() << 4) + (LCG >> 8 & 0xF)));
            Biome biome = Biome.getBiome(this.getBiomeId(vector.getFloorX(), vector.getFloorZ()));
            if (!biome.canRain()) {
                return;
            }
            int bId = this.getBlockIdAt(vector.getFloorX(), vector.getFloorY(), vector.getFloorZ());
            if (bId != 31 && bId != 8) {
                vector.y += 1.0;
            }
            CompoundTag nbt = new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", vector.x)).add(new DoubleTag("", vector.y)).add(new DoubleTag("", vector.z))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", 0.0f)).add(new FloatTag("", 0.0f)));
            EntityLightning bolt = (EntityLightning)Entity.createEntity(93, chunk, nbt, new Object[0]);
            LightningStrikeEvent ev = new LightningStrikeEvent(this, bolt);
            this.server.getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                bolt.spawnToAll();
            } else {
                bolt.setEffect(false);
            }
        }
    }

    public Vector3 adjustPosToNearbyEntity(Vector3 pos) {
        pos.y = this.getHighestBlockAt(pos.getFloorX(), pos.getFloorZ());
        AxisAlignedBB axisalignedbb = new SimpleAxisAlignedBB(pos.x, pos.y, pos.z, pos.getX(), this.getMaxBlockY(), pos.getZ()).expand(3.0, 3.0, 3.0);
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Entity entity : this.getCollidingEntities(axisalignedbb)) {
            if (!entity.isAlive() || !entity.canSeeSky()) continue;
            list.add(entity);
        }
        if (!list.isEmpty()) {
            return ((Entity)list.get(Utils.random.nextInt(list.size()))).getPosition();
        }
        if (pos.getY() == -1.0) {
            pos = pos.up(2);
        }
        return pos;
    }

    public void checkSleep() {
        int time;
        if (this.players.isEmpty()) {
            return;
        }
        int playerCount = 0;
        int sleepingPlayerCount = 0;
        for (Player p : this.players.values()) {
            if (p.isSpectator()) continue;
            ++playerCount;
            if (!p.isSleeping()) continue;
            ++sleepingPlayerCount;
        }
        if (playerCount > 0 && sleepingPlayerCount / playerCount * 100 >= this.gameRules.getInteger(GameRule.PLAYERS_SLEEPING_PERCENTAGE) && ((time = this.getTime() % 24000) >= 14000 && time < 23000 || this.isThundering())) {
            this.setTime(this.getTime() + 24000 - time);
            if (this.isThundering()) {
                this.setThundering(false);
                this.setRaining(false);
            }
            for (Player p : this.getPlayers().values()) {
                p.stopSleep();
            }
        }
    }

    public void sendBlockExtraData(int x, int y, int z, int id, int data) {
        this.sendBlockExtraData(x, y, z, id, data, this.getChunkPlayers(x >> 4, z >> 4).values());
    }

    public void sendBlockExtraData(int x, int y, int z, int id, int data, Collection<Player> players) {
        this.sendBlockExtraData(x, y, z, id, data, players.toArray(new Player[0]));
    }

    public void sendBlockExtraData(int x, int y, int z, int id, int data, Player[] players) {
        LevelEventPacket pk = new LevelEventPacket();
        pk.evid = 4000;
        pk.x = (float)x + 0.5f;
        pk.y = (float)y + 0.5f;
        pk.z = (float)z + 0.5f;
        pk.data = data << 8 | id;
        Server.broadcastPacket(players, (DataPacket)pk);
    }

    public void sendBlocks(Player[] target, Vector3[] blocks) {
        this.sendBlocks(target, blocks, 0);
    }

    public void sendBlocks(Player[] target, Vector3[] blocks, int flags) {
        this.sendBlocks(target, blocks, flags, false, Block.LAYER_NORMAL);
        this.sendBlocks(target, blocks, flags, false, Block.LAYER_WATERLOGGED);
    }

    public void sendBlocks(Player[] target, Vector3[] blocks, int flags, boolean optimizeRebuilds) {
        this.sendBlocks(target, blocks, flags, optimizeRebuilds, Block.LAYER_NORMAL);
        this.sendBlocks(target, blocks, flags, optimizeRebuilds, Block.LAYER_WATERLOGGED);
    }

    public void sendBlocks(Player[] target, Vector3[] blocks, int flags, BlockLayer blockLayer) {
        this.sendBlocks(target, blocks, flags, false, blockLayer);
    }

    public void sendBlocks(Player[] target, Vector3[] blocks, int flags, boolean optimizeRebuilds, BlockLayer layer) {
        LongOpenHashSet chunks = null;
        if (optimizeRebuilds) {
            chunks = new LongOpenHashSet();
        }
        for (Vector3 b : blocks) {
            long index;
            boolean first;
            if (b == null) continue;
            boolean bl = first = !optimizeRebuilds;
            if (optimizeRebuilds && !chunks.contains(index = Level.chunkHash((int)b.x >> 4, (int)b.z >> 4))) {
                chunks.add(index);
                first = true;
            }
            UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
            updateBlockPacket.x = (int)b.x;
            updateBlockPacket.y = (int)b.y;
            updateBlockPacket.z = (int)b.z;
            updateBlockPacket.flags = first ? flags : 0;
            updateBlockPacket.dataLayer = layer.ordinal();
            Block block = b instanceof Block && ((Block)b).getLayer() == layer ? (Block)b : this.getBlockAsyncIfLoaded(null, (int)b.x, (int)b.y, (int)b.z, layer);
            UpdateBlockPacket packet = (UpdateBlockPacket)updateBlockPacket.clone();
            try {
                int fullBlock = block.getFullId();
                packet.blockRuntimeId = GlobalBlockPalette.getOrCreateRuntimeId(fullBlock);
            }
            catch (NoSuchElementException e) {
                throw new IllegalStateException("Unable to create BlockUpdatePacket at (" + b.x + ", " + b.y + ", " + b.z + ") in " + this.getName());
            }
            Server.broadcastPacket(target, (DataPacket)packet);
        }
    }

    public void sendBlocks(Player target, Vector3[] blocks, int flags) {
        for (Vector3 b : blocks) {
            if (b == null) continue;
            UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
            updateBlockPacket.x = (int)b.x;
            updateBlockPacket.y = (int)b.y;
            updateBlockPacket.z = (int)b.z;
            updateBlockPacket.flags = flags;
            Block block = b instanceof Block ? (Block)b : this.getBlockAsyncIfLoaded(target.chunk, (int)b.x, (int)b.y, (int)b.z, BlockLayer.NORMAL);
            try {
                updateBlockPacket.blockRuntimeId = GlobalBlockPalette.getOrCreateRuntimeId(block.getFullId());
            }
            catch (NoSuchElementException e) {
                throw new IllegalStateException("Unable to create BlockUpdatePacket at (" + b.x + ", " + b.y + ", " + b.z + ") in " + this.getName() + " for player " + target.getName());
            }
            target.dataPacket(updateBlockPacket);
        }
    }

    private void tickChunks() {
        if (this.chunksPerTicks <= 0 || this.loaders.isEmpty()) {
            this.chunkTickList.clear();
            return;
        }
        int chunksPerLoader = Math.min(200, Math.max(1, (int)((double)(this.chunksPerTicks - this.loaders.size()) / (double)this.loaders.size() + 0.5)));
        int randRange = 3 + chunksPerLoader / 30;
        randRange = Math.min(randRange, this.chunkTickRadius);
        for (ChunkLoader loader : this.loaders.values()) {
            int chunkX = NukkitMath.floorDouble(loader.getX()) >> 4;
            int chunkZ = NukkitMath.floorDouble(loader.getZ()) >> 4;
            long index = Level.chunkHash(chunkX, chunkZ);
            int existingLoaders = Math.max(0, this.chunkTickList.getOrDefault(index, 0));
            this.chunkTickList.put(index, existingLoaders + 1);
            for (int chunk = 0; chunk < chunksPerLoader; ++chunk) {
                int dz;
                int dx = Utils.random.nextInt(randRange << 1) - randRange;
                long hash = Level.chunkHash(dx + chunkX, (dz = Utils.random.nextInt(randRange << 1) - randRange) + chunkZ);
                if (this.chunkTickList.containsKey(hash) || !this.provider.isChunkLoaded(hash)) continue;
                this.chunkTickList.put(hash, -1);
            }
        }
        int blockTest = 0;
        if (!this.chunkTickList.isEmpty()) {
            Iterator iter = this.chunkTickList.long2IntEntrySet().iterator();
            while (iter.hasNext()) {
                int chunkZ;
                Long2IntMap.Entry entry = (Long2IntMap.Entry)iter.next();
                long index = entry.getLongKey();
                if (!this.areNeighboringChunksLoaded(index)) {
                    iter.remove();
                    continue;
                }
                int loaders = entry.getIntValue();
                int chunkX = Level.getHashX(index);
                BaseFullChunk chunk = this.getChunkIfLoaded(chunkX, chunkZ = Level.getHashZ(index));
                if (chunk == null) {
                    iter.remove();
                    continue;
                }
                if (loaders <= 0) {
                    iter.remove();
                }
                for (Entity entity : chunk.getEntities().values()) {
                    if (entity.updateMode >= 1 && (entity.updateMode % 3 != 2 || this.server.getTick() - entity.lastUpdate <= 300)) continue;
                    if (entity.updateMode % 2 == 1) {
                        entity.updateMode = 1;
                    }
                    entity.scheduleUpdate();
                }
                if (this.useSections) {
                    for (ChunkSection section : ((Chunk)((Object)chunk)).getSections()) {
                        if (section instanceof EmptyChunkSection) continue;
                        int Y = section.getY();
                        for (int i = 0; i < this.gameRules.getInteger(GameRule.RANDOM_TICK_SPEED); ++i) {
                            int z;
                            int y;
                            int n = ThreadLocalRandom.current().nextInt();
                            int x = n & 0xF;
                            int fullId = section.getFullBlock(x, y = n >> 16 & 0xF, z = n >> 8 & 0xF);
                            int blockId = fullId >> 6;
                            if (blockId >= randomTickBlocks.length || !randomTickBlocks[blockId]) continue;
                            Block block = Block.get(fullId, this, (chunkX << 4) + x, (Y << 4) + y, (chunkZ << 4) + z);
                            block.onUpdate(2);
                        }
                    }
                    continue;
                }
                for (int Y = 0; Y < 8 && (Y < 3 || blockTest != 0); ++Y) {
                    blockTest = 0;
                    for (int i = 0; i < this.gameRules.getInteger(GameRule.RANDOM_TICK_SPEED); ++i) {
                        int n = ThreadLocalRandom.current().nextInt();
                        int x = n & 0xF;
                        int z = n >> 8 & 0xF;
                        int y = n >> 16 & 0xF;
                        int fullId = chunk.getFullBlock(x, y + (Y << 4), z);
                        int blockId = fullId >> 6;
                        blockTest |= fullId;
                        if (blockId >= randomTickBlocks.length || !randomTickBlocks[blockId]) continue;
                        Block block = Block.get(fullId, this, x, y + (Y << 4), z);
                        block.onUpdate(2);
                    }
                }
            }
        }
        if (this.clearChunksOnTick) {
            this.chunkTickList.clear();
        }
    }

    public boolean save() {
        return this.save(false);
    }

    public boolean save(boolean force) {
        if (!(this.autoSave && !this.server.holdWorldSave || force)) {
            return false;
        }
        this.server.getPluginManager().callEvent(new LevelSaveEvent(this));
        this.saveLevelData();
        this.saveChunks();
        return true;
    }

    private void saveLevelData() {
        try {
            this.provider.setTime(this.time);
            this.provider.setRaining(this.raining);
            this.provider.setRainTime(this.rainTime);
            this.provider.setThundering(this.thundering);
            this.provider.setThunderTime(this.thunderTime);
            this.provider.setCurrentTick(this.levelCurrentTick);
            this.provider.setGameRules(this.gameRules);
            this.provider.saveLevelData();
        }
        catch (Exception ex) {
            Server.getInstance().getLogger().error("Failed to save level data for " + this.getFolderName(), ex);
        }
    }

    public void saveChunks() {
        this.provider.saveChunks();
    }

    public void updateAroundRedstone(Vector3 pos, BlockFace ignoredFace) {
        for (BlockFace side : BlockFace.values()) {
            if (ignoredFace != null && side == ignoredFace) continue;
            Vector3 sideVec = pos.getSideVec(side);
            this.getBlock(sideVec).onUpdate(6);
        }
    }

    public void updateComparatorOutputLevel(Vector3 v) {
        for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
            Vector3 pos = v.getSideVec(face);
            if (!this.isChunkLoaded((int)pos.x >> 4, (int)pos.z >> 4)) continue;
            Block block1 = this.getBlock(pos);
            if (BlockRedstoneDiode.isDiode(block1)) {
                block1.onUpdate(6);
                continue;
            }
            if (!block1.isNormalBlock() || !BlockRedstoneDiode.isDiode(block1 = this.getBlock(pos = pos.getSideVec(face)))) continue;
            block1.onUpdate(6);
        }
    }

    public void updateAround(Vector3 pos) {
        this.updateAround((int)pos.x, (int)pos.y, (int)pos.z, Block.LAYER_NORMAL);
        this.updateAround((int)pos.x, (int)pos.y, (int)pos.z, Block.LAYER_WATERLOGGED);
    }

    public void updateAround(int x, int y, int z) {
        this.updateAround(x, y, z, Block.LAYER_NORMAL);
        this.updateAround(x, y, z, Block.LAYER_WATERLOGGED);
    }

    public void updateAround(int x, int y, int z, BlockLayer layer) {
        Vector3 updatePos = new Vector3(x, y, z);
        BlockUpdateEvent ev = new BlockUpdateEvent(this.getBlock(null, x, y - 1, z, layer, true).setUpdatePos(updatePos));
        this.server.getPluginManager().callEvent(ev);
        if (!ev.isCancelled()) {
            this.normalUpdateQueue.add(ev.getBlock());
        }
        ev = new BlockUpdateEvent(this.getBlock(null, x, y + 1, z, layer, true).setUpdatePos(updatePos));
        this.server.getPluginManager().callEvent(ev);
        if (!ev.isCancelled()) {
            this.normalUpdateQueue.add(ev.getBlock());
        }
        ev = new BlockUpdateEvent(this.getBlock(null, x - 1, y, z, layer, true).setUpdatePos(updatePos));
        this.server.getPluginManager().callEvent(ev);
        if (!ev.isCancelled()) {
            this.normalUpdateQueue.add(ev.getBlock());
        }
        ev = new BlockUpdateEvent(this.getBlock(null, x + 1, y, z, layer, true).setUpdatePos(updatePos));
        this.server.getPluginManager().callEvent(ev);
        if (!ev.isCancelled()) {
            this.normalUpdateQueue.add(ev.getBlock());
        }
        ev = new BlockUpdateEvent(this.getBlock(null, x, y, z - 1, layer, true).setUpdatePos(updatePos));
        this.server.getPluginManager().callEvent(ev);
        if (!ev.isCancelled()) {
            this.normalUpdateQueue.add(ev.getBlock());
        }
        ev = new BlockUpdateEvent(this.getBlock(null, x, y, z + 1, layer, true).setUpdatePos(updatePos));
        this.server.getPluginManager().callEvent(ev);
        if (!ev.isCancelled()) {
            this.normalUpdateQueue.add(ev.getBlock());
        }
    }

    public void scheduleUpdate(Block pos, int delay) {
        this.scheduleUpdate(pos, pos, delay, 0, true);
    }

    public void scheduleUpdate(Block block, Vector3 pos, int delay) {
        this.scheduleUpdate(block, pos, delay, 0, true);
    }

    public void scheduleUpdate(Block block, Vector3 pos, int delay, int priority) {
        this.scheduleUpdate(block, pos, delay, priority, true);
    }

    public void scheduleUpdate(Block block, Vector3 pos, int delay, int priority, boolean checkArea) {
        if (block.getId() == 0 || checkArea && !this.isChunkLoaded(block.getChunkX(), block.getChunkZ())) {
            return;
        }
        BlockUpdateEntry entry = new BlockUpdateEntry(pos.floor(), block, (long)delay + this.levelCurrentTick, priority);
        if (!this.updateQueue.contains(entry)) {
            this.updateQueue.add(entry);
        }
    }

    public boolean cancelSheduledUpdate(Vector3 pos, Block block) {
        return this.updateQueue.remove(new BlockUpdateEntry(pos, block));
    }

    public boolean isUpdateScheduled(Vector3 pos, Block block) {
        return this.updateQueue.contains(new BlockUpdateEntry(pos, block));
    }

    public boolean isBlockTickPending(Vector3 pos, Block block) {
        return this.updateQueue.isBlockTickPending(pos, block);
    }

    public Set<BlockUpdateEntry> getPendingBlockUpdates(FullChunk chunk) {
        int minX = (chunk.getX() << 4) - 2;
        int maxX = minX + 18;
        int minZ = (chunk.getZ() << 4) - 2;
        int maxZ = minZ + 18;
        return this.getPendingBlockUpdates(new SimpleAxisAlignedBB(minX, this.getMinBlockY(), minZ, maxX, this.getMaxBlockY(), maxZ));
    }

    public Set<BlockUpdateEntry> getPendingBlockUpdates(AxisAlignedBB boundingBox) {
        return this.updateQueue.getPendingBlockUpdates(boundingBox);
    }

    public Block[] getCollisionBlocks(AxisAlignedBB bb) {
        return this.getCollisionBlocks(bb, false);
    }

    public Block[] getCollisionBlocks(AxisAlignedBB bb, boolean targetFirst) {
        return this.getCollisionBlocks(null, bb, targetFirst);
    }

    public Block[] getCollisionBlocks(Entity entity, AxisAlignedBB bb, boolean targetFirst) {
        int minX = NukkitMath.floorDouble(bb.getMinX());
        int minY = NukkitMath.floorDouble(bb.getMinY());
        int minZ = NukkitMath.floorDouble(bb.getMinZ());
        int maxX = NukkitMath.ceilDouble(bb.getMaxX());
        int maxY = NukkitMath.ceilDouble(bb.getMaxY());
        int maxZ = NukkitMath.ceilDouble(bb.getMaxZ());
        ArrayList<Block> collides = new ArrayList<Block>();
        if (targetFirst) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        Block block = this.getBlock(entity == null ? null : entity.chunk, x, y, z, false);
                        if (block == null || block.getId() == 0 || !block.collidesWithBB(bb)) continue;
                        return new Block[]{block};
                    }
                }
            }
        } else {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        Block block = this.getBlock(entity == null ? null : entity.chunk, x, y, z, false);
                        if (block == null || block.getId() == 0 || !block.collidesWithBB(bb)) continue;
                        collides.add(block);
                    }
                }
            }
        }
        return collides.toArray(new Block[0]);
    }

    public boolean hasCollisionBlocks(Entity entity, AxisAlignedBB bb) {
        int minX = NukkitMath.floorDouble(bb.getMinX());
        int minY = NukkitMath.floorDouble(bb.getMinY());
        int minZ = NukkitMath.floorDouble(bb.getMinZ());
        int maxX = NukkitMath.ceilDouble(bb.getMaxX());
        int maxY = NukkitMath.ceilDouble(bb.getMaxY());
        int maxZ = NukkitMath.ceilDouble(bb.getMaxZ());
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    Block block = this.getBlock(entity.chunk, x, y, z, false);
                    if (block == null || block.getId() == 0 || !block.collidesWithBB(bb)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isFullBlock(Vector3 pos) {
        AxisAlignedBB bb;
        if (pos instanceof Block) {
            if (((Block)pos).isSolid()) {
                return true;
            }
            bb = ((Block)pos).getBoundingBox();
        } else {
            bb = this.getBlock(pos).getBoundingBox();
        }
        return bb != null && bb.getAverageEdgeLength() >= 1.0;
    }

    public AxisAlignedBB[] getCollisionCubes(Entity entity, AxisAlignedBB bb) {
        return this.getCollisionCubes(entity, bb, true);
    }

    public AxisAlignedBB[] getCollisionCubes(Entity entity, AxisAlignedBB bb, boolean entities) {
        return this.getCollisionCubes(entity, bb, entities, false);
    }

    public AxisAlignedBB[] getCollisionCubes(Entity entity, AxisAlignedBB bb, boolean entities, boolean solidEntities) {
        if (entity.noClip) {
            return new AxisAlignedBB[0];
        }
        int minX = NukkitMath.floorDouble(bb.getMinX());
        int minY = NukkitMath.floorDouble(bb.getMinY());
        int minZ = NukkitMath.floorDouble(bb.getMinZ());
        int maxX = NukkitMath.ceilDouble(bb.getMaxX());
        int maxY = NukkitMath.ceilDouble(bb.getMaxY());
        int maxZ = NukkitMath.ceilDouble(bb.getMaxZ());
        ArrayList<AxisAlignedBB> collides = new ArrayList<AxisAlignedBB>();
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    Block block = this.getBlock(entity.chunk, x, y, z, false);
                    if (block.canPassThrough() || !block.collidesWithBB(bb)) continue;
                    collides.add(block.getBoundingBox());
                }
            }
        }
        if (entities || solidEntities) {
            for (Entity ent : this.getCollidingEntities(bb.grow(0.25, 0.25, 0.25), entity)) {
                if (!solidEntities || ent.canPassThrough()) continue;
                collides.add(ent.boundingBox.clone());
            }
        }
        return collides.toArray(new AxisAlignedBB[0]);
    }

    public boolean hasCollision(Entity entity, AxisAlignedBB bb, boolean entities) {
        int minX = NukkitMath.floorDouble(bb.getMinX());
        int minY = NukkitMath.floorDouble(bb.getMinY());
        int minZ = NukkitMath.floorDouble(bb.getMinZ());
        int maxX = NukkitMath.ceilDouble(bb.getMaxX());
        int maxY = NukkitMath.ceilDouble(bb.getMaxY());
        int maxZ = NukkitMath.ceilDouble(bb.getMaxZ());
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    Block block = this.getBlock(entity.chunk, x, y, z, false);
                    if (block.canPassThrough() || !block.collidesWithBB(bb)) continue;
                    return true;
                }
            }
        }
        if (entities) {
            return this.getCollidingEntities(bb.grow(0.25, 0.25, 0.25), entity).length > 0;
        }
        return false;
    }

    public int getFullLight(Vector3 pos) {
        if (pos.y < (double)this.getMinBlockY() || pos.y > (double)this.getMaxBlockY()) {
            return 0;
        }
        BaseFullChunk chunk = this.getChunk(pos.getChunkX(), pos.getChunkZ(), false);
        int level = 0;
        if (chunk != null) {
            level = chunk.getBlockSkyLight((int)pos.x & 0xF, (int)pos.y, (int)pos.z & 0xF);
            if ((level = (int)((float)level - this.skyLightSubtracted)) < 15) {
                level = Math.max(chunk.getBlockLight((int)pos.x & 0xF, (int)pos.y, (int)pos.z & 0xF), level);
            }
        }
        return level;
    }

    public int calculateSkylightSubtracted(float tickDiff) {
        float light = 1.0f - (MathHelper.cos(this.calculateCelestialAngle(this.getTime(), tickDiff) * ((float)Math.PI * 2)) * 2.0f + 0.5f);
        light = light < 0.0f ? 0.0f : (light > 1.0f ? 1.0f : light);
        light = 1.0f - light;
        light = (float)((double)light * ((double)(this.raining ? 1 : 0) - 0.3125));
        light = (float)((double)light * ((double)(this.isThundering() ? 1 : 0) - 0.3125));
        light = 1.0f - light;
        return (int)(light * 11.0f);
    }

    public float calculateCelestialAngle(int time, float tickDiff) {
        float angle = ((float)time + tickDiff) / 24000.0f - 0.25f;
        if (angle < 0.0f) {
            angle += 1.0f;
        }
        if (angle > 1.0f) {
            angle -= 1.0f;
        }
        float i = 1.0f - (float)((Math.cos((double)angle * Math.PI) + 1.0) / 2.0);
        angle += (i - angle) / 3.0f;
        return angle;
    }

    public int getMoonPhase(long worldTime) {
        return (int)(worldTime / 24000L % 8L + 8L) % 8;
    }

    public int getFullBlock(int x, int y, int z) {
        return this.getFullBlock(null, x, y, z);
    }

    public int getFullBlock(FullChunk chunk, int x, int y, int z) {
        if (y < this.getMinBlockY() || y > this.getMaxBlockY()) {
            return 0;
        }
        int cx = x >> 4;
        int cz = z >> 4;
        if (chunk == null || cx != chunk.getX() || cz != chunk.getZ()) {
            chunk = this.getChunk(cx, cz, false);
        }
        if (chunk == null) {
            return 0;
        }
        return chunk.getFullBlock(x & 0xF, y, z & 0xF, Block.LAYER_NORMAL);
    }

    public synchronized Block getBlock(Vector3 pos) {
        return this.getBlock(null, pos.getFloorX(), pos.getFloorY(), pos.getFloorZ(), Block.LAYER_NORMAL, true);
    }

    public synchronized Block getBlock(Vector3 pos, boolean load) {
        return this.getBlock(null, pos.getFloorX(), pos.getFloorY(), pos.getFloorZ(), Block.LAYER_NORMAL, load);
    }

    public synchronized Block getBlock(Vector3 pos, BlockLayer layer, boolean load) {
        return this.getBlock(null, pos.getFloorX(), pos.getFloorY(), pos.getFloorZ(), layer, load);
    }

    public synchronized Block getBlock(int x, int y, int z) {
        return this.getBlock(null, x, y, z, Block.LAYER_NORMAL, true);
    }

    public synchronized Block getBlock(int x, int y, int z, boolean load) {
        return this.getBlock(null, x, y, z, Block.LAYER_NORMAL, load);
    }

    public synchronized Block getBlock(FullChunk chunk, int x, int y, int z, boolean load) {
        return this.getBlock(chunk, x, y, z, Block.LAYER_NORMAL, load);
    }

    public synchronized Block getBlock(FullChunk chunk, int x, int y, int z, BlockLayer layer, boolean load) {
        int fullState;
        if (y >= this.getMinBlockY() && y <= this.getMaxBlockY()) {
            int cx = x >> 4;
            int cz = z >> 4;
            if (chunk == null || cx != chunk.getX() || cz != chunk.getZ()) {
                chunk = load ? this.getChunk(cx, cz) : this.getChunkIfLoaded(cx, cz);
            }
            fullState = chunk == null ? 0 : chunk.getFullBlock(x & 0xF, y, z & 0xF, layer);
        } else {
            fullState = 0;
        }
        Block block = Block.fullList[fullState].clone();
        block.x = x;
        block.y = y;
        block.z = z;
        block.level = this;
        block.setLayer(layer);
        return block;
    }

    private Block getBlockAsyncIfLoaded(FullChunk chunk, int x, int y, int z, BlockLayer layer) {
        int fullState;
        if (y >= this.getMinBlockY() && y <= this.getMaxBlockY()) {
            int cx = x >> 4;
            int cz = z >> 4;
            if (chunk == null || cx != chunk.getX() || cz != chunk.getZ()) {
                chunk = this.getChunkIfLoaded(cx, cz);
            }
            fullState = chunk == null ? 0 : chunk.getFullBlock(x & 0xF, y, z & 0xF, layer);
        } else {
            fullState = 0;
        }
        Block block = Block.fullList[fullState].clone();
        block.x = x;
        block.y = y;
        block.z = z;
        block.level = this;
        block.setLayer(layer);
        return block;
    }

    public void updateAllLight(Vector3 pos) {
        this.updateBlockSkyLight((int)pos.x, (int)pos.y, (int)pos.z);
        this.addLightUpdate((int)pos.x, (int)pos.y, (int)pos.z);
    }

    public void updateBlockSkyLight(int x, int y, int z) {
    }

    private void updateBlockLight(Map<Long, Set<Integer>> map) {
        int size = map.size();
        if (size == 0) {
            return;
        }
        ConcurrentLinkedQueue<Long> lightPropagationQueue = new ConcurrentLinkedQueue<Long>();
        ConcurrentLinkedQueue<Object[]> lightRemovalQueue = new ConcurrentLinkedQueue<Object[]>();
        LongOpenHashSet visited = new LongOpenHashSet();
        LongOpenHashSet removalVisited = new LongOpenHashSet();
        Iterator<Map.Entry<Long, Set<Integer>>> iter = map.entrySet().iterator();
        while (iter.hasNext() && size-- > 0) {
            Map.Entry<Long, Set<Integer>> entry = iter.next();
            iter.remove();
            long index = entry.getKey();
            Set<Integer> blocks = entry.getValue();
            for (int blockHash : blocks) {
                int newLevel;
                int lcz;
                int lcx;
                int oldLevel;
                Vector3 pos = Level.getBlockXYZ(index, blockHash, this.getDimensionData());
                BaseFullChunk chunk = this.getChunk((int)pos.x >> 4, (int)pos.z >> 4, false);
                if (chunk == null || (oldLevel = chunk.getBlockLight(lcx = (int)pos.x & 0xF, (int)pos.y, lcz = (int)pos.z & 0xF)) == (newLevel = Block.getBlockLight(chunk.getBlockId(lcx, (int)pos.y, lcz)))) continue;
                this.setBlockLightAt((int)pos.x, (int)pos.y, (int)pos.z, newLevel);
                long hash = Hash.hashBlock((int)pos.x, (int)pos.y, (int)pos.z);
                if (newLevel < oldLevel) {
                    removalVisited.add(hash);
                    lightRemovalQueue.add(new Object[]{hash, oldLevel});
                    continue;
                }
                visited.add(hash);
                lightPropagationQueue.add(hash);
            }
        }
        while (!lightRemovalQueue.isEmpty()) {
            Object[] val = (Object[])lightRemovalQueue.poll();
            long node = (Long)val[0];
            int x = Hash.hashBlockX(node);
            int y = Hash.hashBlockY(node);
            int z = Hash.hashBlockZ(node);
            int lightLevel = (Integer)val[1];
            this.computeRemoveBlockLight(x - 1, y, z, lightLevel, lightRemovalQueue, lightPropagationQueue, removalVisited, visited);
            this.computeRemoveBlockLight(x + 1, y, z, lightLevel, lightRemovalQueue, lightPropagationQueue, removalVisited, visited);
            this.computeRemoveBlockLight(x, y - 1, z, lightLevel, lightRemovalQueue, lightPropagationQueue, removalVisited, visited);
            this.computeRemoveBlockLight(x, y + 1, z, lightLevel, lightRemovalQueue, lightPropagationQueue, removalVisited, visited);
            this.computeRemoveBlockLight(x, y, z - 1, lightLevel, lightRemovalQueue, lightPropagationQueue, removalVisited, visited);
            this.computeRemoveBlockLight(x, y, z + 1, lightLevel, lightRemovalQueue, lightPropagationQueue, removalVisited, visited);
        }
        while (!lightPropagationQueue.isEmpty()) {
            int z;
            int y;
            long node = (Long)lightPropagationQueue.poll();
            int x = Hash.hashBlockX(node);
            int lightLevel = this.getBlockLightAt(x, y = Hash.hashBlockY(node), z = Hash.hashBlockZ(node)) - Block.getBlockLightFilter(this.getBlockIdAt(x, y, z));
            if (lightLevel < 1) continue;
            this.computeSpreadBlockLight(x - 1, y, z, lightLevel, lightPropagationQueue, visited);
            this.computeSpreadBlockLight(x + 1, y, z, lightLevel, lightPropagationQueue, visited);
            this.computeSpreadBlockLight(x, y - 1, z, lightLevel, lightPropagationQueue, visited);
            this.computeSpreadBlockLight(x, y + 1, z, lightLevel, lightPropagationQueue, visited);
            this.computeSpreadBlockLight(x, y, z - 1, lightLevel, lightPropagationQueue, visited);
            this.computeSpreadBlockLight(x, y, z + 1, lightLevel, lightPropagationQueue, visited);
        }
    }

    private void computeRemoveBlockLight(int x, int y, int z, int currentLight, Queue<Object[]> queue, Queue<Long> spreadQueue, Set<Long> visited, Set<Long> spreadVisited) {
        long index;
        int current = this.getBlockLightAt(x, y, z);
        if (current != 0 && current < currentLight) {
            long index2;
            this.setBlockLightAt(x, y, z, 0);
            if (current > 1 && !visited.contains(index2 = Hash.hashBlock(x, y, z))) {
                visited.add(index2);
                queue.add(new Object[]{index2, current});
            }
        } else if (current >= currentLight && !spreadVisited.contains(index = Hash.hashBlock(x, y, z))) {
            spreadVisited.add(index);
            spreadQueue.add(index);
        }
    }

    private void computeSpreadBlockLight(int x, int y, int z, int currentLight, Queue<Long> queue, Set<Long> visited) {
        int current = this.getBlockLightAt(x, y, z);
        if (current < currentLight - 1) {
            this.setBlockLightAt(x, y, z, currentLight);
            long index = Hash.hashBlock(x, y, z);
            if (!visited.contains(index)) {
                visited.add(index);
                if (currentLight > 1) {
                    queue.add(index);
                }
            }
        }
    }

    public void addLightUpdate(int x, int y, int z) {
        long index = Level.chunkHash(x >> 4, z >> 4);
        Set currentMap = this.lightQueue.computeIfAbsent(index, k -> ConcurrentHashMap.newKeySet(8));
        currentMap.add(Level.localBlockHash(x, y, z, this.getDimensionData()));
    }

    @Override
    public synchronized void setBlockFullIdAt(int x, int y, int z, int fullId) {
        this.setBlockFullIdAt(x, y, z, Block.LAYER_NORMAL, fullId);
    }

    @Override
    public synchronized void setBlockFullIdAt(int x, int y, int z, BlockLayer layer, int fullId) {
        if (y < this.getMinBlockY() || y > this.getMaxBlockY()) {
            return;
        }
        Block block = Block.fullList[fullId];
        this.setBlock(x, y, z, layer, block, false, false);
    }

    public synchronized boolean setBlock(Vector3 pos, Block block) {
        return this.setBlock(pos, Block.LAYER_NORMAL, block, false, true);
    }

    public synchronized boolean setBlock(Vector3 pos, Block block, boolean direct) {
        return this.setBlock(pos, Block.LAYER_NORMAL, block, direct, true);
    }

    public synchronized boolean setBlock(Vector3 pos, Block block, boolean direct, boolean update) {
        return this.setBlock(pos, Block.LAYER_NORMAL, block, direct, update);
    }

    public synchronized boolean setBlock(Vector3 pos, BlockLayer layer, Block block, boolean direct, boolean update) {
        return this.setBlock(pos.getFloorX(), pos.getFloorY(), pos.getFloorZ(), layer, block, direct, update);
    }

    public synchronized boolean setBlock(int x, int y, int z, Block block, boolean direct, boolean update) {
        return this.setBlock(x, y, z, Block.LAYER_NORMAL, block, direct, update);
    }

    public synchronized boolean setBlock(int x, int y, int z, BlockLayer layer, Block block, boolean direct, boolean update) {
        return this.setBlock(x, y, z, layer, block, direct, update, true);
    }

    public synchronized boolean setBlock(int x, int y, int z, BlockLayer layer, Block block, boolean direct, boolean update, boolean send) {
        if (y < this.getMinBlockY() || y > this.getMaxBlockY()) {
            return false;
        }
        int cx = x >> 4;
        int cz = z >> 4;
        BaseFullChunk chunk = this.getChunk(cx, cz, true);
        Block blockPrevious = chunk.getAndSetBlock(x & 0xF, y, z & 0xF, layer, block);
        if (blockPrevious.getFullId() == block.getFullId()) {
            return false;
        }
        block.x = x;
        block.y = y;
        block.z = z;
        block.level = this;
        block.setLayer(layer);
        if (send) {
            if (direct) {
                this.sendBlocks(this.getChunkPlayers(cx, cz).values().toArray(new Player[0]), (Vector3[])new Block[]{block}, 11, layer);
            } else {
                this.addBlockChange(Level.chunkHash(cx, cz), x, y, z);
            }
        }
        if (this.useChunkLoaderApi) {
            for (ChunkLoader loader : this.getChunkLoaders(cx, cz)) {
                loader.onBlockChanged(block);
            }
        }
        if (update) {
            if (this.lightUpdatesEnabled && (blockPrevious.isTransparent() != block.isTransparent() || blockPrevious.getLightLevel() != block.getLightLevel())) {
                this.addLightUpdate(x, y, z);
            }
            BlockUpdateEvent ev = new BlockUpdateEvent(block);
            this.server.getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                for (Entity entity : this.getNearbyEntities(new SimpleAxisAlignedBB(x - 1, y - 1, z - 1, (double)x + 1.1, (double)y + 1.1, (double)z + 1.1))) {
                    if (entity.updateMode % 2 == 1) {
                        entity.updateMode = 1;
                    }
                    entity.scheduleUpdate();
                }
                block = ev.getBlock();
                if (!(block instanceof BlockObserver)) {
                    block.onUpdate(1);
                }
                this.updateAround(x, y, z);
            }
        }
        return true;
    }

    private void addBlockChange(int x, int y, int z) {
        long index = Level.chunkHash(x >> 4, z >> 4);
        this.addBlockChange(index, x, y, z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBlockChange(long index, int x, int y, int z) {
        Long2ObjectOpenHashMap<SoftReference<Map<Integer, Object>>> long2ObjectOpenHashMap = this.changedBlocks;
        synchronized (long2ObjectOpenHashMap) {
            SoftReference current = this.changedBlocks.computeIfAbsent(index, k -> new SoftReference(new HashMap()));
            Map currentMap = (Map)current.get();
            if (currentMap != this.changeBlocksFullMap && currentMap != null) {
                if (currentMap.size() > 1024) {
                    this.changedBlocks.put(index, (SoftReference<Map<Integer, Object>>)new SoftReference<Int2ObjectOpenHashMap<Object>>(this.changeBlocksFullMap));
                } else {
                    currentMap.put(Level.localBlockHash(x, y, z, this.getDimensionData()), this.changeBlocksPresent);
                }
            }
        }
    }

    public void dropItem(Vector3 source, Item item) {
        this.dropAndGetItem(source, item);
    }

    public void dropItem(Vector3 source, Item item, Vector3 motion) {
        this.dropAndGetItem(source, item, motion);
    }

    public void dropItem(Vector3 source, Item item, Vector3 motion, int delay) {
        this.dropAndGetItem(source, item, motion, delay);
    }

    public void dropItem(Vector3 source, Item item, Vector3 motion, boolean dropAround, int delay) {
        this.dropAndGetItem(source, item, motion, dropAround, delay);
    }

    public EntityItem dropAndGetItem(Vector3 source, Item item) {
        return this.dropAndGetItem(source, item, null);
    }

    public EntityItem dropAndGetItem(Vector3 source, Item item, Vector3 motion) {
        return this.dropAndGetItem(source, item, motion, 10);
    }

    public EntityItem dropAndGetItem(Vector3 source, Item item, Vector3 motion, int delay) {
        return this.dropAndGetItem(source, item, motion, false, delay);
    }

    public EntityItem dropAndGetItem(Vector3 source, Item item, Vector3 motion, boolean dropAround, int delay) {
        if (item.getId() != 0 && item.getCount() > 0) {
            if (motion == null) {
                if (dropAround) {
                    float f = ThreadLocalRandom.current().nextFloat() * 0.5f;
                    float f1 = ThreadLocalRandom.current().nextFloat() * ((float)Math.PI * 2);
                    motion = new Vector3(-MathHelper.sin(f1) * f, 0.2f, MathHelper.cos(f1) * f);
                } else {
                    motion = new Vector3(Utils.random.nextDouble() * 0.2 - 0.1, 0.2, Utils.random.nextDouble() * 0.2 - 0.1);
                }
            }
            CompoundTag itemTag = NBTIO.putItemHelper(item);
            itemTag.setName("Item");
            EntityItem itemEntity = (EntityItem)Entity.createEntity(64, (FullChunk)this.getChunk(source.getChunkX(), source.getChunkZ(), true), new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", source.getX())).add(new DoubleTag("", source.getY())).add(new DoubleTag("", source.getZ()))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", motion.x)).add(new DoubleTag("", motion.y)).add(new DoubleTag("", motion.z))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", ThreadLocalRandom.current().nextFloat() * 360.0f)).add(new FloatTag("", 0.0f))).putShort("Health", 5).putCompound("Item", itemTag).putShort("PickupDelay", delay), new Object[0]);
            itemEntity.spawnToAll();
            return itemEntity;
        }
        return null;
    }

    public Item useBreakOn(Vector3 vector) {
        return this.useBreakOn(vector, null);
    }

    public Item useBreakOn(Vector3 vector, Item item) {
        return this.useBreakOn(vector, item, null);
    }

    public Item useBreakOn(Vector3 vector, Item item, Player player) {
        return this.useBreakOn(vector, item, player, false);
    }

    public Item useBreakOn(Vector3 vector, Item item, Player player, boolean createParticles) {
        return this.useBreakOn(vector, null, item, player, createParticles);
    }

    public Item useBreakOn(Vector3 vector, BlockFace face, Item item, Player player, boolean createParticles) {
        BlockEntity blockEntity;
        Item[] drops;
        boolean isSilkTouch;
        if (player != null && player.getGamemode() > 2) {
            return null;
        }
        Block target = this.getBlock(vector);
        int dropExp = target.getDropExp();
        if (item == null) {
            item = new ItemBlock(Block.get(0), 0, 0);
        }
        Vector3 dropPosition = vector;
        boolean bl = isSilkTouch = item.isTool() && item.hasEnchantment(16);
        if (player != null) {
            Enchantment eff;
            Item[] eventDrops;
            if (player.getGamemode() == 2) {
                Tag tag = item.getNamedTagEntry("CanDestroy");
                boolean canBreak = false;
                if (tag instanceof ListTag) {
                    for (Tag v : ((ListTag)tag).getAll()) {
                        Item entry;
                        if (!(v instanceof StringTag) || (entry = Item.fromString(((StringTag)v).data)).getId() == 0 || entry.getBlockUnsafe() == null || entry.getBlockUnsafe().getId() != target.getId()) continue;
                        canBreak = true;
                        break;
                    }
                }
                if (!canBreak) {
                    return null;
                }
            }
            if (!player.isSurvival()) {
                if (target instanceof BlockShulkerBox && this.gameRules.getBoolean(GameRule.DO_TILE_DROPS)) {
                    eventDrops = target.getDrops(item);
                    if (eventDrops.length != 0 && !eventDrops[0].hasCompoundTag()) {
                        eventDrops = new Item[]{};
                    }
                } else {
                    eventDrops = new Item[]{};
                }
            } else {
                eventDrops = isSilkTouch && target.canSilkTouch() ? new Item[]{target.toItem()} : target.getDrops(item);
            }
            double breakTime = target.getBreakTime(item, player);
            if (player.isCreative() && breakTime > 0.15) {
                breakTime = 0.15;
            }
            if (player.hasEffect(3)) {
                breakTime *= 1.0 - 0.2 * (double)(player.getEffect(3).getAmplifier() + 1);
            }
            if (player.hasEffect(4)) {
                breakTime *= 1.0 - 0.3 * (double)(player.getEffect(4).getAmplifier() + 1);
            }
            if ((eff = item.getEnchantment(15)) != null && eff.getLevel() > 0) {
                breakTime *= 1.0 - 0.3 * (double)eff.getLevel();
            }
            long now = System.currentTimeMillis();
            BlockBreakEvent ev = new BlockBreakEvent(player, target, face, item, eventDrops, player.isCreative(), (double)player.lastBreak + (breakTime -= 0.15) * 1000.0 > (double)now, vector);
            if (!(player.isCreative() || player.isBreakingBlock() && target.equals(player.breakingBlock))) {
                ev.setCancelled(true);
            } else if ((player.isSurvival() || player.isAdventure()) && !target.isBreakable(item)) {
                ev.setCancelled(true);
            } else if (!player.isOp() && this.isInSpawnRadius(target)) {
                ev.setCancelled(true);
            } else if (!ev.getInstaBreak() && ev.isFastBreak()) {
                ev.setCancelled(true);
            }
            player.lastBreak = now;
            this.server.getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return null;
            }
            if (target instanceof BlockBed) {
                drops = (target.getDamage() & 8) == 8 ? ev.getDrops() : new Item[]{};
                ((BlockBed)target).canDropItem = ev.getDrops().length != 0;
            } else {
                drops = ev.getDrops();
            }
            dropExp = ev.getDropExp();
            if (ev.getDropPosition() != null) {
                dropPosition = ev.getDropPosition();
            }
        } else {
            if (!target.isBreakable(item)) {
                return null;
            }
            drops = item.hasEnchantment(16) ? new Item[]{target.toItem()} : target.getDrops(item);
        }
        Vector3 above = new Vector3(target.x, target.y + 1.0, target.z);
        int bid = this.getBlockIdAt((int)above.x, (int)above.y, (int)above.z);
        if (bid == 51 || bid == 492) {
            this.setBlock(above, Block.get(0), true);
        }
        if (createParticles) {
            this.addParticle(new DestroyBlockParticle(target.add(0.5), target));
        }
        if ((blockEntity = this.getBlockEntity(target)) != null) {
            Inventory inventory;
            if (blockEntity instanceof InventoryHolder && (inventory = ((InventoryHolder)((Object)blockEntity)).getInventory()) != null && !inventory.getViewers().isEmpty()) {
                inventory.getViewers().clear();
            }
            blockEntity.onBreak();
            blockEntity.close();
            this.updateComparatorOutputLevel(target);
        }
        Block waterlogged = target.getWaterloggingType() != Block.WaterloggingType.NO_WATERLOGGING ? target.getLevelBlock(Block.LAYER_WATERLOGGED) : null;
        target.onBreak(item, player);
        if (waterlogged instanceof BlockLiquid) {
            this.setBlock(target, Block.LAYER_WATERLOGGED, Block.get(0), false, true);
            this.setBlock(target, Block.LAYER_NORMAL, waterlogged, false, true);
            this.scheduleUpdate(waterlogged, 1);
        }
        item.useOn(target);
        if (item.isTool() && item.getDamage() >= item.getMaxDurability()) {
            this.addSound(target, Sound.RANDOM_BREAK);
            this.addParticle(new ItemBreakParticle(target, item));
            item = new ItemBlock(Block.get(0), 0, 0);
        }
        if (this.gameRules.getBoolean(GameRule.DO_TILE_DROPS)) {
            if (!isSilkTouch && player != null && (drops.length != 0 && target.getId() != 52 || drops.length == 0 && target.getId() == 52 && item.isPickaxe()) && (player.isSurvival() || player.isAdventure())) {
                this.dropExpOrb(dropPosition.add(0.5, 0.5, 0.5), dropExp);
            }
            for (Item drop : drops) {
                if (drop.getCount() <= 0) continue;
                this.dropItem(dropPosition.add(0.5, 0.5, 0.5), drop);
            }
        }
        return item;
    }

    public void dropExpOrb(Vector3 source, int exp) {
        this.dropExpOrb(source, exp, null);
    }

    public void dropExpOrb(Vector3 source, int exp, Vector3 motion) {
        this.dropExpOrb(source, exp, motion, 10);
    }

    public void dropExpOrb(Vector3 source, int exp, Vector3 motion, int delay) {
        if (exp > 0) {
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            for (int split : EntityXPOrb.splitIntoOrbSizes(exp)) {
                CompoundTag nbt = Entity.getDefaultNBT(source, motion == null ? new Vector3((((Random)rand).nextDouble() * 0.2 - 0.1) * 2.0, ((Random)rand).nextDouble() * 0.4, (((Random)rand).nextDouble() * 0.2 - 0.1) * 2.0) : motion, ((Random)rand).nextFloat() * 360.0f, 0.0f);
                nbt.putShort("Value", split);
                nbt.putShort("PickupDelay", delay);
                Entity.createEntity("XpOrb", (FullChunk)this.getChunk(source.getChunkX(), source.getChunkZ()), nbt, new Object[0]).spawnToAll();
            }
        }
    }

    public Item useItemOn(Vector3 vector, Item item, BlockFace face, float fx, float fy, float fz) {
        return this.useItemOn(vector, item, face, fx, fy, fz, null);
    }

    public Item useItemOn(Vector3 vector, Item item, BlockFace face, float fx, float fy, float fz, Player player) {
        return this.useItemOn(vector, item, face, fx, fy, fz, player, true);
    }

    public Item useItemOn(Vector3 vector, Item item, BlockFace face, float fx, float fy, float fz, Player player, boolean playSound) {
        Block target = this.getBlock(vector);
        Block block = target.getSide(face);
        if (block.y > (double)this.getMaxBlockY() || block.y < (double)this.getMinBlockY()) {
            return null;
        }
        if (target.getId() == 0) {
            return null;
        }
        if (face == BlockFace.UP && item.getBlockId() == 420 && block.getId() == 420) {
            while (block instanceof BlockScaffolding) {
                block = block.up();
            }
        }
        if (player != null) {
            PlayerInteractEvent ev = new PlayerInteractEvent(player, item, target, face, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK);
            if (player.getGamemode() > 2) {
                ev.setCancelled(true);
            }
            if (!player.isOp() && this.isInSpawnRadius(target)) {
                ev.setCancelled(true);
            }
            this.server.getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                target.onUpdate(5);
                if ((!player.sneakToBlockInteract() || item.isNull()) && target.canBeActivated() && target.onActivate(item, player)) {
                    if (item.isTool() && item.getDamage() >= item.getMaxDurability()) {
                        this.addSound(target, Sound.RANDOM_BREAK);
                        this.addParticle(new ItemBreakParticle(target, item));
                        item = new ItemBlock(Block.get(0), 0, 0);
                    }
                    return item;
                }
                if (item.canBeActivated()) {
                    int oldCount = item.getCount();
                    if (item.onActivate(this, player, block, target, face, fx, fy, fz) && oldCount != item.getCount()) {
                        if (item.getCount() <= 0) {
                            item = new ItemBlock(Block.get(0), 0, 0);
                        }
                        return item;
                    }
                }
            } else {
                if (item.getId() == 325 && ItemBucket.getDamageByTarget(item.getDamage()) == 8) {
                    player.getLevel().sendBlocks(new Player[]{player}, (Vector3[])new Block[]{Block.get(0, 0, target.getLevelBlock(BlockLayer.WATERLOGGED))}, 11, Block.LAYER_WATERLOGGED);
                }
                return null;
            }
            if (item.getId() == 325 && ItemBucket.getDamageByTarget(item.getDamage()) == 8) {
                player.getLevel().sendBlocks(new Player[]{player}, (Vector3[])new Block[]{target.getLevelBlock(BlockLayer.WATERLOGGED)}, 11, Block.LAYER_WATERLOGGED);
            }
        } else if (target.canBeActivated() && target.onActivate(item, null)) {
            if (item.isTool() && item.getDamage() >= item.getMaxDurability()) {
                item = new ItemBlock(Block.get(0), 0, 0);
            }
            return item;
        }
        int blockID = item.getBlockId();
        if (blockID > 255 && this.provider instanceof Anvil) {
            return null;
        }
        if (!item.canBePlaced()) {
            return null;
        }
        Block hand = item.getBlock();
        hand.position(block);
        if (!(block.canBeReplaced() || hand instanceof BlockSlab && block instanceof BlockSlab && hand.getId() == block.getId())) {
            return null;
        }
        if (target.canBeReplaced()) {
            Block b = item.getBlockUnsafe();
            if (b != null && target.getId() == b.getId() && target.getDamage() == b.getDamage()) {
                return item;
            }
            block = target;
            hand.position(block);
        }
        if (!hand.canPassThrough() && hand.getBoundingBox() != null && !(hand instanceof BlockBed)) {
            Entity[] entities;
            for (Entity e : entities = this.getCollidingEntities(hand.getBoundingBox())) {
                if (player == e || e instanceof EntityProjectile || e instanceof EntityItem || e instanceof Player && ((Player)e).isSpectator() || !e.canCollide()) continue;
                this.sendBlocks(player, (Vector3[])new Block[]{block, target}, 0);
                return null;
            }
            if (player != null && hand.getBoundingBox().intersectsWith(player.getNextPositionBB())) {
                this.sendBlocks(player, (Vector3[])new Block[]{block, target}, 0);
                return null;
            }
        }
        if (player != null) {
            BlockPlaceEvent event = new BlockPlaceEvent(player, hand, block, target, item);
            if (player.getGamemode() == 2) {
                Tag tag = item.getNamedTagEntry("CanPlaceOn");
                boolean canPlace = false;
                if (tag instanceof ListTag) {
                    for (Tag v : ((ListTag)tag).getAll()) {
                        Item entry;
                        if (!(v instanceof StringTag) || (entry = Item.fromString(((StringTag)v).data)).getId() == 0 || entry.getBlockUnsafe() == null || entry.getBlockUnsafe().getId() != target.getId()) continue;
                        canPlace = true;
                        break;
                    }
                }
                if (!canPlace) {
                    event.setCancelled(true);
                }
            }
            if (!player.isOp() && this.isInSpawnRadius(target)) {
                event.setCancelled(true);
            }
            this.server.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                return null;
            }
        }
        boolean liquidMoved = false;
        if ((hand.getWaterloggingType() != Block.WaterloggingType.NO_WATERLOGGING || !hand.canBeFlowedInto() || !(block instanceof BlockLiquid) && !(block.getLevelBlock(BlockLayer.WATERLOGGED) instanceof BlockLiquid)) && block instanceof BlockLiquid && ((BlockLiquid)block).usesWaterLogging() && hand.getWaterloggingType() != Block.WaterloggingType.NO_WATERLOGGING) {
            liquidMoved = true;
            this.setBlock(block, Block.LAYER_NORMAL, Block.get(0), false, false);
            this.setBlock(block, Block.LAYER_WATERLOGGED, block, false, false);
        }
        if (!hand.place(item, block, target, face, fx, fy, fz, player)) {
            if (liquidMoved) {
                this.setBlock(block, Block.LAYER_NORMAL, block, false, false);
                this.setBlock(block, Block.LAYER_WATERLOGGED, Block.get(0), false, false);
            }
            return null;
        }
        if (item.hasPersistentDataContainer() && item.getPersistentDataContainer().convertsToBlock()) {
            block.getPersistentDataContainer().setStorage(item.getPersistentDataContainer().getStorage().clone());
        }
        if (liquidMoved) {
            this.scheduleUpdate(block, 1);
        }
        if (player != null && !player.isCreative()) {
            item.setCount(item.getCount() - 1);
        }
        if (playSound) {
            int soundData = GlobalBlockPalette.getOrCreateRuntimeId(hand.getId(), hand.getDamage());
            LevelSoundEventPacket pk = new LevelSoundEventPacket();
            pk.sound = 6;
            pk.extraData = soundData;
            pk.entityIdentifier = "";
            pk.x = (float)hand.x;
            pk.y = (float)hand.y;
            pk.z = (float)hand.z;
            Server.broadcastPacket(this.getChunkPlayers(hand.getChunkX(), hand.getChunkZ()).values(), (DataPacket)pk);
        }
        if (item.getCount() <= 0) {
            item = new ItemBlock(Block.get(0), 0, 0);
        }
        return item;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInSpawnRadius(Vector3 vector3) {
        if (this.server.getSpawnRadius() <= -1) return false;
        Vector2 vector2 = new Vector2(vector3.x, vector3.z);
        Vector3 spawn = this.provider.getSpawn();
        Vector2 vector22 = new Vector2(spawn.x, spawn.z);
        if (!(vector2.distance(vector22) <= (double)this.server.getSpawnRadius())) return false;
        return true;
    }

    public Entity getEntity(long entityId) {
        return this.entities.get(entityId);
    }

    public Entity[] getEntities() {
        return this.entities.values().toArray(new Entity[0]);
    }

    public Entity[] getCollidingEntities(AxisAlignedBB bb) {
        return this.getCollidingEntities(bb, null);
    }

    public Entity[] getCollidingEntities(AxisAlignedBB bb, Entity entity) {
        ArrayList<Entity> nearby = new ArrayList<Entity>();
        if (entity == null || entity.canCollide()) {
            int minX = NukkitMath.floorDouble((bb.getMinX() - 2.0) / 16.0);
            int maxX = NukkitMath.ceilDouble((bb.getMaxX() + 2.0) / 16.0);
            int minZ = NukkitMath.floorDouble((bb.getMinZ() - 2.0) / 16.0);
            int maxZ = NukkitMath.ceilDouble((bb.getMaxZ() + 2.0) / 16.0);
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    for (Entity ent : this.getChunkEntities(x, z, false).values()) {
                        if (entity != null && (ent == entity || !entity.canCollideWith(ent)) || !ent.boundingBox.intersectsWith(bb)) continue;
                        nearby.add(ent);
                    }
                }
            }
        }
        return nearby.toArray(new Entity[0]);
    }

    public Entity[] getNearbyEntities(AxisAlignedBB bb) {
        return this.getNearbyEntities(bb, null, false);
    }

    public Entity[] getNearbyEntities(AxisAlignedBB bb, Entity entity) {
        return this.getNearbyEntities(bb, entity, false);
    }

    public Entity[] getNearbyEntities(AxisAlignedBB bb, Entity entity, boolean loadChunks) {
        ArrayList<Entity> nearby = new ArrayList<Entity>();
        int minX = NukkitMath.floorDouble((bb.getMinX() - 2.0) * 0.0625);
        int maxX = NukkitMath.ceilDouble((bb.getMaxX() + 2.0) * 0.0625);
        int minZ = NukkitMath.floorDouble((bb.getMinZ() - 2.0) * 0.0625);
        int maxZ = NukkitMath.ceilDouble((bb.getMaxZ() + 2.0) * 0.0625);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (Entity ent : this.getChunkEntities(x, z, loadChunks).values()) {
                    if (ent == entity || !ent.boundingBox.intersectsWith(bb)) continue;
                    nearby.add(ent);
                }
            }
        }
        return nearby.toArray(new Entity[0]);
    }

    public Map<Long, BlockEntity> getBlockEntities() {
        return this.blockEntities;
    }

    public BlockEntity getBlockEntityById(long blockEntityId) {
        return this.blockEntities.get(blockEntityId);
    }

    public Map<Long, Player> getPlayers() {
        return this.players;
    }

    public Map<Integer, ChunkLoader> getLoaders() {
        return this.loaders;
    }

    public BlockEntity getBlockEntity(Vector3 pos) {
        return this.getBlockEntity(null, pos);
    }

    public BlockEntity getBlockEntity(FullChunk chunk, Vector3 pos) {
        int by = pos.getFloorY();
        if (by < this.getMinBlockY() || by > this.getMaxBlockY()) {
            return null;
        }
        int cx = (int)pos.x >> 4;
        int cz = (int)pos.z >> 4;
        if (chunk == null || cx != chunk.getX() || cz != chunk.getZ()) {
            chunk = this.getChunk(cx, cz, false);
        }
        if (chunk != null) {
            return chunk.getTile((int)pos.x & 0xF, by, (int)pos.z & 0xF);
        }
        return null;
    }

    public BlockEntity getBlockEntityIfLoaded(Vector3 pos) {
        return this.getBlockEntityIfLoaded(null, pos);
    }

    public BlockEntity getBlockEntityIfLoaded(FullChunk chunk, Vector3 pos) {
        int by = pos.getFloorY();
        if (by < this.getMinBlockY() || by > this.getMaxBlockY()) {
            return null;
        }
        int cx = (int)pos.x >> 4;
        int cz = (int)pos.z >> 4;
        if (chunk == null || cx != chunk.getX() || cz != chunk.getZ()) {
            chunk = this.getChunkIfLoaded(cx, cz);
        }
        if (chunk != null) {
            return chunk.getTile((int)pos.x & 0xF, by, (int)pos.z & 0xF);
        }
        return null;
    }

    public Map<Long, Entity> getChunkEntities(int X, int Z) {
        return this.getChunkEntities(X, Z, true);
    }

    public Map<Long, Entity> getChunkEntities(int X, int Z, boolean loadChunks) {
        BaseFullChunk chunk = loadChunks ? this.getChunk(X, Z) : this.getChunkIfLoaded(X, Z);
        return chunk != null ? chunk.getEntities() : Collections.emptyMap();
    }

    public Map<Long, BlockEntity> getChunkBlockEntities(int X, int Z) {
        BaseFullChunk chunk = this.getChunk(X, Z);
        return chunk != null ? chunk.getBlockEntities() : Collections.emptyMap();
    }

    @Override
    public int getBlockIdAt(int x, int y, int z) {
        return this.getBlockIdAt(x, y, z, Block.LAYER_NORMAL);
    }

    @Override
    public synchronized int getBlockIdAt(int x, int y, int z, BlockLayer layer) {
        if (y < this.getMinBlockY() || y > this.getMaxBlockY()) {
            return 0;
        }
        int cx = x >> 4;
        int cz = z >> 4;
        BaseFullChunk chunk = this.getChunk(cx, cz, true);
        return chunk.getBlockId(x & 0xF, y, z & 0xF, layer);
    }

    public synchronized int getBlockIdAt(FullChunk chunk, int x, int y, int z) {
        if (y < this.getMinBlockY() || y > this.getMaxBlockY()) {
            return 0;
        }
        int cx = x >> 4;
        int cz = z >> 4;
        if (chunk == null || cx != chunk.getX() || cz != chunk.getZ()) {
            chunk = this.getChunk(cx, cz, true);
        }
        return chunk.getBlockId(x & 0xF, y, z & 0xF, Block.LAYER_NORMAL);
    }

    @Override
    public synchronized void setBlockIdAt(int x, int y, int z, int id) {
        this.setBlockIdAt(x, y, z, Block.LAYER_NORMAL, id);
    }

    @Override
    public synchronized void setBlockIdAt(int x, int y, int z, BlockLayer layer, int id) {
        if (y < this.getMinBlockY() || y > this.getMaxBlockY()) {
            return;
        }
        BaseFullChunk chunk = this.getChunk(x >> 4, z >> 4, true);
        chunk.setBlockId(x & 0xF, y, z & 0xF, layer, id);
        this.addBlockChange(x, y, z);
        if (this.useChunkLoaderApi) {
            this.temporalVector.setComponents(x, y, z);
            for (ChunkLoader loader : this.getChunkLoaders(x >> 4, z >> 4)) {
                loader.onBlockChanged(this.temporalVector);
            }
        }
        if (id == 0) {
            this.updateEntitiesOnBlockChange(chunk);
        }
    }

    @Override
    public synchronized void setBlockAt(int x, int y, int z, int id, int data) {
        this.setBlockAtLayer(x, y, z, Block.LAYER_NORMAL, id, data);
    }

    @Override
    public boolean setBlockAtLayer(int x, int y, int z, BlockLayer layer, int id) {
        return this.setBlockAtLayer(x, y, z, layer, id, 0);
    }

    @Override
    public synchronized boolean setBlockAtLayer(int x, int y, int z, BlockLayer layer, int id, int data) {
        if (y < this.getMinBlockY() || y > this.getMaxBlockY()) {
            return false;
        }
        BaseFullChunk chunk = this.getChunk(x >> 4, z >> 4, true);
        boolean changed = chunk.setBlockAtLayer(x & 0xF, y, z & 0xF, layer, id, data & 0x3F);
        if (!changed) {
            return false;
        }
        this.addBlockChange(x, y, z);
        if (this.useChunkLoaderApi) {
            this.temporalVector.setComponents(x, y, z);
            for (ChunkLoader loader : this.getChunkLoaders(x >> 4, z >> 4)) {
                loader.onBlockChanged(this.temporalVector);
            }
        }
        if (id == 0) {
            this.updateEntitiesOnBlockChange(chunk);
        }
        return true;
    }

    private void updateEntitiesOnBlockChange(FullChunk chunk) {
        if (chunk == null) {
            return;
        }
        for (Entity entity : chunk.getEntities().values()) {
            if (entity.updateMode % 2 != 1) continue;
            entity.updateMode = 1;
        }
    }

    public synchronized int getBlockExtraDataAt(int x, int y, int z) {
        if (y < this.getMinBlockY() || y > this.getMaxBlockY()) {
            return 0;
        }
        return this.getChunk(x >> 4, z >> 4, true).getBlockExtraData(x & 0xF, y, z & 0xF);
    }

    public synchronized void setBlockExtraDataAt(int x, int y, int z, int id, int data) {
        if (y < this.getMinBlockY() || y > this.getMaxBlockY()) {
            return;
        }
        this.getChunk(x >> 4, z >> 4, true).setBlockExtraData(x & 0xF, y, z & 0xF, data << 8 | id);
        this.sendBlockExtraData(x, y, z, id, data);
    }

    @Override
    public synchronized int getBlockDataAt(int x, int y, int z) {
        return this.getBlockDataAt(null, x, y, z, Block.LAYER_NORMAL);
    }

    @Override
    public synchronized int getBlockDataAt(int x, int y, int z, BlockLayer layer) {
        return this.getBlockDataAt(null, x, y, z, layer);
    }

    public synchronized int getBlockDataAt(FullChunk chunk, int x, int y, int z, BlockLayer layer) {
        if (y < this.getMinBlockY() || y > this.getMaxBlockY()) {
            return 0;
        }
        int cx = x >> 4;
        int cz = z >> 4;
        if (chunk == null || cx != chunk.getX() || cz != chunk.getZ()) {
            chunk = this.getChunk(cx, cz, true);
        }
        return chunk.getBlockData(x & 0xF, y, z & 0xF, layer);
    }

    @Override
    public synchronized void setBlockDataAt(int x, int y, int z, int data) {
        this.setBlockDataAt(x, y, z, Block.LAYER_NORMAL, data);
    }

    @Override
    public synchronized void setBlockDataAt(int x, int y, int z, BlockLayer layer, int data) {
        if (y < this.getMinBlockY() || y > this.getMaxBlockY()) {
            return;
        }
        this.getChunk(x >> 4, z >> 4, true).setBlockData(x & 0xF, y, z & 0xF, layer, data & 0x3F);
        this.addBlockChange(x, y, z);
        if (this.useChunkLoaderApi) {
            this.temporalVector.setComponents(x, y, z);
            for (ChunkLoader loader : this.getChunkLoaders(x >> 4, z >> 4)) {
                loader.onBlockChanged(this.temporalVector);
            }
        }
    }

    public synchronized int getBlockSkyLightAt(int x, int y, int z) {
        if (y < this.getMinBlockY() || y > this.getMaxBlockY()) {
            return 0;
        }
        return this.getChunk(x >> 4, z >> 4, true).getBlockSkyLight(x & 0xF, y, z & 0xF);
    }

    public synchronized void setBlockSkyLightAt(int x, int y, int z, int level) {
        if (y < this.getMinBlockY() || y > this.getMaxBlockY()) {
            return;
        }
        this.getChunk(x >> 4, z >> 4, true).setBlockSkyLight(x & 0xF, y, z & 0xF, level & 0xF);
    }

    public synchronized int getBlockLightAt(int x, int y, int z) {
        if (y < this.getMinBlockY() || y > this.getMaxBlockY()) {
            return 0;
        }
        BaseFullChunk chunk = this.getChunkIfLoaded(x >> 4, z >> 4);
        return chunk == null ? 0 : chunk.getBlockLight(x & 0xF, y, z & 0xF);
    }

    public synchronized void setBlockLightAt(int x, int y, int z, int level) {
        if (y < this.getMinBlockY() || y > this.getMaxBlockY()) {
            return;
        }
        BaseFullChunk c = this.getChunkIfLoaded(x >> 4, z >> 4);
        if (null != c) {
            c.setBlockLight(x & 0xF, y, z & 0xF, level & 0xF);
        }
    }

    public int getBiomeId(int x, int z) {
        return this.getChunk(x >> 4, z >> 4, true).getBiomeId(x & 0xF, z & 0xF);
    }

    public void setBiomeId(int x, int z, int biomeId) {
        this.getChunk(x >> 4, z >> 4, true).setBiomeId(x & 0xF, z & 0xF, biomeId & 0xF);
    }

    public void setBiomeId(int x, int z, byte biomeId) {
        this.getChunk(x >> 4, z >> 4, true).setBiomeId(x & 0xF, z & 0xF, biomeId & 0xF);
    }

    public int getHeightMap(int x, int z) {
        return this.getChunk(x >> 4, z >> 4, true).getHeightMap(x & 0xF, z & 0xF);
    }

    public void setHeightMap(int x, int z, int value) {
        this.getChunk(x >> 4, z >> 4, true).setHeightMap(x & 0xF, z & 0xF, value & 0xF);
    }

    public Map<Long, ? extends FullChunk> getChunks() {
        return this.provider.getLoadedChunks();
    }

    @Override
    public BaseFullChunk getChunk(int chunkX, int chunkZ) {
        return this.getChunk(chunkX, chunkZ, false);
    }

    public BaseFullChunk getChunk(int chunkX, int chunkZ, boolean create) {
        long index = Level.chunkHash(chunkX, chunkZ);
        BaseFullChunk chunk = this.provider.getLoadedChunk(index);
        if (chunk == null) {
            chunk = this.forceLoadChunk(index, chunkX, chunkZ, create);
        }
        return chunk;
    }

    @Nullable
    public BaseFullChunk getChunkIfLoaded(int chunkX, int chunkZ) {
        return this.provider.getLoadedChunk(Level.chunkHash(chunkX, chunkZ));
    }

    public void generateChunkCallback(int x, int z, BaseFullChunk chunk) {
        this.generateChunkCallback(x, z, chunk, true);
    }

    public void generateChunkCallback(int x, int z, BaseFullChunk chunk, boolean isPopulated) {
        long index = Level.chunkHash(x, z);
        if (this.chunkPopulationQueue.contains(index)) {
            BaseFullChunk oldChunk = this.getChunk(x, z, false);
            for (int xx = -1; xx <= 1; ++xx) {
                for (int zz = -1; zz <= 1; ++zz) {
                    this.chunkPopulationLock.remove(Level.chunkHash(x + xx, z + zz));
                }
            }
            this.chunkPopulationQueue.remove(index);
            chunk.setProvider(this.provider);
            this.setChunk(x, z, chunk, false);
            chunk = this.getChunk(x, z, false);
            if (chunk != null && (oldChunk == null || !isPopulated) && chunk.isPopulated() && chunk.getProvider() != null) {
                this.server.getPluginManager().callEvent(new ChunkPopulateEvent(chunk));
                if (this.useChunkLoaderApi) {
                    for (ChunkLoader loader : this.getChunkLoaders(x, z)) {
                        loader.onChunkPopulated(chunk);
                    }
                }
            }
        } else if (this.chunkGenerationQueue.contains(index) || this.chunkPopulationLock.contains(index)) {
            this.chunkGenerationQueue.remove(index);
            this.chunkPopulationLock.remove(index);
            chunk.setProvider(this.provider);
            this.setChunk(x, z, chunk, false);
        } else {
            chunk.setProvider(this.provider);
            this.setChunk(x, z, chunk, false);
        }
    }

    @Override
    public void setChunk(int chunkX, int chunkZ) {
        this.setChunk(chunkX, chunkZ, null);
    }

    @Override
    public void setChunk(int chunkX, int chunkZ, BaseFullChunk chunk) {
        this.setChunk(chunkX, chunkZ, chunk, true);
    }

    public void setChunk(int chunkX, int chunkZ, BaseFullChunk chunk, boolean unload) {
        if (chunk == null) {
            return;
        }
        long index = Level.chunkHash(chunkX, chunkZ);
        BaseFullChunk oldChunk = this.getChunk(chunkX, chunkZ, false);
        if (oldChunk != chunk) {
            if (unload && oldChunk != null) {
                this.unloadChunk(chunkX, chunkZ, false, false);
            } else {
                Map.Entry<Object, Object> entry;
                Iterator<Map.Entry<Object, Object>> iter;
                Map<Object, Object> oldBlockEntities;
                Map<Object, Object> oldEntities = oldChunk != null ? oldChunk.getEntities() : Collections.emptyMap();
                Map<Object, Object> map = oldBlockEntities = oldChunk != null ? oldChunk.getBlockEntities() : Collections.emptyMap();
                if (!oldEntities.isEmpty()) {
                    iter = oldEntities.entrySet().iterator();
                    while (iter.hasNext()) {
                        entry = iter.next();
                        Entity entity = (Entity)entry.getValue();
                        chunk.addEntity(entity);
                        if (oldChunk == null) continue;
                        iter.remove();
                        oldChunk.removeEntity(entity);
                        entity.chunk = chunk;
                    }
                }
                if (!oldBlockEntities.isEmpty()) {
                    iter = oldBlockEntities.entrySet().iterator();
                    while (iter.hasNext()) {
                        entry = iter.next();
                        BlockEntity blockEntity = (BlockEntity)entry.getValue();
                        chunk.addBlockEntity(blockEntity);
                        if (oldChunk == null) continue;
                        iter.remove();
                        oldChunk.removeBlockEntity(blockEntity);
                        blockEntity.chunk = chunk;
                    }
                }
            }
            this.provider.setChunk(chunkX, chunkZ, chunk);
        }
        chunk.setChanged();
        if (!this.isChunkInUse(index)) {
            this.unloadChunkRequest(chunkX, chunkZ);
        } else {
            for (ChunkLoader loader : this.getChunkLoaders(chunkX, chunkZ)) {
                loader.onChunkChanged(chunk);
            }
        }
    }

    public int getHighestBlockAt(int x, int z) {
        return this.getHighestBlockAt(x, z, true);
    }

    public int getHighestBlockAt(int x, int z, boolean cache) {
        return this.getChunk(x >> 4, z >> 4, true).getHighestBlockAt(x & 0xF, z & 0xF, cache);
    }

    public BlockColor getMapColorAt(int x, int z) {
        return this.getMapColorAt(x, this.getHighestBlockAt(x, z, false), z);
    }

    public BlockColor getMapColorAt(int x, int y, int z) {
        int minY = this.getMinBlockY();
        if (y < minY || y > this.getMaxBlockY()) {
            return BlockColor.VOID_BLOCK_COLOR;
        }
        BaseFullChunk chunk = this.getChunk(x >> 4, z >> 4);
        for (int checkY = y; checkY > minY; --checkY) {
            Block block = this.getBlock(chunk, x, checkY, z, BlockLayer.NORMAL, false);
            if (block instanceof BlockGrass) {
                return this.getGrassColorAt(chunk, x, z);
            }
            BlockColor blockColor = block.getColor();
            if (blockColor.getAlpha() == 0) {
                continue;
            }
            return blockColor;
        }
        return BlockColor.VOID_BLOCK_COLOR;
    }

    private BlockColor getGrassColorAt(FullChunk chunk, int x, int z) {
        int biome = chunk.getBiomeId(x & 0xF, z & 0xF);
        switch (biome) {
            case 0: 
            case 7: 
            case 9: 
            case 24: {
                return new BlockColor("#8eb971");
            }
            case 1: 
            case 16: 
            case 129: {
                return new BlockColor("#91bd59");
            }
            case 2: 
            case 8: 
            case 17: 
            case 35: 
            case 36: 
            case 130: 
            case 163: 
            case 164: {
                return new BlockColor("#bfb755");
            }
            case 3: 
            case 20: 
            case 25: 
            case 34: 
            case 131: 
            case 162: {
                return new BlockColor("#8ab689");
            }
            case 4: 
            case 132: {
                return new BlockColor("#79c05a");
            }
            case 5: 
            case 19: 
            case 32: 
            case 33: 
            case 133: 
            case 160: {
                return new BlockColor("#86b783");
            }
            case 6: 
            case 134: {
                return new BlockColor("#6A7039");
            }
            case 10: 
            case 11: 
            case 12: 
            case 30: 
            case 31: 
            case 140: 
            case 158: {
                return new BlockColor("#80b497");
            }
            case 14: 
            case 15: {
                return new BlockColor("#55c93f");
            }
            case 18: 
            case 27: 
            case 28: 
            case 155: 
            case 156: {
                return new BlockColor("#88bb67");
            }
            case 21: 
            case 22: 
            case 149: {
                return new BlockColor("#59c93c");
            }
            case 23: 
            case 151: {
                return new BlockColor("#64c73f");
            }
            case 26: {
                return new BlockColor("#83b593");
            }
            case 29: 
            case 157: {
                return new BlockColor("#507a32");
            }
            case 37: 
            case 38: 
            case 39: 
            case 165: 
            case 166: 
            case 167: {
                return new BlockColor("#90814d");
            }
        }
        return BlockColor.GRASS_BLOCK_COLOR;
    }

    public boolean isChunkLoaded(int x, int z) {
        return this.provider.isChunkLoaded(x, z);
    }

    private boolean areNeighboringChunksLoaded(long hash) {
        return this.provider.isChunkLoaded(hash + 1L) && this.provider.isChunkLoaded(hash - 1L) && this.provider.isChunkLoaded(hash + 0x100000000L) && this.provider.isChunkLoaded(hash - 0x100000000L);
    }

    public boolean isChunkGenerated(int x, int z) {
        BaseFullChunk chunk = this.getChunk(x, z);
        return chunk != null && chunk.isGenerated();
    }

    public boolean isChunkPopulated(int x, int z) {
        BaseFullChunk chunk = this.getChunk(x, z);
        return chunk != null && chunk.isPopulated();
    }

    public Position getSpawnLocation() {
        return Position.fromObject(this.provider.getSpawn(), this);
    }

    public void setSpawnLocation(Vector3 pos) {
        Position previousSpawn = this.getSpawnLocation();
        this.provider.setSpawn(new Vector3(pos.x, pos.y, pos.z));
        this.server.getPluginManager().callEvent(new SpawnChangeEvent(this, previousSpawn));
        SetSpawnPositionPacket pk = new SetSpawnPositionPacket();
        pk.spawnType = 1;
        pk.x = pos.getFloorX();
        pk.y = pos.getFloorY();
        pk.z = pos.getFloorZ();
        pk.dimension = this.getDimension();
        for (Player p : this.getPlayers().values()) {
            p.dataPacket(pk);
        }
    }

    public void requestChunk(int x, int z, Player player) {
        if (player.getLoaderId() <= 0) {
            throw new IllegalStateException(player.getName() + " has no chunk loader");
        }
        long index = Level.chunkHash(x, z);
        this.chunkSendQueue.putIfAbsent(index, new Int2ObjectOpenHashMap());
        ((Int2ObjectMap)this.chunkSendQueue.get(index)).put(player.getLoaderId(), player);
    }

    private void sendChunk(int x, int z, long index, DataPacket packet) {
        if (this.chunkSendTasks.contains(index)) {
            for (Player player : ((Int2ObjectMap)this.chunkSendQueue.get(index)).values()) {
                if (!player.isConnected() || !player.usedChunks.containsKey(index)) continue;
                player.sendChunk(x, z, packet);
            }
            this.chunkSendQueue.remove(index);
            this.chunkSendTasks.remove(index);
        }
    }

    private void processChunkRequest() {
        Iterator iterator = this.chunkSendQueue.keySet().iterator();
        while (iterator.hasNext()) {
            BatchPacket packet;
            long index = (Long)iterator.next();
            if (this.chunkSendTasks.contains(index)) continue;
            int x = Level.getHashX(index);
            int z = Level.getHashZ(index);
            this.chunkSendTasks.add(index);
            BaseFullChunk chunk = this.getChunk(x, z);
            if (chunk != null && (packet = chunk.getChunkPacket()) != null) {
                this.sendChunk(x, z, index, packet);
                continue;
            }
            this.provider.requestChunkTask(x, z);
        }
    }

    public void chunkRequestCallback(long timestamp, int x, int z, int subChunkCount, byte[] payload, long index) {
        if (this.server.cacheChunks) {
            BatchPacket data = Player.getChunkCacheFromData(x, z, subChunkCount, payload, this.getDimension());
            BaseFullChunk chunk = this.getChunkIfLoaded(x, z);
            if (chunk != null && chunk.getChanges() <= timestamp) {
                chunk.setChunkPacket(data);
            }
            this.sendChunk(x, z, index, data);
            return;
        }
        if (this.chunkSendTasks.contains(index)) {
            for (Player player : ((Int2ObjectMap)this.chunkSendQueue.get(index)).values()) {
                if (!player.isConnected() || !player.usedChunks.containsKey(index)) continue;
                player.sendChunk(x, z, subChunkCount, payload, this.getDimension());
            }
            this.chunkSendQueue.remove(index);
            this.chunkSendTasks.remove(index);
        }
    }

    public void removeEntity(Entity entity) {
        if (entity.getLevel() != this) {
            throw new LevelException("Invalid Entity level");
        }
        if (entity instanceof Player) {
            this.players.remove(entity.getId());
            this.checkSleep();
        } else {
            entity.close();
        }
        this.entities.remove(entity.getId());
        this.updateEntities.remove(entity.getId());
    }

    public void addEntity(Entity entity) {
        if (entity.getLevel() != this) {
            throw new LevelException("Invalid Entity level");
        }
        if (entity instanceof Player) {
            this.players.put(entity.getId(), (Player)entity);
        }
        this.entities.put(entity.getId(), entity);
    }

    public void addBlockEntity(BlockEntity blockEntity) {
        if (blockEntity.getLevel() != this) {
            throw new LevelException("BlockEntity is not in this level");
        }
        this.blockEntities.put(blockEntity.getId(), blockEntity);
    }

    public void scheduleBlockEntityUpdate(BlockEntity entity) {
        if (entity.getLevel() != this) {
            throw new LevelException("BlockEntity is not in this level");
        }
        if (!this.updateBlockEntities.contains(entity)) {
            this.updateBlockEntities.add(entity);
        }
    }

    public void removeBlockEntity(BlockEntity entity) {
        if (entity.getLevel() != this) {
            throw new LevelException("BlockEntity is not in this level");
        }
        this.blockEntities.remove(entity.getId());
        this.updateBlockEntities.remove(entity);
    }

    public boolean isChunkInUse(int x, int z) {
        return this.isChunkInUse(Level.chunkHash(x, z));
    }

    public boolean isChunkInUse(long hash) {
        Map<Integer, ChunkLoader> map = this.chunkLoaders.get(hash);
        return map != null && !map.isEmpty();
    }

    public boolean loadChunk(int x, int z) {
        return this.loadChunk(x, z, true);
    }

    public boolean loadChunk(int x, int z, boolean generate) {
        long index = Level.chunkHash(x, z);
        if (this.provider.isChunkLoaded(index)) {
            return true;
        }
        return this.forceLoadChunk(index, x, z, generate) != null;
    }

    private synchronized BaseFullChunk forceLoadChunk(long index, int x, int z, boolean generate) {
        BaseFullChunk chunk = this.provider.getChunk(x, z, generate);
        if (chunk == null) {
            if (generate) {
                throw new IllegalStateException("Could not create new chunk");
            }
            return null;
        }
        if (chunk.getProvider() == null) {
            this.unloadChunk(x, z, false);
            return chunk;
        }
        this.server.getPluginManager().callEvent(new ChunkLoadEvent(chunk, !chunk.isGenerated()));
        chunk.initChunk();
        if (this.isChunkInUse(index)) {
            this.unloadQueue.remove(index);
            if (this.useChunkLoaderApi) {
                for (ChunkLoader loader : this.getChunkLoaders(x, z)) {
                    loader.onChunkLoaded(chunk);
                }
            }
        } else {
            this.unloadQueue.put(index, System.currentTimeMillis());
        }
        return chunk;
    }

    private void queueUnloadChunk(int x, int z) {
        long index = Level.chunkHash(x, z);
        this.unloadQueue.put(index, System.currentTimeMillis());
    }

    public boolean unloadChunkRequest(int x, int z) {
        return this.unloadChunkRequest(x, z, true);
    }

    public boolean unloadChunkRequest(int x, int z, boolean safe) {
        if (safe && this.isChunkInUse(x, z) || this.isSpawnChunk(x, z)) {
            return false;
        }
        this.queueUnloadChunk(x, z);
        return true;
    }

    public void cancelUnloadChunkRequest(int x, int z) {
        this.cancelUnloadChunkRequest(Level.chunkHash(x, z));
    }

    public void cancelUnloadChunkRequest(long hash) {
        this.unloadQueue.remove(hash);
    }

    public boolean unloadChunk(int x, int z) {
        return this.unloadChunk(x, z, true);
    }

    public boolean unloadChunk(int x, int z, boolean safe) {
        return this.unloadChunk(x, z, safe, true);
    }

    public synchronized boolean unloadChunk(int x, int z, boolean safe, boolean trySave) {
        if (safe && this.isChunkInUse(x, z)) {
            return false;
        }
        if (!this.isChunkLoaded(x, z)) {
            return true;
        }
        BaseFullChunk chunk = this.getChunk(x, z);
        if (chunk != null && chunk.getProvider() != null) {
            ChunkUnloadEvent ev = new ChunkUnloadEvent(chunk);
            this.server.getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return false;
            }
        }
        try {
            if (chunk != null) {
                if (trySave && this.saveOnUnloadEnabled) {
                    boolean needSave = chunk.hasChanged();
                    if (!needSave) {
                        for (Entity e : chunk.getEntities().values()) {
                            if (!e.canSaveToStorage() || e.ignoredAsSaveReason()) continue;
                            needSave = true;
                            break;
                        }
                    }
                    if (needSave) {
                        this.provider.setChunk(x, z, chunk);
                        this.provider.saveChunk(x, z, chunk);
                    }
                }
                if (this.useChunkLoaderApi) {
                    for (ChunkLoader loader : this.getChunkLoaders(x, z)) {
                        loader.onChunkUnloaded(chunk);
                    }
                }
            }
            this.provider.unloadChunk(x, z, safe);
        }
        catch (Exception e) {
            MainLogger logger = this.server.getLogger();
            logger.error(this.server.getLanguage().translateString("nukkit.level.chunkUnloadError", e.toString()), e);
        }
        return true;
    }

    public boolean isSpawnChunk(int X, int Z) {
        Vector3 cachedSpawnPos = this.provider.getSpawn();
        return Math.abs(X - cachedSpawnPos.getChunkX()) <= 1 && Math.abs(Z - cachedSpawnPos.getChunkZ()) <= 1;
    }

    public Position getSafeSpawn() {
        return this.getSafeSpawn(null);
    }

    public Position getSafeSpawn(Vector3 spawn) {
        if (spawn == null) {
            spawn = this.getSpawnLocation();
        }
        Vector3 pos = spawn.floor();
        BaseFullChunk chunk = this.getChunk((int)pos.x >> 4, (int)pos.z >> 4, false);
        int x = (int)pos.x & 0xF;
        int z = (int)pos.z & 0xF;
        if (chunk != null && chunk.isGenerated()) {
            Block block;
            int fullId;
            boolean wasAir;
            int y = NukkitMath.clamp((int)pos.y, this.getMinBlockY() + 1, this.getMaxBlockY() - 1);
            boolean bl = wasAir = chunk.getBlockId(x, y - 1, z) == 0;
            while (y > this.getMinBlockY()) {
                fullId = chunk.getFullBlock(x, y, z);
                block = Block.get(fullId >> 6, fullId & 0x3F);
                if (this.isFullBlock(block)) {
                    if (!wasAir) break;
                    ++y;
                    break;
                }
                wasAir = true;
                --y;
            }
            while (y >= this.getMinBlockY() && y < this.getMaxBlockY()) {
                fullId = chunk.getFullBlock(x, y + 1, z);
                block = Block.get(fullId >> 6, fullId & 0x3F);
                if (!this.isFullBlock(block)) {
                    fullId = chunk.getFullBlock(x, y, z);
                    block = Block.get(fullId >> 6, fullId & 0x3F);
                    if (!this.isFullBlock(block)) {
                        return new Position(pos.x + 0.5, (double)y + 0.51, pos.z + 0.5, this);
                    }
                } else {
                    ++y;
                }
                ++y;
            }
            pos.y = y;
        }
        return new Position(pos.x + 0.5, pos.y + 0.1, pos.z + 0.5, this);
    }

    public int getTime() {
        return this.time;
    }

    public boolean isDaytime() {
        return this.skyLightSubtracted < 4.0f;
    }

    public long getCurrentTick() {
        return this.levelCurrentTick;
    }

    public String getName() {
        return this.folderName;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setTime(int time) {
        this.time = time;
        this.sendTime();
    }

    public void stopTime() {
        this.stopTime = true;
        this.sendTime();
    }

    public void startTime() {
        this.stopTime = false;
        this.sendTime();
    }

    @Override
    public long getSeed() {
        return this.provider.getSeed();
    }

    public void setSeed(int seed) {
        this.provider.setSeed(seed);
    }

    public boolean populateChunk(int x, int z) {
        return this.populateChunk(x, z, false);
    }

    public boolean populateChunk(int x, int z, boolean force) {
        long index = Level.chunkHash(x, z);
        if (this.chunkPopulationQueue.contains(index) || this.chunkPopulationQueue.size() >= this.chunkPopulationQueueSize && !force) {
            return false;
        }
        BaseFullChunk chunk = this.getChunk(x, z, true);
        if (!chunk.isPopulated()) {
            int zz;
            int xx;
            boolean populate = true;
            block0: for (xx = -1; xx <= 1; ++xx) {
                for (zz = -1; zz <= 1; ++zz) {
                    if (!this.chunkPopulationLock.contains(Level.chunkHash(x + xx, z + zz))) continue;
                    populate = false;
                    break block0;
                }
            }
            if (populate && !this.chunkPopulationQueue.contains(index)) {
                this.chunkPopulationQueue.add(index);
                for (xx = -1; xx <= 1; ++xx) {
                    for (zz = -1; zz <= 1; ++zz) {
                        this.chunkPopulationLock.add(Level.chunkHash(x + xx, z + zz));
                    }
                }
                this.server.getScheduler().scheduleAsyncTask(null, this.generatorTaskFactory.populateChunkTask(chunk, this));
            }
            return false;
        }
        return true;
    }

    @Override
    public AsyncTask populateChunkTask(BaseFullChunk chunk, Level level) {
        return new PopulationTask(this, chunk);
    }

    public void generateChunk(int x, int z) {
        this.generateChunk(x, z, false);
    }

    public void generateChunk(int x, int z, boolean force) {
        if (this.chunkGenerationQueue.size() >= this.chunkGenerationQueueSize && !force) {
            return;
        }
        long index = Level.chunkHash(x, z);
        if (!this.chunkGenerationQueue.contains(index)) {
            this.chunkGenerationQueue.add(index);
            this.server.getScheduler().scheduleAsyncTask(null, this.generatorTaskFactory.generateChunkTask(this.getChunk(x, z, true), this));
        }
    }

    @Override
    public AsyncTask generateChunkTask(BaseFullChunk chunk, Level level) {
        return new GenerationTask(level, chunk);
    }

    public void regenerateChunk(int x, int z) {
        this.unloadChunk(x, z, false, false);
        this.cancelUnloadChunkRequest(x, z);
        this.provider.setChunk(x, z, this.provider.getEmptyChunk(x, z));
        this.generateChunk(x, z, true);
    }

    public void doChunkGarbageCollection() {
        if (!this.blockEntities.isEmpty()) {
            Iterator iter = this.blockEntities.values().iterator();
            while (iter.hasNext()) {
                BlockEntity blockEntity = (BlockEntity)iter.next();
                if (blockEntity != null) {
                    if (blockEntity.isValid()) continue;
                    iter.remove();
                    blockEntity.close();
                    continue;
                }
                iter.remove();
            }
        }
        for (Map.Entry<Long, ? extends FullChunk> entry : this.provider.getLoadedChunks().entrySet()) {
            int Z;
            FullChunk chunk;
            int X;
            long index = entry.getKey();
            if (this.unloadQueue.containsKey(index) || this.isSpawnChunk(X = (chunk = entry.getValue()).getX(), Z = chunk.getZ())) continue;
            this.unloadChunkRequest(X, Z, true);
        }
        this.provider.doGarbageCollection();
    }

    public void doGarbageCollection(long allocatedTime) {
        long start = System.currentTimeMillis();
        if (this.unloadChunks(start, allocatedTime, false)) {
            this.provider.doGarbageCollection(allocatedTime -= System.currentTimeMillis() - start);
        }
    }

    public void unloadChunks() {
        this.unloadChunks(false);
    }

    public void unloadChunks(boolean force) {
        this.unloadChunks(50, force);
    }

    public void unloadChunks(int maxUnload, boolean force) {
        if (this.server.holdWorldSave && !force && this.saveOnUnloadEnabled) {
            return;
        }
        if (!this.unloadQueue.isEmpty()) {
            long index;
            long now = System.currentTimeMillis();
            int unloaded = 0;
            List toRemove = null;
            for (Long2LongMap.Entry entry : this.unloadQueue.long2LongEntrySet()) {
                if (!force) {
                    long time = entry.getLongValue();
                    if (unloaded > maxUnload) break;
                    if (time > now - 30000L) continue;
                }
                if (this.isChunkInUse(index = entry.getLongKey())) continue;
                if (toRemove == null) {
                    toRemove = new LongArrayList();
                }
                toRemove.add(index);
                ++unloaded;
            }
            if (toRemove != null) {
                int size = toRemove.size();
                for (int i = 0; i < size; ++i) {
                    int Z;
                    index = toRemove.getLong(i);
                    int X = Level.getHashX(index);
                    if (!this.unloadChunk(X, Z = Level.getHashZ(index), true)) continue;
                    this.unloadQueue.remove(index);
                }
            }
        }
    }

    private boolean unloadChunks(long now, long allocatedTime, boolean force) {
        if (this.server.holdWorldSave && !force && this.saveOnUnloadEnabled) {
            return false;
        }
        if (!this.unloadQueue.isEmpty()) {
            boolean result = true;
            int maxIterations = this.unloadQueue.size();
            if (this.lastUnloadIndex > maxIterations) {
                this.lastUnloadIndex = 0;
            }
            Iterator iter = this.unloadQueue.long2LongEntrySet().iterator();
            if (this.lastUnloadIndex != 0) {
                iter.skip(this.lastUnloadIndex);
            }
            LongList toUnload = null;
            for (int i = 0; i < maxIterations; ++i) {
                long index;
                long time;
                if (!iter.hasNext()) {
                    iter = this.unloadQueue.long2LongEntrySet().iterator();
                }
                Long2LongMap.Entry entry = (Long2LongMap.Entry)iter.next();
                if (!force && (time = entry.getLongValue()) > now - 30000L || this.isChunkInUse(index = entry.getLongKey())) continue;
                if (toUnload == null) {
                    toUnload = new LongArrayList();
                }
                toUnload.add(index);
            }
            if (toUnload != null) {
                LongListIterator longListIterator = toUnload.iterator();
                while (longListIterator.hasNext()) {
                    int Z;
                    long index = (Long)longListIterator.next();
                    int X = Level.getHashX(index);
                    if (!this.unloadChunk(X, Z = Level.getHashZ(index), true)) continue;
                    this.unloadQueue.remove(index);
                    if (System.currentTimeMillis() - now < allocatedTime) continue;
                    result = false;
                    break;
                }
            }
            return result;
        }
        return true;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) throws Exception {
        this.server.getLevelMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) throws Exception {
        return this.server.getLevelMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) throws Exception {
        return this.server.getLevelMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) throws Exception {
        this.server.getLevelMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    public void addPlayerMovement(Entity entity, double x, double y, double z, double yaw, double pitch, double headYaw) {
        MovePlayerPacket pk = new MovePlayerPacket();
        pk.eid = entity.getId();
        pk.x = (float)x;
        pk.y = (float)y;
        pk.z = (float)z;
        pk.yaw = (float)yaw;
        pk.headYaw = (float)headYaw;
        pk.pitch = (float)pitch;
        pk.onGround = entity.onGround;
        if (entity.riding != null) {
            pk.ridingEid = entity.riding.getId();
            pk.mode = 3;
        }
        Server.broadcastPacket(entity.getViewers().values(), (DataPacket)pk);
    }

    public void addEntityMovement(Entity entity, double x, double y, double z, double yaw, double pitch, double headYaw) {
        MoveEntityAbsolutePacket pk = new MoveEntityAbsolutePacket();
        pk.eid = entity.getId();
        pk.x = x;
        pk.y = y;
        pk.z = z;
        pk.yaw = yaw;
        pk.headYaw = headYaw;
        pk.pitch = pitch;
        pk.onGround = entity.onGround;
        Server.broadcastPacket(entity.getViewers().values(), (DataPacket)pk);
    }

    public boolean isRaining() {
        return this.raining;
    }

    public boolean setRaining(boolean raining) {
        WeatherChangeEvent ev = new WeatherChangeEvent(this, raining);
        this.server.getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        this.raining = raining;
        LevelEventPacket pk = new LevelEventPacket();
        if (raining) {
            int time;
            pk.evid = 3001;
            pk.data = time = Utils.random.nextInt(12000) + 12000;
            this.setRainTime(time);
        } else {
            pk.evid = 3003;
            this.setRainTime(ThreadLocalRandom.current().nextInt(168000) + 12000);
        }
        Server.broadcastPacket(this.getPlayers().values(), (DataPacket)pk);
        return true;
    }

    public int getRainTime() {
        return this.rainTime;
    }

    public void setRainTime(int rainTime) {
        this.rainTime = rainTime;
    }

    public boolean isThundering() {
        return this.raining && this.thundering;
    }

    public boolean setThundering(boolean thundering) {
        ThunderChangeEvent ev = new ThunderChangeEvent(this, thundering);
        this.server.getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        if (thundering && !this.raining) {
            this.setRaining(true);
        }
        this.thundering = thundering;
        LevelEventPacket pk = new LevelEventPacket();
        if (thundering) {
            int time;
            pk.evid = 3002;
            pk.data = time = Utils.random.nextInt(12000) + 3600;
            this.setThunderTime(time);
        } else {
            pk.evid = 3004;
            this.setThunderTime(ThreadLocalRandom.current().nextInt(168000) + 12000);
        }
        Server.broadcastPacket(this.getPlayers().values(), (DataPacket)pk);
        return true;
    }

    public int getThunderTime() {
        return this.thunderTime;
    }

    public void setThunderTime(int thunderTime) {
        this.thunderTime = thunderTime;
    }

    public void sendWeather(Player[] players) {
        if (players == null) {
            players = this.getPlayers().values().toArray(new Player[0]);
        }
        LevelEventPacket pk = new LevelEventPacket();
        if (this.raining) {
            pk.evid = 3001;
            pk.data = this.rainTime;
        } else {
            pk.evid = 3003;
        }
        Server.broadcastPacket(players, (DataPacket)pk);
        pk = new LevelEventPacket();
        if (this.isThundering()) {
            pk.evid = 3002;
            pk.data = this.thunderTime;
        } else {
            pk.evid = 3004;
        }
        Server.broadcastPacket(players, (DataPacket)pk);
    }

    public void sendWeather(Player player) {
        if (player != null) {
            this.sendWeather(new Player[]{player});
        }
    }

    public void sendWeather(Collection<Player> players) {
        if (players == null) {
            players = this.getPlayers().values();
        }
        this.sendWeather(players.toArray(new Player[0]));
    }

    public int getDimension() {
        return this.dimensionData.getDimensionId();
    }

    public int getMinBlockY() {
        return this.dimensionData.getMinHeight();
    }

    public int getMaxBlockY() {
        return this.dimensionData.getMaxHeight();
    }

    public boolean canBlockSeeSky(Vector3 pos) {
        return (double)this.getHighestBlockAt(pos.getFloorX(), pos.getFloorZ()) < pos.getY();
    }

    public boolean canBlockSeeSky(Block block) {
        return (double)this.getHighestBlockAt((int)block.getX(), (int)block.getZ()) < block.getY();
    }

    public int getStrongPower(Vector3 pos, BlockFace direction) {
        return this.getStrongPower(null, pos, direction);
    }

    private int getStrongPower(FullChunk cachedChunk, Vector3 pos, BlockFace direction) {
        return this.getBlock(cachedChunk, pos.getFloorX(), pos.getFloorY(), pos.getFloorZ(), true).getStrongPower(direction);
    }

    public int getStrongPower(Vector3 pos) {
        return this.getStrongPower(null, pos);
    }

    private int getStrongPower(FullChunk cachedChunk, Vector3 pos) {
        int i = 0;
        for (BlockFace face : BlockFace.values()) {
            if ((i = Math.max(i, this.getStrongPower(cachedChunk, pos.getSideVec(face), face))) < 15) continue;
            return i;
        }
        return i;
    }

    public boolean isSidePowered(Vector3 pos, BlockFace face) {
        return this.getRedstonePower(pos, face) > 0;
    }

    public int getRedstonePower(Vector3 pos, BlockFace face) {
        return this.getRedstonePower(null, pos, face);
    }

    private int getRedstonePower(FullChunk cachedChunk, Vector3 pos, BlockFace face) {
        Block block = this.getBlock(cachedChunk, pos.getFloorX(), pos.getFloorY(), pos.getFloorZ(), true);
        return block.isNormalBlock() ? this.getStrongPower(cachedChunk, pos) : block.getWeakPower(face);
    }

    public boolean isBlockPowered(Vector3 pos) {
        return this.isBlockPowered(null, pos);
    }

    public boolean isBlockPowered(FullChunk cachedChunk, Vector3 pos) {
        for (BlockFace face : BlockFace.values()) {
            if (this.getRedstonePower(cachedChunk, pos.getSideVec(face), face) <= 0) continue;
            return true;
        }
        return false;
    }

    public int isBlockIndirectlyGettingPowered(Vector3 pos) {
        int power = 0;
        for (BlockFace face : BlockFace.values()) {
            int blockPower = this.getRedstonePower(pos.getSideVec(face), face);
            if (blockPower >= 15) {
                return 15;
            }
            if (blockPower <= power) continue;
            power = blockPower;
        }
        return power;
    }

    public boolean isAreaLoaded(AxisAlignedBB bb) {
        int minX = NukkitMath.floorDouble(bb.getMinX()) >> 4;
        int minZ = NukkitMath.floorDouble(bb.getMinZ()) >> 4;
        int maxX = NukkitMath.floorDouble(bb.getMaxX()) >> 4;
        int maxZ = NukkitMath.floorDouble(bb.getMaxZ()) >> 4;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (this.isChunkLoaded(x, z)) continue;
                return false;
            }
        }
        return true;
    }

    private int getUpdateLCG() {
        this.updateLCG = this.updateLCG * 3 ^ 0x3C6EF35F;
        return this.updateLCG;
    }

    public boolean createPortal(Block target) {
        int i;
        if (this.getDimension() == 2) {
            return false;
        }
        int maxPortalSize = 23;
        int targX = target.getFloorX();
        int targY = target.getFloorY();
        int targZ = target.getFloorZ();
        for (int i2 = 1; i2 < 4; ++i2) {
            if (this.getBlockIdAt(targX, targY + i2, targZ) == 0) continue;
            return false;
        }
        int sizePosX = 0;
        int sizeNegX = 0;
        int sizePosZ = 0;
        int sizeNegZ = 0;
        for (i = 1; i < 23 && this.getBlockIdAt(targX + i, targY, targZ) == 49; ++i) {
            ++sizePosX;
        }
        for (i = 1; i < 23 && this.getBlockIdAt(targX - i, targY, targZ) == 49; ++i) {
            ++sizeNegX;
        }
        for (i = 1; i < 23 && this.getBlockIdAt(targX, targY, targZ + i) == 49; ++i) {
            ++sizePosZ;
        }
        for (i = 1; i < 23 && this.getBlockIdAt(targX, targY, targZ - i) == 49; ++i) {
            ++sizeNegZ;
        }
        int sizeX = sizePosX + sizeNegX + 1;
        int sizeZ = sizePosZ + sizeNegZ + 1;
        if (sizeX >= 2 && sizeX <= 23) {
            int width;
            int height;
            int scanX = targX;
            int scanY = targY + 1;
            for (int i3 = 0; i3 < sizePosX + 1; ++i3) {
                if (this.getBlockIdAt(scanX + i3, scanY, targZ) != 0) {
                    return false;
                }
                if (this.getBlockIdAt(scanX + i3 + 1, scanY, targZ) != 49) continue;
                scanX += i3;
                break;
            }
            if (this.getBlockIdAt(scanX + 1, scanY, targZ) != 49) {
                return false;
            }
            int innerWidth = 0;
            block22: for (int i4 = 0; i4 < 21; ++i4) {
                int id = this.getBlockIdAt(scanX - i4, scanY, targZ);
                switch (id) {
                    case 0: {
                        ++innerWidth;
                        continue block22;
                    }
                    case 49: {
                        break block22;
                    }
                    default: {
                        return false;
                    }
                }
            }
            int innerHeight = 0;
            block23: for (int i5 = 0; i5 < 21; ++i5) {
                int id = this.getBlockIdAt(scanX, scanY + i5, targZ);
                switch (id) {
                    case 0: {
                        ++innerHeight;
                        continue block23;
                    }
                    case 49: {
                        break block23;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (innerWidth > 21 || innerWidth < 2 || innerHeight > 21 || innerHeight < 3) {
                return false;
            }
            for (height = 0; height < innerHeight + 1; ++height) {
                if (height == innerHeight) {
                    for (width = 0; width < innerWidth; ++width) {
                        if (this.getBlockIdAt(scanX - width, scanY + height, targZ) == 49) continue;
                        return false;
                    }
                    continue;
                }
                if (this.getBlockIdAt(scanX + 1, scanY + height, targZ) != 49 || this.getBlockIdAt(scanX - innerWidth, scanY + height, targZ) != 49) {
                    return false;
                }
                for (width = 0; width < innerWidth; ++width) {
                    if (this.getBlockIdAt(scanX - width, scanY + height, targZ) == 0) continue;
                    return false;
                }
            }
            for (height = 0; height < innerHeight; ++height) {
                for (width = 0; width < innerWidth; ++width) {
                    this.setBlock(new Vector3(scanX - width, scanY + height, targZ), Block.get(90));
                }
            }
            return true;
        }
        if (sizeZ >= 2 && sizeZ <= 23) {
            int width;
            int height;
            int scanY = targY + 1;
            int scanZ = targZ;
            for (int i6 = 0; i6 < sizePosZ + 1; ++i6) {
                if (this.getBlockIdAt(targX, scanY, scanZ + i6) != 0) {
                    return false;
                }
                if (this.getBlockIdAt(targX, scanY, scanZ + i6 + 1) != 49) continue;
                scanZ += i6;
                break;
            }
            if (this.getBlockIdAt(targX, scanY, scanZ + 1) != 49) {
                return false;
            }
            int innerWidth = 0;
            block30: for (int i7 = 0; i7 < 21; ++i7) {
                int id = this.getBlockIdAt(targX, scanY, scanZ - i7);
                switch (id) {
                    case 0: {
                        ++innerWidth;
                        continue block30;
                    }
                    case 49: {
                        break block30;
                    }
                    default: {
                        return false;
                    }
                }
            }
            int innerHeight = 0;
            block31: for (int i8 = 0; i8 < 21; ++i8) {
                int id = this.getBlockIdAt(targX, scanY + i8, scanZ);
                switch (id) {
                    case 0: {
                        ++innerHeight;
                        continue block31;
                    }
                    case 49: {
                        break block31;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (innerWidth > 21 || innerWidth < 2 || innerHeight > 21 || innerHeight < 3) {
                return false;
            }
            for (height = 0; height < innerHeight + 1; ++height) {
                if (height == innerHeight) {
                    for (width = 0; width < innerWidth; ++width) {
                        if (this.getBlockIdAt(targX, scanY + height, scanZ - width) == 49) continue;
                        return false;
                    }
                    continue;
                }
                if (this.getBlockIdAt(targX, scanY + height, scanZ + 1) != 49 || this.getBlockIdAt(targX, scanY + height, scanZ - innerWidth) != 49) {
                    return false;
                }
                for (width = 0; width < innerWidth; ++width) {
                    if (this.getBlockIdAt(targX, scanY + height, scanZ - width) == 0) continue;
                    return false;
                }
            }
            for (height = 0; height < innerHeight; ++height) {
                for (width = 0; width < innerWidth; ++width) {
                    this.setBlock(new Vector3(targX, scanY + height, scanZ - width), Block.get(90));
                }
            }
            return true;
        }
        return false;
    }

    public Position calculatePortalMirror(Vector3 portal) {
        if (this.getDimension() == 1) {
            double x = Math.floor(portal.getFloorX() << 3);
            double y = NukkitMath.clamp(EnumLevel.mRound32(portal.getFloorY()), 70, 246);
            double z = Math.floor(portal.getFloorZ() << 3);
            return new Position(x, y, z, Server.getInstance().getDefaultLevel());
        }
        Level nether = Server.getInstance().getLevelByName("nether");
        if (nether == null) {
            return null;
        }
        double x = Math.floor(portal.getFloorX() >> 3);
        double y = NukkitMath.clamp(EnumLevel.mRound32(portal.getFloorY()), 70, 118);
        double z = Math.floor(portal.getFloorZ() >> 3);
        return new Position(x, y, z, nether);
    }

    public void setGeneratorTaskFactory(GeneratorTaskFactory factory) {
        if (factory == null) {
            throw new NullPointerException("GeneratorTaskFactory can not be null!");
        }
        this.generatorTaskFactory = factory;
    }

    public boolean isBlockWaterloggedAt(FullChunk chunk, int x, int y, int z) {
        if (chunk == null || y < this.getMinBlockY() || y > this.getMaxBlockY()) {
            return false;
        }
        int block = chunk.getBlockId(x & 0xF, y, z & 0xF, Block.LAYER_WATERLOGGED);
        return Block.isWater(block);
    }

    public String toString() {
        return "Level@" + Integer.toHexString(this.hashCode()) + "[" + this.folderName + ']';
    }

    public void asyncChunk(BaseChunk chunk, long timestamp, int x, int z) {
        this.asyncChunkThread.queue(chunk, timestamp, x, z, this.dimensionData);
    }

    public PersistentDataContainer getPersistentDataContainer(Vector3 position) {
        return this.getPersistentDataContainer(position, false);
    }

    public PersistentDataContainer getPersistentDataContainer(final Vector3 position, boolean create) {
        BlockEntity blockEntity = this.getBlockEntity(position);
        if (blockEntity != null) {
            return blockEntity.getPersistentDataContainer();
        }
        if (create) {
            CompoundTag compound = BlockEntity.getDefaultCompound(position, "PersistentContainer");
            blockEntity = BlockEntity.createBlockEntity("PersistentContainer", this.getChunk(position.getChunkX(), position.getChunkZ()), compound, new Object[0]);
            if (blockEntity == null) {
                throw new IllegalStateException("Failed to create persistent container block entity at " + position);
            }
            return blockEntity.getPersistentDataContainer();
        }
        return new DelegatePersistentDataContainer(){

            @Override
            protected PersistentDataContainer createDelegate() {
                return Level.this.getPersistentDataContainer(position, true);
            }
        };
    }

    public boolean hasPersistentDataContainer(Vector3 position) {
        BlockEntity blockEntity = this.getBlockEntity(position);
        return blockEntity != null && blockEntity.hasPersistentDataContainer();
    }

    @Generated
    public boolean isLightUpdatesEnabled() {
        return this.lightUpdatesEnabled;
    }

    @Generated
    public void setLightUpdatesEnabled(boolean lightUpdatesEnabled) {
        this.lightUpdatesEnabled = lightUpdatesEnabled;
    }

    @Generated
    public boolean isSaveOnUnloadEnabled() {
        return this.saveOnUnloadEnabled;
    }

    @Generated
    public void setSaveOnUnloadEnabled(boolean saveOnUnloadEnabled) {
        this.saveOnUnloadEnabled = saveOnUnloadEnabled;
    }

    @Generated
    public DimensionData getDimensionData() {
        return this.dimensionData;
    }

    @Generated
    public void setDimensionData(DimensionData dimensionData) {
        this.dimensionData = dimensionData;
    }

    static {
        Level.randomTickBlocks[2] = true;
        Level.randomTickBlocks[60] = true;
        Level.randomTickBlocks[110] = true;
        Level.randomTickBlocks[6] = true;
        Level.randomTickBlocks[18] = true;
        Level.randomTickBlocks[161] = true;
        Level.randomTickBlocks[78] = true;
        Level.randomTickBlocks[79] = true;
        Level.randomTickBlocks[10] = true;
        Level.randomTickBlocks[11] = true;
        Level.randomTickBlocks[81] = true;
        Level.randomTickBlocks[244] = true;
        Level.randomTickBlocks[141] = true;
        Level.randomTickBlocks[142] = true;
        Level.randomTickBlocks[105] = true;
        Level.randomTickBlocks[104] = true;
        Level.randomTickBlocks[59] = true;
        Level.randomTickBlocks[83] = true;
        Level.randomTickBlocks[115] = true;
        Level.randomTickBlocks[51] = true;
        Level.randomTickBlocks[74] = true;
        Level.randomTickBlocks[127] = true;
        Level.randomTickBlocks[207] = true;
        Level.randomTickBlocks[106] = true;
        Level.randomTickBlocks[8] = true;
        Level.randomTickBlocks[118] = true;
        Level.randomTickBlocks[200] = true;
        Level.randomTickBlocks[462] = true;
        Level.randomTickBlocks[419] = true;
        Level.randomTickBlocks[418] = true;
        Level.randomTickBlocks[388] = true;
        Level.randomTickBlocks[389] = true;
        Level.randomTickBlocks[393] = true;
        Level.randomTickBlocks[595] = true;
        Level.randomTickBlocks[596] = true;
        Level.randomTickBlocks[597] = true;
        Level.randomTickBlocks[599] = true;
        Level.randomTickBlocks[602] = true;
        Level.randomTickBlocks[603] = true;
        Level.randomTickBlocks[604] = true;
        Level.randomTickBlocks[609] = true;
        Level.randomTickBlocks[610] = true;
        Level.randomTickBlocks[611] = true;
        Level.randomTickBlocks[616] = true;
        Level.randomTickBlocks[617] = true;
        Level.randomTickBlocks[618] = true;
        Level.randomTickBlocks[623] = true;
        Level.randomTickBlocks[624] = true;
        Level.randomTickBlocks[625] = true;
        Level.randomTickBlocks[583] = true;
        Level.randomTickBlocks[577] = true;
        Level.randomTickBlocks[630] = true;
        Level.randomTickBlocks[631] = true;
        Level.randomTickBlocks[579] = true;
        Level.randomTickBlocks[580] = true;
        Level.randomTickBlocks[563] = true;
    }
}

