/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level;

import cn.nukkit.level.BlockPalette;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.network.protocol.ProtocolInfo;
import cn.nukkit.utils.Utils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.NoSuchElementException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlobalBlockPalette {
    @Generated
    private static final Logger log = LogManager.getLogger(GlobalBlockPalette.class);
    private static boolean initialized;
    private static final BlockPalette currentBlockPalette;
    private static final BlockPalette leveldbBlockPalette;

    public static void init() {
        if (initialized) {
            throw new IllegalStateException("GlobalBlockPalette was already generated!");
        }
        initialized = true;
        log.debug("Loading block palette...");
        GlobalBlockPalette.loadBlockStates((ListTag)Utils.loadTagResource("runtime_block_states.dat"), GlobalBlockPalette.getCurrentBlockPalette());
        GlobalBlockPalette.loadBlockStates((ListTag)Utils.loadTagResource("runtime_block_states_729.dat"), GlobalBlockPalette.getLeveldbBlockPalette());
    }

    private static void loadBlockStates(ListTag<CompoundTag> blockStates, BlockPalette blockPalette) {
        ObjectArrayList stateOverloads = new ObjectArrayList();
        for (CompoundTag state : blockStates.getAll()) {
            if (GlobalBlockPalette.registerBlockState(blockPalette, state, false)) continue;
            stateOverloads.add(state);
        }
        for (CompoundTag state : stateOverloads) {
            log.debug("[{}] Registering block palette overload: {}", (Object)blockPalette.getProtocol(), (Object)state.getString("name"));
            GlobalBlockPalette.registerBlockState(blockPalette, state, true);
        }
        blockPalette.lock();
    }

    private static boolean registerBlockState(BlockPalette blockPalette, CompoundTag state, boolean force) {
        int id = state.getInt("id");
        int data = state.getShort("data");
        int runtimeId = state.getInt("runtimeId");
        boolean stateOverload = state.getBoolean("stateOverload");
        if (stateOverload && !force) {
            return false;
        }
        CompoundTag vanillaState = state.remove("id").remove("data").remove("runtimeId").remove("stateOverload");
        blockPalette.registerState(id, data, runtimeId, vanillaState);
        return true;
    }

    public static int getOrCreateRuntimeId(int id, int meta) {
        return GlobalBlockPalette.getCurrentBlockPalette().getRuntimeId(id, meta);
    }

    public static int getOrCreateRuntimeId(int legacyId) throws NoSuchElementException {
        return GlobalBlockPalette.getCurrentBlockPalette().getRuntimeId(legacyId);
    }

    public static int getLegacyFullId(int runtimeId) {
        return GlobalBlockPalette.getCurrentBlockPalette().getLegacyFullId(runtimeId);
    }

    @Generated
    public static BlockPalette getCurrentBlockPalette() {
        return currentBlockPalette;
    }

    @Generated
    public static BlockPalette getLeveldbBlockPalette() {
        return leveldbBlockPalette;
    }

    static {
        currentBlockPalette = new BlockPalette(ProtocolInfo.CURRENT_PROTOCOL);
        leveldbBlockPalette = new BlockPalette(729);
    }
}

