/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTNT;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityShulkerBox;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityExplosive;
import cn.nukkit.entity.EntityLiving;
import cn.nukkit.entity.item.EntityItem;
import cn.nukkit.entity.item.EntityXPOrb;
import cn.nukkit.entity.mob.EntityEnderDragon;
import cn.nukkit.event.Event;
import cn.nukkit.event.block.BlockExplodeEvent;
import cn.nukkit.event.block.BlockUpdateEvent;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.EntityExplodeEvent;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.item.Item;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.Level;
import cn.nukkit.level.Position;
import cn.nukkit.level.particle.HugeExplodeSeedParticle;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.Hash;
import cn.nukkit.utils.Utils;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.ArrayList;
import java.util.List;

public class Explosion {
    private static final int rays = 16;
    private final Level level;
    private final Position source;
    private final double size;
    private List<Block> affectedBlocks = new ArrayList<Block>();
    private static final double stepLen = 0.3;
    private final Object what;
    private boolean doesDamage = true;
    private double minHeight = -2.147483648E9;

    public Explosion(Position center, double size, Entity what) {
        this.level = center.getLevel();
        this.source = center;
        this.size = Math.max(size, 0.0);
        this.what = what;
    }

    public Explosion(Position center, double size, Object what) {
        this.level = center.getLevel();
        this.source = center;
        this.size = Math.max(size, 0.0);
        this.what = what;
    }

    @Deprecated
    public boolean explode() {
        if (this.explodeA()) {
            return this.explodeB();
        }
        return false;
    }

    public boolean explodeA() {
        if (this.what instanceof EntityExplosive && ((Entity)this.what).isInsideOfWater()) {
            this.doesDamage = false;
            return true;
        }
        if (this.size < 0.1) {
            return false;
        }
        Vector3 vector = new Vector3(0.0, 0.0, 0.0);
        Vector3 vBlock = new Vector3(0.0, 0.0, 0.0);
        int mRays = 15;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                block2: for (int k = 0; k < 16; ++k) {
                    if (i != 0 && i != mRays && j != 0 && j != mRays && k != 0 && k != mRays) continue;
                    vector.setComponents((double)i / (double)mRays * 2.0 - 1.0, (double)j / (double)mRays * 2.0 - 1.0, (double)k / (double)mRays * 2.0 - 1.0);
                    double len = vector.length();
                    vector.setComponents(vector.x / len * 0.3, vector.y / len * 0.3, vector.z / len * 0.3);
                    double pointerX = this.source.x;
                    double pointerY = this.source.y;
                    double pointerZ = this.source.z;
                    for (double blastForce = this.size * (double)Utils.random.nextInt(700, 1301) / 1000.0; blastForce > 0.0; blastForce -= 0.22499999999999998) {
                        int x = (int)pointerX;
                        int y = (int)pointerY;
                        int z = (int)pointerZ;
                        vBlock.x = pointerX >= (double)x ? (double)x : (double)(x - 1);
                        vBlock.y = pointerY >= (double)y ? (double)y : (double)(y - 1);
                        double d = vBlock.z = pointerZ >= (double)z ? (double)z : (double)(z - 1);
                        if (vBlock.y < (double)this.level.getMinBlockY() || vBlock.y > (double)this.level.getMaxBlockY()) continue block2;
                        Block block = this.level.getBlock(vBlock);
                        if (block.getId() != 0 && (blastForce -= (block.getResistance() / 5.0 + 0.3) * 0.3) > 0.0 && block.y >= this.minHeight && !this.affectedBlocks.contains(block)) {
                            this.affectedBlocks.add(block);
                        }
                        pointerX += vector.x;
                        pointerY += vector.y;
                        pointerZ += vector.z;
                    }
                }
            }
        }
        return true;
    }

    public boolean explodeB() {
        Entity[] list;
        Event ev;
        double yield = 1.0 / this.size * 100.0;
        if (this.what instanceof Entity) {
            ev = new EntityExplodeEvent((Entity)this.what, this.source, this.affectedBlocks, yield);
            this.level.getServer().getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return false;
            }
            yield = ((EntityExplodeEvent)ev).getYield();
            this.affectedBlocks = ((EntityExplodeEvent)ev).getBlockList();
        } else if (this.what instanceof Block) {
            ev = new BlockExplodeEvent((Block)this.what, this.source, this.affectedBlocks, yield);
            this.level.getServer().getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return false;
            }
            yield = ((BlockExplodeEvent)ev).getYield();
            this.affectedBlocks = ((BlockExplodeEvent)ev).getBlockList();
        }
        LongArraySet updateBlocks = new LongArraySet();
        double explosionSize = this.size * 2.0;
        double minX = NukkitMath.floorDouble(this.source.x - explosionSize - 1.0);
        double maxX = NukkitMath.ceilDouble(this.source.x + explosionSize + 1.0);
        double minY = NukkitMath.floorDouble(this.source.y - explosionSize - 1.0);
        double maxY = NukkitMath.ceilDouble(this.source.y + explosionSize + 1.0);
        double minZ = NukkitMath.floorDouble(this.source.z - explosionSize - 1.0);
        double maxZ = NukkitMath.ceilDouble(this.source.z + explosionSize + 1.0);
        SimpleAxisAlignedBB explosionBB = new SimpleAxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        for (Entity entity : list = this.level.getNearbyEntities(explosionBB, this.what instanceof Entity ? (Entity)this.what : null)) {
            int damage;
            double distance = entity.distance(this.source) / explosionSize;
            if (!(distance <= 1.0)) continue;
            Vector3 motion = entity.subtract(this.source).normalize();
            double exposure = this.getSeenPercent(this.source, entity);
            double impact = (1.0 - distance) * exposure;
            int n = damage = this.doesDamage ? Math.max((int)((impact * impact + impact) / 2.0 * 8.0 * explosionSize + 1.0), 0) : 0;
            if (this.what instanceof Entity) {
                entity.attack(new EntityDamageByEntityEvent((Entity)this.what, entity, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, damage));
            } else if (this.what instanceof Block) {
                entity.attack(new EntityDamageByBlockEvent((Block)this.what, entity, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, damage));
            } else {
                entity.attack(new EntityDamageEvent(entity, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, damage));
            }
            if (entity instanceof EntityItem || entity instanceof EntityXPOrb) continue;
            if (entity instanceof Player) {
                int netheritePieces = 0;
                for (Item armor : ((Player)entity).getInventory().getArmorContents()) {
                    if (armor.getTier() != 6) continue;
                    ++netheritePieces;
                }
                if (netheritePieces > 0) {
                    impact *= 1.0 - 0.1 * (double)netheritePieces;
                }
            }
            entity.setMotion(entity.getMotion().add(motion.multiply(impact)));
        }
        Item air = Item.get(0);
        for (Block block : this.affectedBlocks) {
            if (block.getId() == 46) {
                ((BlockTNT)block).prime(Utils.rand(10, 30), this.what instanceof Entity ? (Entity)this.what : null);
            } else {
                if (block.getId() == 26 && (block.getDamage() & 8) == 8) {
                    this.level.setBlockAt((int)block.x, (int)block.y, (int)block.z, 0);
                    continue;
                }
                BlockEntity container = this.level.getBlockEntity(block);
                if (container instanceof InventoryHolder && !container.closed) {
                    if (this.level.getGameRules().getBoolean(GameRule.DO_TILE_DROPS)) {
                        Item[] inv = ((InventoryHolder)((Object)container)).getInventory();
                        if (inv != null) {
                            inv.getViewers().clear();
                        }
                        if (container instanceof BlockEntityShulkerBox) {
                            this.level.dropItem(block.add(0.5, 0.5, 0.5), block.toItem());
                            ((BlockEntityShulkerBox)container).getInventory().clearAll();
                        } else {
                            container.onBreak();
                        }
                    }
                    container.close();
                } else if (block.alwaysDropsOnExplosion() || Math.random() * 100.0 < yield) {
                    if (this.level.getBlockIdAt((int)block.x, (int)block.y, (int)block.z) == 0) continue;
                    for (Item drop : block.getDrops(air)) {
                        this.level.dropItem(block.add(0.5, 0.5, 0.5), drop);
                    }
                }
            }
            this.level.setBlockAt((int)block.x, (int)block.y, (int)block.z, 0);
            Vector3 pos = new Vector3(block.x, block.y, block.z);
            block4: for (BlockFace side : BlockFace.values()) {
                Vector3 sideBlock = pos.getSide(side);
                long index = Hash.hashBlock((int)sideBlock.x, (int)sideBlock.y, (int)sideBlock.z);
                if (updateBlocks.contains(index)) continue;
                for (Block affected : this.affectedBlocks) {
                    if (affected.x != sideBlock.x || affected.y != sideBlock.y || affected.z != sideBlock.z) continue;
                    continue block4;
                }
                BlockUpdateEvent ev2 = new BlockUpdateEvent(this.level.getBlock(sideBlock));
                this.level.getServer().getPluginManager().callEvent(ev2);
                if (!ev2.isCancelled()) {
                    ev2.getBlock().onUpdate(1);
                }
                updateBlocks.add(index);
            }
        }
        this.level.addParticle(new HugeExplodeSeedParticle(this.source));
        this.level.addLevelSoundEvent(this.source, 48);
        return true;
    }

    public void explodeEntity() {
        Entity[] list;
        if (this.what instanceof Entity) {
            EntityExplodeEvent ev = new EntityExplodeEvent((Entity)this.what, this.source, this.affectedBlocks, 0.0);
            this.level.getServer().getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return;
            }
        }
        double explosionSize = this.size * 2.0;
        double minX = NukkitMath.floorDouble(this.source.x - explosionSize - 1.0);
        double maxX = NukkitMath.ceilDouble(this.source.x + explosionSize + 1.0);
        double minY = NukkitMath.floorDouble(this.source.y - explosionSize - 1.0);
        double maxY = NukkitMath.ceilDouble(this.source.y + explosionSize + 1.0);
        double minZ = NukkitMath.floorDouble(this.source.z - explosionSize - 1.0);
        double maxZ = NukkitMath.ceilDouble(this.source.z + explosionSize + 1.0);
        SimpleAxisAlignedBB explosionBB = new SimpleAxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        for (Entity entity : list = this.level.getNearbyEntities(explosionBB, this.what instanceof Entity ? (Entity)this.what : null)) {
            int damage;
            double distance;
            if (!(entity instanceof EntityLiving) || entity instanceof EntityEnderDragon || !((distance = entity.distance(this.source) / explosionSize) <= 1.0)) continue;
            Vector3 motion = entity.subtract(this.source).normalize();
            double exposure = this.getSeenPercent(this.source, entity);
            double impact = (1.0 - distance) * exposure;
            int n = damage = this.doesDamage ? Math.max((int)((impact * impact + impact) / 2.0 * 5.0 * this.size + 1.0), 0) : 0;
            if (this.what instanceof Entity) {
                entity.attack(new EntityDamageByEntityEvent((Entity)this.what, entity, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, damage));
            } else if (this.what instanceof Block) {
                entity.attack(new EntityDamageByBlockEvent((Block)this.what, entity, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, damage));
            } else {
                entity.attack(new EntityDamageEvent(entity, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, damage));
            }
            if (entity instanceof Player) {
                int netheritePieces = 0;
                for (Item armor : ((Player)entity).getInventory().getArmorContents()) {
                    if (armor.getTier() != 6) continue;
                    ++netheritePieces;
                }
                if (netheritePieces > 0) {
                    impact *= 1.0 - 0.1 * (double)netheritePieces;
                }
            }
            entity.setMotion(entity.getMotion().add(motion.multiply(impact)));
        }
    }

    private double getSeenPercent(Vector3 source, Entity entity) {
        AxisAlignedBB bb = entity.getBoundingBox();
        if (bb.isVectorInside(source)) {
            return 1.0;
        }
        double x = 1.0 / ((bb.getMaxX() - bb.getMinX()) * 2.0 + 1.0);
        double y = 1.0 / ((bb.getMaxY() - bb.getMinY()) * 2.0 + 1.0);
        double z = 1.0 / ((bb.getMaxZ() - bb.getMinZ()) * 2.0 + 1.0);
        double xOffset = (1.0 - Math.floor(1.0 / x) * x) / 2.0;
        double yOffset = (1.0 - Math.floor(1.0 / y) * y) / 2.0;
        double zOffset = (1.0 - Math.floor(1.0 / z) * z) / 2.0;
        int misses = 0;
        int total = 0;
        for (double i = 0.0; i <= 1.0; i += x) {
            for (double j = 0.0; j <= 1.0; j += y) {
                for (double k = 0.0; k <= 1.0; k += z) {
                    Vector3 target = new Vector3(bb.getMinX() + i * (bb.getMaxX() - bb.getMinX()) + xOffset, bb.getMinY() + j * (bb.getMaxY() - bb.getMinY()) + yOffset, bb.getMinZ() + k * (bb.getMaxZ() - bb.getMinZ()) + zOffset);
                    if (!this.raycast(source, target)) {
                        ++misses;
                    }
                    ++total;
                }
            }
        }
        return total != 0 ? (double)misses / (double)total : 0.0;
    }

    private boolean raycast(Vector3 start, Vector3 end) {
        Vector3 current = new Vector3(start.x, start.y, start.z);
        Vector3 direction = end.subtract(start).normalize();
        double stepX = Explosion.sign(direction.getX());
        double stepY = Explosion.sign(direction.getY());
        double stepZ = Explosion.sign(direction.getZ());
        double tMaxX = Explosion.boundary(start.getX(), direction.getX());
        double tMaxY = Explosion.boundary(start.getY(), direction.getY());
        double tMaxZ = Explosion.boundary(start.getZ(), direction.getZ());
        double tDeltaX = direction.getX() == 0.0 ? 0.0 : stepX / direction.getX();
        double tDeltaY = direction.getY() == 0.0 ? 0.0 : stepY / direction.getY();
        double tDeltaZ = direction.getZ() == 0.0 ? 0.0 : stepZ / direction.getZ();
        double radius = start.distance(end);
        while (true) {
            Block block;
            if ((block = this.level.getBlock(current)).isSolid() && block.calculateIntercept(current, end) != null) {
                return true;
            }
            if (tMaxX < tMaxY && tMaxX < tMaxZ) {
                if (tMaxX > radius) break;
                current.x += stepX;
                tMaxX += tDeltaX;
                continue;
            }
            if (tMaxY < tMaxZ) {
                if (tMaxY > radius) break;
                current.y += stepY;
                tMaxY += tDeltaY;
                continue;
            }
            if (tMaxZ > radius) break;
            current.z += stepZ;
            tMaxZ += tDeltaZ;
        }
        return false;
    }

    private static double sign(double d) {
        if (d > 0.0) {
            return 1.0;
        }
        if (d < 0.0) {
            return -1.0;
        }
        return 0.0;
    }

    private static double boundary(double start, double distance) {
        if (distance == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (distance < 0.0) {
            start = -start;
            distance = -distance;
            if (Math.floor(start) == start) {
                return 0.0;
            }
        }
        return (1.0 - (start - Math.floor(start))) / distance;
    }

    public void setMinHeight(double minHeight) {
        this.minHeight = minHeight;
    }
}

