/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level;

import cn.nukkit.Server;
import cn.nukkit.level.Level;
import cn.nukkit.level.generator.Generator;

public enum EnumLevel {
    OVERWORLD,
    NETHER,
    THE_END;

    private Level level;

    public Level getLevel() {
        return this.level;
    }

    public static void initLevels() {
        Server server = Server.getInstance();
        EnumLevel.OVERWORLD.level = server.getDefaultLevel();
        if (server.getPropertyBoolean("allow-nether", true)) {
            if (server.getLevelByName("nether") == null) {
                server.generateLevel("nether", System.currentTimeMillis(), Generator.getGenerator(3));
                server.loadLevel("nether");
            }
            EnumLevel.NETHER.level = server.getLevelByName("nether");
        }
        if (server.getPropertyBoolean("allow-the-end", true)) {
            if (server.getLevelByName("the_end") == null) {
                server.generateLevel("the_end", System.currentTimeMillis(), Generator.getGenerator(4));
                server.loadLevel("the_end");
            }
            EnumLevel.THE_END.level = server.getLevelByName("the_end");
        }
    }

    static int mRound32(int value) {
        return Math.round((float)value / 32.0f) * 32;
    }
}

