/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level;

import cn.nukkit.nbt.tag.CompoundTag;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockPalette {
    @Generated
    private static final Logger log = LogManager.getLogger(BlockPalette.class);
    private final int protocol;
    private final Int2IntMap legacyToRuntimeId = new Int2IntOpenHashMap();
    private final Int2IntMap runtimeIdToLegacy = new Int2IntOpenHashMap();
    private final Map<CompoundTag, Integer> stateToLegacy = new HashMap<CompoundTag, Integer>();
    private volatile boolean locked;

    public BlockPalette(int protocol) {
        this.protocol = protocol;
        this.legacyToRuntimeId.defaultReturnValue(-1);
        this.runtimeIdToLegacy.defaultReturnValue(-1);
    }

    public void clearStates() {
        this.locked = false;
        this.legacyToRuntimeId.clear();
        this.runtimeIdToLegacy.clear();
        this.stateToLegacy.clear();
    }

    public void registerState(int blockId, int data, int runtimeId, CompoundTag blockState) {
        if (this.locked) {
            throw new IllegalStateException("Block palette is already locked!");
        }
        int legacyId = blockId << 6 | data;
        this.legacyToRuntimeId.put(legacyId, runtimeId);
        this.runtimeIdToLegacy.putIfAbsent(runtimeId, legacyId);
        this.stateToLegacy.putIfAbsent(blockState, legacyId);
    }

    public void lock() {
        this.locked = true;
    }

    public int getRuntimeId(int id, int meta) {
        int legacyId = id << 6 | meta;
        int runtimeId = this.legacyToRuntimeId.get(legacyId);
        if (runtimeId == -1 && (runtimeId = this.legacyToRuntimeId.get(id << 6)) == -1) {
            runtimeId = this.legacyToRuntimeId.get(15872);
            log.info("Missing block runtime id mappings for {}:{}", (Object)id, (Object)meta);
        }
        return runtimeId;
    }

    public int getRuntimeId(int legacyId) {
        int runtimeId = this.legacyToRuntimeId.get(legacyId);
        if (runtimeId == -1) {
            log.info("Missing block runtime id mappings for {}", (Object)legacyId);
            return this.legacyToRuntimeId.get(15872);
        }
        return runtimeId;
    }

    public int getLegacyFullId(int runtimeId) {
        return this.runtimeIdToLegacy.get(runtimeId);
    }

    public int getLegacyFullId(CompoundTag state) {
        return this.stateToLegacy.getOrDefault(state, -1);
    }

    public Int2IntMap getLegacyToRuntimeIdMap() {
        return Int2IntMaps.unmodifiable(this.legacyToRuntimeId);
    }

    @Generated
    public int getProtocol() {
        return this.protocol;
    }

    @Generated
    public Int2IntMap getLegacyToRuntimeId() {
        return this.legacyToRuntimeId;
    }

    @Generated
    public Int2IntMap getRuntimeIdToLegacy() {
        return this.runtimeIdToLegacy;
    }

    @Generated
    public Map<CompoundTag, Integer> getStateToLegacy() {
        return this.stateToLegacy;
    }

    @Generated
    public boolean isLocked() {
        return this.locked;
    }

    @Generated
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockPalette)) {
            return false;
        }
        BlockPalette other = (BlockPalette)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProtocol() != other.getProtocol()) {
            return false;
        }
        if (this.isLocked() != other.isLocked()) {
            return false;
        }
        Int2IntMap this$legacyToRuntimeId = this.getLegacyToRuntimeId();
        Int2IntMap other$legacyToRuntimeId = other.getLegacyToRuntimeId();
        if (this$legacyToRuntimeId == null ? other$legacyToRuntimeId != null : !this$legacyToRuntimeId.equals(other$legacyToRuntimeId)) {
            return false;
        }
        Int2IntMap this$runtimeIdToLegacy = this.getRuntimeIdToLegacy();
        Int2IntMap other$runtimeIdToLegacy = other.getRuntimeIdToLegacy();
        if (this$runtimeIdToLegacy == null ? other$runtimeIdToLegacy != null : !this$runtimeIdToLegacy.equals(other$runtimeIdToLegacy)) {
            return false;
        }
        Map<CompoundTag, Integer> this$stateToLegacy = this.getStateToLegacy();
        Map<CompoundTag, Integer> other$stateToLegacy = other.getStateToLegacy();
        return !(this$stateToLegacy == null ? other$stateToLegacy != null : !((Object)this$stateToLegacy).equals(other$stateToLegacy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BlockPalette;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getProtocol();
        result = result * 59 + (this.isLocked() ? 79 : 97);
        Int2IntMap $legacyToRuntimeId = this.getLegacyToRuntimeId();
        result = result * 59 + ($legacyToRuntimeId == null ? 43 : $legacyToRuntimeId.hashCode());
        Int2IntMap $runtimeIdToLegacy = this.getRuntimeIdToLegacy();
        result = result * 59 + ($runtimeIdToLegacy == null ? 43 : $runtimeIdToLegacy.hashCode());
        Map<CompoundTag, Integer> $stateToLegacy = this.getStateToLegacy();
        result = result * 59 + ($stateToLegacy == null ? 43 : ((Object)$stateToLegacy).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BlockPalette(protocol=" + this.getProtocol() + ", legacyToRuntimeId=" + this.getLegacyToRuntimeId() + ", runtimeIdToLegacy=" + this.getRuntimeIdToLegacy() + ", stateToLegacy=" + this.getStateToLegacy() + ", locked=" + this.isLocked() + ")";
    }
}

