/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item.food;

import cn.nukkit.Player;
import cn.nukkit.event.entity.EntityPotionEffectEvent;
import cn.nukkit.item.food.Food;
import cn.nukkit.potion.Effect;
import java.util.LinkedHashMap;
import java.util.Map;

public class FoodEffective
extends Food {
    protected final Map<Effect, Float> effects = new LinkedHashMap<Effect, Float>();

    public FoodEffective(int restoreFood, float restoreSaturation) {
        this.setRestoreFood(restoreFood);
        this.setRestoreSaturation(restoreSaturation);
    }

    public FoodEffective addEffect(Effect effect) {
        return this.addChanceEffect(1.0f, effect);
    }

    public FoodEffective addChanceEffect(float chance, Effect effect) {
        if (chance > 1.0f) {
            chance = 1.0f;
        }
        if (chance < 0.0f) {
            chance = 0.0f;
        }
        this.effects.put(effect, Float.valueOf(chance));
        return this;
    }

    @Override
    protected boolean onEatenBy(Player player) {
        super.onEatenBy(player);
        this.effects.forEach((effect, chance) -> {
            if ((double)chance.floatValue() >= Math.random()) {
                player.addEffect(effect.clone(), EntityPotionEffectEvent.Cause.FOOD);
            }
        });
        Food.NodeIDMeta id = (Food.NodeIDMeta)this.relativeIDs.get(0);
        if (id != null && id.id == 466) {
            player.awardAchievement("overpowered");
        }
        return true;
    }
}

