/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item.enchantment.damage;

import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityArthropod;
import cn.nukkit.event.entity.EntityPotionEffectEvent;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.item.enchantment.damage.EnchantmentDamage;
import cn.nukkit.potion.Effect;
import cn.nukkit.utils.Utils;

public class EnchantmentDamageArthropods
extends EnchantmentDamage {
    public EnchantmentDamageArthropods() {
        super(11, "arthropods", Enchantment.Rarity.UNCOMMON, EnchantmentDamage.TYPE.SMITE);
    }

    @Override
    public int getMinEnchantAbility(int level) {
        return 5 + (level - 1 << 3);
    }

    @Override
    public int getMaxEnchantAbility(int level) {
        return this.getMinEnchantAbility(level) + 20;
    }

    @Override
    public double getDamageBonus(Entity entity) {
        if (entity instanceof EntityArthropod) {
            return (double)this.getLevel() * 2.5;
        }
        return 0.0;
    }

    @Override
    public void doPostAttack(Entity attacker, Entity entity) {
        if (entity instanceof EntityArthropod) {
            entity.addEffect(Effect.getEffect(2).setDuration(20 + Utils.random.nextInt(10 * this.level)).setAmplifier(3), EntityPotionEffectEvent.Cause.ATTACK);
        }
    }
}

