/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item.custom;

import cn.nukkit.item.Item;
import cn.nukkit.item.ItemEdible;
import cn.nukkit.item.custom.CustomItem;
import cn.nukkit.nbt.tag.CompoundTag;
import java.util.List;
import lombok.Generated;

public class ItemDefinition {
    private final String identifier;
    private final int legacyId;
    private final Class<? extends Item> implementation;
    private final String texture;
    private final String overrideDisplayName;
    private final CreativeCategory creativeCategory;
    private final String creativeGroup;
    private final boolean foil;
    private final boolean canDestroyInCreative;
    private final List<CompoundTag> customProperties;
    private final List<CompoundTag> customComponents;

    public CompoundTag getNetworkData() {
        try {
            Item item = this.implementation.getConstructor(Integer.class, Integer.TYPE).newInstance(0, 1);
            if (!(item instanceof CustomItem)) {
                throw new IllegalStateException("Implementation of " + this.identifier + " does not implement CustomItem");
            }
            CompoundTag properties = new CompoundTag().putInt("max_stack_size", item.getMaxStackSize()).putBoolean("hand_equipped", item.isTool()).putBoolean("allow_off_hand", item.allowOffhand()).putBoolean("can_destroy_in_creative", this.canDestroyInCreative);
            properties.putCompound("minecraft:icon", new CompoundTag().putCompound("textures", new CompoundTag().putString("default", this.texture)));
            if (this.creativeCategory != null) {
                properties.putInt("creative_category", this.creativeCategory.id);
                if (this.creativeCategory != CreativeCategory.NONE && this.creativeGroup != null) {
                    properties.putString("creative_group", this.creativeGroup);
                }
            }
            if (this.foil) {
                properties.putBoolean("foil", true);
            }
            CompoundTag components = new CompoundTag().putCompound("item_properties", properties).putCompound("minecraft:display_name", new CompoundTag().putString("value", this.overrideDisplayName == null ? item.getName() : this.overrideDisplayName));
            if (item.getMaxDurability() > 0) {
                components.putCompound("minecraft:durability", new CompoundTag().putInt("max_durability", item.getMaxDurability()));
            }
            if (item.isArmor()) {
                components.putCompound("minecraft:armor", new CompoundTag().putInt("protection", item.getArmorPoints()));
                if (item.isHelmet()) {
                    properties.putString("wearable_slot", "slot.armor.head");
                    components.putCompound("minecraft:wearable", new CompoundTag().putString("slot", "slot.armor.head"));
                } else if (item.isChestplate()) {
                    properties.putString("wearable_slot", "slot.armor.chest");
                    components.putCompound("minecraft:wearable", new CompoundTag().putString("slot", "slot.armor.chest"));
                } else if (item.isLeggings()) {
                    properties.putString("wearable_slot", "slot.armor.legs");
                    components.putCompound("minecraft:wearable", new CompoundTag().putString("slot", "slot.armor.legs"));
                } else if (item.isBoots()) {
                    properties.putString("wearable_slot", "slot.armor.feet");
                    components.putCompound("minecraft:wearable", new CompoundTag().putString("slot", "slot.armor.feet"));
                }
            }
            if (item instanceof ItemEdible) {
                components.putCompound("minecraft:food", new CompoundTag().putBoolean("can_always_eat", ((ItemEdible)item).canAlwaysEat()));
                properties.putInt("use_duration", ((ItemEdible)item).getUseTicks()).putInt("use_animation", ((ItemEdible)item).isDrink() ? 2 : 1);
            }
            if (item.isTool()) {
                properties.putInt("damage", item.getAttackDamage());
            }
            if (this.customProperties != null) {
                for (CompoundTag property : this.customProperties) {
                    components.putCompound(property.getName(), property);
                }
            }
            if (this.customComponents != null) {
                for (CompoundTag component : this.customComponents) {
                    components.putCompound(component.getName(), component);
                }
            }
            return new CompoundTag().putCompound("components", components);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    private static boolean $default$canDestroyInCreative() {
        return true;
    }

    @Generated
    ItemDefinition(String identifier, int legacyId, Class<? extends Item> implementation, String texture, String overrideDisplayName, CreativeCategory creativeCategory, String creativeGroup, boolean foil, boolean canDestroyInCreative, List<CompoundTag> customProperties, List<CompoundTag> customComponents) {
        this.identifier = identifier;
        this.legacyId = legacyId;
        this.implementation = implementation;
        this.texture = texture;
        this.overrideDisplayName = overrideDisplayName;
        this.creativeCategory = creativeCategory;
        this.creativeGroup = creativeGroup;
        this.foil = foil;
        this.canDestroyInCreative = canDestroyInCreative;
        this.customProperties = customProperties;
        this.customComponents = customComponents;
    }

    @Generated
    public static ItemDefinitionBuilder builder() {
        return new ItemDefinitionBuilder();
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public int getLegacyId() {
        return this.legacyId;
    }

    @Generated
    public Class<? extends Item> getImplementation() {
        return this.implementation;
    }

    @Generated
    public String getTexture() {
        return this.texture;
    }

    @Generated
    public String getOverrideDisplayName() {
        return this.overrideDisplayName;
    }

    @Generated
    public CreativeCategory getCreativeCategory() {
        return this.creativeCategory;
    }

    @Generated
    public String getCreativeGroup() {
        return this.creativeGroup;
    }

    @Generated
    public boolean isFoil() {
        return this.foil;
    }

    @Generated
    public boolean isCanDestroyInCreative() {
        return this.canDestroyInCreative;
    }

    @Generated
    public List<CompoundTag> getCustomProperties() {
        return this.customProperties;
    }

    @Generated
    public List<CompoundTag> getCustomComponents() {
        return this.customComponents;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemDefinition)) {
            return false;
        }
        ItemDefinition other = (ItemDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLegacyId() != other.getLegacyId()) {
            return false;
        }
        if (this.isFoil() != other.isFoil()) {
            return false;
        }
        if (this.isCanDestroyInCreative() != other.isCanDestroyInCreative()) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        Class<? extends Item> this$implementation = this.getImplementation();
        Class<? extends Item> other$implementation = other.getImplementation();
        if (this$implementation == null ? other$implementation != null : !this$implementation.equals(other$implementation)) {
            return false;
        }
        String this$texture = this.getTexture();
        String other$texture = other.getTexture();
        if (this$texture == null ? other$texture != null : !this$texture.equals(other$texture)) {
            return false;
        }
        String this$overrideDisplayName = this.getOverrideDisplayName();
        String other$overrideDisplayName = other.getOverrideDisplayName();
        if (this$overrideDisplayName == null ? other$overrideDisplayName != null : !this$overrideDisplayName.equals(other$overrideDisplayName)) {
            return false;
        }
        CreativeCategory this$creativeCategory = this.getCreativeCategory();
        CreativeCategory other$creativeCategory = other.getCreativeCategory();
        if (this$creativeCategory == null ? other$creativeCategory != null : !((Object)((Object)this$creativeCategory)).equals((Object)other$creativeCategory)) {
            return false;
        }
        String this$creativeGroup = this.getCreativeGroup();
        String other$creativeGroup = other.getCreativeGroup();
        if (this$creativeGroup == null ? other$creativeGroup != null : !this$creativeGroup.equals(other$creativeGroup)) {
            return false;
        }
        List<CompoundTag> this$customProperties = this.getCustomProperties();
        List<CompoundTag> other$customProperties = other.getCustomProperties();
        if (this$customProperties == null ? other$customProperties != null : !((Object)this$customProperties).equals(other$customProperties)) {
            return false;
        }
        List<CompoundTag> this$customComponents = this.getCustomComponents();
        List<CompoundTag> other$customComponents = other.getCustomComponents();
        return !(this$customComponents == null ? other$customComponents != null : !((Object)this$customComponents).equals(other$customComponents));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ItemDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLegacyId();
        result = result * 59 + (this.isFoil() ? 79 : 97);
        result = result * 59 + (this.isCanDestroyInCreative() ? 79 : 97);
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        Class<? extends Item> $implementation = this.getImplementation();
        result = result * 59 + ($implementation == null ? 43 : $implementation.hashCode());
        String $texture = this.getTexture();
        result = result * 59 + ($texture == null ? 43 : $texture.hashCode());
        String $overrideDisplayName = this.getOverrideDisplayName();
        result = result * 59 + ($overrideDisplayName == null ? 43 : $overrideDisplayName.hashCode());
        CreativeCategory $creativeCategory = this.getCreativeCategory();
        result = result * 59 + ($creativeCategory == null ? 43 : ((Object)((Object)$creativeCategory)).hashCode());
        String $creativeGroup = this.getCreativeGroup();
        result = result * 59 + ($creativeGroup == null ? 43 : $creativeGroup.hashCode());
        List<CompoundTag> $customProperties = this.getCustomProperties();
        result = result * 59 + ($customProperties == null ? 43 : ((Object)$customProperties).hashCode());
        List<CompoundTag> $customComponents = this.getCustomComponents();
        result = result * 59 + ($customComponents == null ? 43 : ((Object)$customComponents).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ItemDefinition(identifier=" + this.getIdentifier() + ", legacyId=" + this.getLegacyId() + ", implementation=" + this.getImplementation() + ", texture=" + this.getTexture() + ", overrideDisplayName=" + this.getOverrideDisplayName() + ", creativeCategory=" + (Object)((Object)this.getCreativeCategory()) + ", creativeGroup=" + this.getCreativeGroup() + ", foil=" + this.isFoil() + ", canDestroyInCreative=" + this.isCanDestroyInCreative() + ", customProperties=" + this.getCustomProperties() + ", customComponents=" + this.getCustomComponents() + ")";
    }

    @Generated
    public static class ItemDefinitionBuilder {
        @Generated
        private String identifier;
        @Generated
        private int legacyId;
        @Generated
        private Class<? extends Item> implementation;
        @Generated
        private String texture;
        @Generated
        private String overrideDisplayName;
        @Generated
        private CreativeCategory creativeCategory;
        @Generated
        private String creativeGroup;
        @Generated
        private boolean foil;
        @Generated
        private boolean canDestroyInCreative$set;
        @Generated
        private boolean canDestroyInCreative$value;
        @Generated
        private List<CompoundTag> customProperties;
        @Generated
        private List<CompoundTag> customComponents;

        @Generated
        ItemDefinitionBuilder() {
        }

        @Generated
        public ItemDefinitionBuilder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Generated
        public ItemDefinitionBuilder legacyId(int legacyId) {
            this.legacyId = legacyId;
            return this;
        }

        @Generated
        public ItemDefinitionBuilder implementation(Class<? extends Item> implementation) {
            this.implementation = implementation;
            return this;
        }

        @Generated
        public ItemDefinitionBuilder texture(String texture) {
            this.texture = texture;
            return this;
        }

        @Generated
        public ItemDefinitionBuilder overrideDisplayName(String overrideDisplayName) {
            this.overrideDisplayName = overrideDisplayName;
            return this;
        }

        @Generated
        public ItemDefinitionBuilder creativeCategory(CreativeCategory creativeCategory) {
            this.creativeCategory = creativeCategory;
            return this;
        }

        @Generated
        public ItemDefinitionBuilder creativeGroup(String creativeGroup) {
            this.creativeGroup = creativeGroup;
            return this;
        }

        @Generated
        public ItemDefinitionBuilder foil(boolean foil) {
            this.foil = foil;
            return this;
        }

        @Generated
        public ItemDefinitionBuilder canDestroyInCreative(boolean canDestroyInCreative) {
            this.canDestroyInCreative$value = canDestroyInCreative;
            this.canDestroyInCreative$set = true;
            return this;
        }

        @Generated
        public ItemDefinitionBuilder customProperties(List<CompoundTag> customProperties) {
            this.customProperties = customProperties;
            return this;
        }

        @Generated
        public ItemDefinitionBuilder customComponents(List<CompoundTag> customComponents) {
            this.customComponents = customComponents;
            return this;
        }

        @Generated
        public ItemDefinition build() {
            boolean canDestroyInCreative$value = this.canDestroyInCreative$value;
            if (!this.canDestroyInCreative$set) {
                canDestroyInCreative$value = ItemDefinition.$default$canDestroyInCreative();
            }
            return new ItemDefinition(this.identifier, this.legacyId, this.implementation, this.texture, this.overrideDisplayName, this.creativeCategory, this.creativeGroup, this.foil, canDestroyInCreative$value, this.customProperties, this.customComponents);
        }

        @Generated
        public String toString() {
            return "ItemDefinition.ItemDefinitionBuilder(identifier=" + this.identifier + ", legacyId=" + this.legacyId + ", implementation=" + this.implementation + ", texture=" + this.texture + ", overrideDisplayName=" + this.overrideDisplayName + ", creativeCategory=" + (Object)((Object)this.creativeCategory) + ", creativeGroup=" + this.creativeGroup + ", foil=" + this.foil + ", canDestroyInCreative$value=" + this.canDestroyInCreative$value + ", customProperties=" + this.customProperties + ", customComponents=" + this.customComponents + ")";
        }
    }

    public static enum CreativeCategory {
        CONSTRUCTION(1),
        NATURE(2),
        EQUIPMENT(3),
        ITEMS(4),
        NONE(6);

        private final int id;

        @Generated
        private CreativeCategory(int id) {
            this.id = id;
        }
    }
}

