/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.item.RuntimeItemMapping;
import cn.nukkit.utils.Utils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RuntimeItems {
    @Generated
    private static final Logger log = LogManager.getLogger(RuntimeItems.class);
    private static final Map<String, Integer> legacyString2LegacyInt = new HashMap<String, Integer>();
    private static final Map<Integer, String> legacyInt2LegacyString = new HashMap<Integer, String>();
    private static final Map<String, MappingEntry> latestIdentifierMapping = new HashMap<String, MappingEntry>();
    private static RuntimeItemMapping mapping;
    private static boolean initialized;

    public static void init() {
        if (initialized) {
            throw new IllegalStateException("RuntimeItems were already generated!");
        }
        initialized = true;
        log.debug("Loading runtime items...");
        JsonObject json = Utils.loadJsonResource("legacy_item_ids.json").getAsJsonObject();
        for (Map.Entry<String, JsonElement> identifierToId : json.entrySet()) {
            int legacyId = identifierToId.getValue().getAsInt();
            legacyString2LegacyInt.put(identifierToId.getKey(), legacyId);
            legacyInt2LegacyString.put(legacyId, identifierToId.getKey());
        }
        JsonObject itemMapping = Utils.loadJsonResource("item_mappings.json").getAsJsonObject();
        Map<String, MappingEntry> mappingEntries = latestIdentifierMapping;
        HashMap<String, MappingEntry> mappingEntriesLegacy = new HashMap<String, MappingEntry>();
        for (String legacyName : itemMapping.keySet()) {
            JsonObject convertData = itemMapping.getAsJsonObject(legacyName);
            boolean isLegacyStone = "minecraft:stone".equals(legacyName);
            for (String damageStr : convertData.keySet()) {
                String identifier = convertData.get(damageStr).getAsString();
                int damage = Integer.parseInt(damageStr);
                mappingEntries.put(identifier, new MappingEntry(legacyName, damage));
                if (isLegacyStone) continue;
                mappingEntriesLegacy.put(identifier, new MappingEntry(legacyName, damage));
            }
        }
        mapping = new RuntimeItemMapping(mappingEntries);
    }

    public static RuntimeItemMapping getMapping() {
        return mapping;
    }

    public static int getLegacyIdFromLegacyString(String identifier) {
        return legacyString2LegacyInt.getOrDefault(identifier, -1);
    }

    public static String getLegacyStringFromLegacyId(int legacyId) {
        return legacyInt2LegacyString.getOrDefault(legacyId, "minecraft:info_update");
    }

    public static String getLegacyStringFromNew(String identifier) {
        MappingEntry entry = latestIdentifierMapping.get(identifier);
        return entry == null ? identifier : entry.getLegacyName();
    }

    public static int getId(int fullId) {
        return (short)(fullId >> 16);
    }

    public static int getData(int fullId) {
        return fullId >> 1 & Short.MAX_VALUE;
    }

    public static int getFullId(int id, int data) {
        return (short)id << 16 | (data & Short.MAX_VALUE) << 1;
    }

    public static int getNetworkId(int networkFullId) {
        return networkFullId >> 1;
    }

    public static boolean hasData(int id) {
        return (id & 1) != 0;
    }

    @Generated
    private RuntimeItems() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class MappingEntry {
        private final String legacyName;
        private final int damage;

        @Generated
        public MappingEntry(String legacyName, int damage) {
            this.legacyName = legacyName;
            this.damage = damage;
        }

        @Generated
        public String getLegacyName() {
            return this.legacyName;
        }

        @Generated
        public int getDamage() {
            return this.damage;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MappingEntry)) {
                return false;
            }
            MappingEntry other = (MappingEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDamage() != other.getDamage()) {
                return false;
            }
            String this$legacyName = this.getLegacyName();
            String other$legacyName = other.getLegacyName();
            return !(this$legacyName == null ? other$legacyName != null : !this$legacyName.equals(other$legacyName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MappingEntry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDamage();
            String $legacyName = this.getLegacyName();
            result = result * 59 + ($legacyName == null ? 43 : $legacyName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RuntimeItems.MappingEntry(legacyName=" + this.getLegacyName() + ", damage=" + this.getDamage() + ")";
        }
    }
}

