/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Nukkit;
import cn.nukkit.item.Item;
import cn.nukkit.item.RuntimeItems;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RuntimeItemMapping {
    @Generated
    private static final Logger log = LogManager.getLogger(RuntimeItemMapping.class);
    private final Int2ObjectMap<LegacyEntry> runtime2Legacy = new Int2ObjectOpenHashMap<LegacyEntry>();
    private final Int2ObjectMap<RuntimeEntry> legacy2Runtime = new Int2ObjectOpenHashMap<RuntimeEntry>();
    private final Map<String, LegacyEntry> identifier2Legacy = new HashMap<String, LegacyEntry>();
    private byte[] itemPalette;

    public RuntimeItemMapping(Map<String, RuntimeItems.MappingEntry> mappings) {
        JsonArray json = Utils.loadJsonResource("runtime_item_states.json").getAsJsonArray();
        if (json.isEmpty()) {
            throw new IllegalStateException("Empty array");
        }
        for (JsonElement element : json) {
            int legacyId;
            if (!element.isJsonObject()) {
                throw new IllegalStateException("Invalid entry");
            }
            JsonObject entry = element.getAsJsonObject();
            String identifier = entry.get("name").getAsString();
            int runtimeId = entry.get("id").getAsInt();
            boolean hasDamage = false;
            int damage = 0;
            if (mappings.containsKey(identifier)) {
                RuntimeItems.MappingEntry mapping = mappings.get(identifier);
                legacyId = RuntimeItems.getLegacyIdFromLegacyString(mapping.getLegacyName());
                if (legacyId == -1) {
                    throw new IllegalStateException("Unable to match " + mapping + " with legacyId");
                }
                damage = mapping.getDamage();
                hasDamage = true;
            } else {
                legacyId = RuntimeItems.getLegacyIdFromLegacyString(identifier);
                if (legacyId == -1) {
                    log.trace("Unable to find legacyId for " + identifier);
                    continue;
                }
            }
            this.registerItem(identifier, runtimeId, legacyId, damage, hasDamage);
        }
        this.generatePalette();
    }

    public void registerItem(String identifier, int runtimeId, int legacyId, int damage) {
        this.registerItem(identifier, runtimeId, legacyId, damage, false);
    }

    public void registerItem(String identifier, int runtimeId, int legacyId, int damage, boolean hasDamage) {
        int fullId = this.getFullId(legacyId, damage);
        LegacyEntry legacyEntry = new LegacyEntry(legacyId, hasDamage, damage);
        if (Nukkit.DEBUG > 1 && this.runtime2Legacy.containsKey(runtimeId)) {
            log.warn("RuntimeItemMapping: Registering " + identifier + " but runtime id " + runtimeId + " is already used");
        }
        this.runtime2Legacy.put(runtimeId, legacyEntry);
        this.identifier2Legacy.put(identifier, legacyEntry);
        if (!hasDamage && this.legacy2Runtime.containsKey(fullId)) {
            log.debug("RuntimeItemMapping contains duplicated legacy item state runtimeId=" + runtimeId + " identifier=" + identifier);
        } else {
            this.legacy2Runtime.put(fullId, new RuntimeEntry(identifier, runtimeId, hasDamage));
        }
    }

    public void generatePalette() {
        BinaryStream paletteBuffer = new BinaryStream();
        paletteBuffer.putUnsignedVarInt(this.legacy2Runtime.size());
        for (RuntimeEntry entry : this.legacy2Runtime.values()) {
            paletteBuffer.putString(entry.getIdentifier());
            paletteBuffer.putLShort(entry.getRuntimeId());
            paletteBuffer.putBoolean(!entry.getIdentifier().startsWith("minecraft:"));
        }
        this.itemPalette = paletteBuffer.getBuffer();
    }

    public LegacyEntry fromRuntime(int runtimeId) {
        LegacyEntry legacyEntry = (LegacyEntry)this.runtime2Legacy.get(runtimeId);
        if (legacyEntry == null) {
            log.warn("Unknown runtime2Legacy mapping: " + runtimeId);
            return new LegacyEntry(0, false, 0);
        }
        return legacyEntry;
    }

    public RuntimeEntry toRuntime(int id, int meta) {
        RuntimeEntry runtimeEntry = (RuntimeEntry)this.legacy2Runtime.get(this.getFullId(id, meta));
        if (runtimeEntry == null) {
            runtimeEntry = (RuntimeEntry)this.legacy2Runtime.get(this.getFullId(id, 0));
        }
        if (runtimeEntry == null) {
            log.warn("Unknown legacy2Runtime mapping: id=" + id + " meta=" + meta);
            runtimeEntry = (RuntimeEntry)this.legacy2Runtime.get(this.getFullId(248, 0));
            if (runtimeEntry == null) {
                throw new RuntimeException("Runtime ID for Item.INFO_UPDATE must exist!");
            }
        }
        return runtimeEntry;
    }

    public Item parseCreativeItem(JsonObject json, boolean ignoreUnknown) {
        String identifier = json.get("id").getAsString();
        LegacyEntry legacyEntry = this.fromIdentifier(identifier);
        if (legacyEntry == null) {
            log.trace("Can not find legacyEntry for " + identifier);
            if (!ignoreUnknown) {
                throw new IllegalStateException("Can not find legacyEntry for " + identifier);
            }
            return null;
        }
        byte[] nbtBytes = json.has("nbt_b64") ? Base64.getDecoder().decode(json.get("nbt_b64").getAsString()) : (json.has("nbt_hex") ? Utils.parseHexBinary(json.get("nbt_hex").getAsString()) : new byte[]{});
        int legacyId = legacyEntry.getLegacyId();
        int damage = 0;
        if (json.has("damage")) {
            damage = json.get("damage").getAsInt();
        } else if (legacyEntry.isHasDamage()) {
            damage = legacyEntry.getDamage();
        } else if (json.has("blockRuntimeId")) {
            int runtimeId = json.get("blockRuntimeId").getAsInt();
            int fullId = GlobalBlockPalette.getLegacyFullId(runtimeId);
            if (fullId == -1) {
                if (ignoreUnknown) {
                    return null;
                }
                throw new IllegalStateException("Can not find blockRuntimeId for " + identifier + " (" + runtimeId + ")");
            }
            damage = fullId & 0x3F;
        }
        int count = json.has("count") ? json.get("count").getAsInt() : 1;
        return Item.get(legacyId, (Integer)damage, count, nbtBytes);
    }

    public LegacyEntry fromIdentifier(String identifier) {
        return this.identifier2Legacy.get(identifier);
    }

    public int getFullId(int id, int data) {
        return (short)id << 16 | (data & Short.MAX_VALUE) << 1;
    }

    public byte[] getItemPalette() {
        return this.itemPalette;
    }

    public static class RuntimeEntry {
        private final String identifier;
        private final int runtimeId;
        private final boolean hasDamage;

        @Generated
        public RuntimeEntry(String identifier, int runtimeId, boolean hasDamage) {
            this.identifier = identifier;
            this.runtimeId = runtimeId;
            this.hasDamage = hasDamage;
        }

        @Generated
        public String getIdentifier() {
            return this.identifier;
        }

        @Generated
        public int getRuntimeId() {
            return this.runtimeId;
        }

        @Generated
        public boolean isHasDamage() {
            return this.hasDamage;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RuntimeEntry)) {
                return false;
            }
            RuntimeEntry other = (RuntimeEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRuntimeId() != other.getRuntimeId()) {
                return false;
            }
            if (this.isHasDamage() != other.isHasDamage()) {
                return false;
            }
            String this$identifier = this.getIdentifier();
            String other$identifier = other.getIdentifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RuntimeEntry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRuntimeId();
            result = result * 59 + (this.isHasDamage() ? 79 : 97);
            String $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RuntimeItemMapping.RuntimeEntry(identifier=" + this.getIdentifier() + ", runtimeId=" + this.getRuntimeId() + ", hasDamage=" + this.isHasDamage() + ")";
        }
    }

    public static class LegacyEntry {
        private final int legacyId;
        private final boolean hasDamage;
        private final int damage;

        public int getDamage() {
            return this.hasDamage ? this.damage : 0;
        }

        @Generated
        public LegacyEntry(int legacyId, boolean hasDamage, int damage) {
            this.legacyId = legacyId;
            this.hasDamage = hasDamage;
            this.damage = damage;
        }

        @Generated
        public int getLegacyId() {
            return this.legacyId;
        }

        @Generated
        public boolean isHasDamage() {
            return this.hasDamage;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LegacyEntry)) {
                return false;
            }
            LegacyEntry other = (LegacyEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLegacyId() != other.getLegacyId()) {
                return false;
            }
            if (this.isHasDamage() != other.isHasDamage()) {
                return false;
            }
            return this.getDamage() == other.getDamage();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LegacyEntry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLegacyId();
            result = result * 59 + (this.isHasDamage() ? 79 : 97);
            result = result * 59 + this.getDamage();
            return result;
        }

        @Generated
        public String toString() {
            return "RuntimeItemMapping.LegacyEntry(legacyId=" + this.getLegacyId() + ", hasDamage=" + this.isHasDamage() + ", damage=" + this.getDamage() + ")";
        }
    }
}

