/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockWater;
import cn.nukkit.entity.projectile.EntityThrownTrident;
import cn.nukkit.event.entity.EntityShootBowEvent;
import cn.nukkit.event.entity.ProjectileLaunchEvent;
import cn.nukkit.event.player.PlayerToggleSpinAttackEvent;
import cn.nukkit.item.ItemTool;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;

public class ItemTrident
extends ItemTool {
    public ItemTrident() {
        this((Integer)0, 1);
    }

    public ItemTrident(Integer meta) {
        this(meta, 1);
    }

    public ItemTrident(Integer meta, int count) {
        super(455, meta, count, "Trident");
    }

    @Override
    public int getMaxDurability() {
        return 251;
    }

    @Override
    public boolean isSword() {
        return true;
    }

    @Override
    public int getAttackDamage() {
        return 9;
    }

    @Override
    public boolean onClickAir(Player player, Vector3 directionVector) {
        return true;
    }

    @Override
    public boolean onRelease(Player player, int ticksUsed) {
        Enchantment riptide = this.getEnchantment(30);
        if (riptide != null) {
            PlayerToggleSpinAttackEvent playerToggleSpinAttackEvent = new PlayerToggleSpinAttackEvent(player, true);
            int riptideLevel = riptide.getLevel();
            if (riptideLevel < 1) {
                playerToggleSpinAttackEvent.setCancelled(true);
            } else {
                boolean inWater = false;
                for (Block block : player.getCollisionBlocks()) {
                    if (!(block instanceof BlockWater) && !block.level.isBlockWaterloggedAt(player.chunk, (int)block.x, (int)block.y, (int)block.z)) continue;
                    inWater = true;
                    break;
                }
                if (!(inWater || player.getLevel().isRaining() && player.canSeeSky())) {
                    playerToggleSpinAttackEvent.setCancelled(true);
                }
            }
            player.getServer().getPluginManager().callEvent(playerToggleSpinAttackEvent);
            if (playerToggleSpinAttackEvent.isCancelled()) {
                player.setNeedSendData(true);
            } else {
                player.onSpinAttack(riptideLevel);
                player.setSpinAttack(true);
                player.resetFallDistance();
                int riptideSound = riptideLevel >= 3 ? 182 : (riptideLevel == 2 ? 181 : 180);
                player.getLevel().addLevelSoundEvent(player, riptideSound);
            }
            return true;
        }
        this.useOn(player);
        CompoundTag nbt = new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", player.x)).add(new DoubleTag("", player.y + (double)player.getEyeHeight())).add(new DoubleTag("", player.z))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", -Math.sin(player.yaw / 180.0 * Math.PI) * Math.cos(player.pitch / 180.0 * Math.PI))).add(new DoubleTag("", -Math.sin(player.pitch / 180.0 * Math.PI))).add(new DoubleTag("", Math.cos(player.yaw / 180.0 * Math.PI) * Math.cos(player.pitch / 180.0 * Math.PI)))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", (float)(player.yaw > 180.0 ? 360 : 0) - (float)player.yaw)).add(new FloatTag("", (float)(-player.pitch))));
        EntityThrownTrident trident = (EntityThrownTrident)EntityThrownTrident.createEntity(73, player.chunk, nbt, player);
        trident.setItem(this);
        if (player.isCreative()) {
            trident.setPickupMode(2);
        }
        if (this.hasEnchantment(31)) {
            trident.setFavoredSlot(player.getInventory().getHeldItemIndex());
        }
        double p = (double)ticksUsed / 20.0;
        double f = Math.min((p * p + p * 2.0) / 3.0, 1.0) * 2.5;
        EntityShootBowEvent entityShootBowEvent = new EntityShootBowEvent(player, this, trident, f);
        if (f < 0.1 || ticksUsed < 5) {
            entityShootBowEvent.setCancelled();
        }
        Server.getInstance().getPluginManager().callEvent(entityShootBowEvent);
        if (entityShootBowEvent.isCancelled()) {
            entityShootBowEvent.getProjectile().close();
        } else {
            entityShootBowEvent.getProjectile().setMotion(entityShootBowEvent.getProjectile().getMotion().multiply(entityShootBowEvent.getForce()));
            ProjectileLaunchEvent ev = new ProjectileLaunchEvent(entityShootBowEvent.getProjectile());
            Server.getInstance().getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                entityShootBowEvent.getProjectile().close();
            } else {
                entityShootBowEvent.getProjectile().spawnToAll();
                player.getLevel().addLevelSoundEvent(player, 183);
                if (!player.isCreative()) {
                    --this.count;
                    player.getInventory().setItemInHand(this);
                }
            }
        }
        return true;
    }
}

