/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemDurable;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.utils.Utils;

public abstract class ItemTool
extends Item
implements ItemDurable {
    public static final int TIER_WOODEN = 1;
    public static final int TIER_GOLD = 2;
    public static final int TIER_STONE = 3;
    public static final int TIER_IRON = 4;
    public static final int TIER_DIAMOND = 5;
    public static final int TIER_NETHERITE = 6;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_SWORD = 1;
    public static final int TYPE_SHOVEL = 2;
    public static final int TYPE_PICKAXE = 3;
    public static final int TYPE_AXE = 4;
    public static final int TYPE_SHEARS = 5;
    public static final int TYPE_HOE = 6;
    public static final int DURABILITY_WOODEN = 60;
    public static final int DURABILITY_GOLD = 33;
    public static final int DURABILITY_STONE = 132;
    public static final int DURABILITY_IRON = 251;
    public static final int DURABILITY_DIAMOND = 1562;
    public static final int DURABILITY_NETHERITE = 2032;
    public static final int DURABILITY_FLINT_STEEL = 65;
    public static final int DURABILITY_SHEARS = 239;
    public static final int DURABILITY_BOW = 385;
    public static final int DURABILITY_CROSSBOW = 465;
    public static final int DURABILITY_TRIDENT = 251;
    public static final int DURABILITY_FISHING_ROD = 385;
    public static final int DURABILITY_CARROT_ON_A_STICK = 26;
    public static final int DURABILITY_WARPED_FUNGUS_ON_A_STICK = 100;

    public ItemTool(int id) {
        this(id, 0, 1, "Unknown");
    }

    public ItemTool(int id, Integer meta) {
        this(id, meta, 1, "Unknown");
    }

    public ItemTool(int id, Integer meta, int count) {
        this(id, meta, count, "Unknown");
    }

    public ItemTool(int id, Integer meta, int count, String name) {
        super(id, meta, count, name);
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public boolean useOn(Block block) {
        if (this.noDamageOnBreak() || this.isUnbreakable() || this.isDurable()) {
            return true;
        }
        if (block.getToolType() == 3 && this.isPickaxe() || block.getToolType() == 2 && this.isShovel() || block.getToolType() == 4 && this.isAxe() || block.getToolType() == 6 && this.isHoe() || block.getToolType() == 1 && this.isSword() || block.getToolType() == 5 && this.isShears()) {
            ++this.meta;
        } else if (this.isSword() && block.getHardness() > 0.0) {
            this.meta += 2;
        } else if (this.isHoe()) {
            if (block.getId() == 2 || block.getId() == 3) {
                ++this.meta;
            }
        } else {
            ++this.meta;
        }
        return true;
    }

    @Override
    public boolean useOn(Entity entity) {
        if (this.noDamageOnAttack() || this.isUnbreakable() || this.isDurable()) {
            return true;
        }
        this.meta = entity != null && !this.isSword() ? (this.meta += 2) : ++this.meta;
        return true;
    }

    private boolean isDurable() {
        Enchantment durability = this.getEnchantment(17);
        return durability != null && durability.getLevel() > 0 && 100 / (durability.getLevel() + 1) <= Utils.random.nextInt(100);
    }

    @Override
    public boolean isTool() {
        return true;
    }

    @Override
    public int getEnchantAbility() {
        switch (this.getTier()) {
            case 3: {
                return 5;
            }
            case 1: {
                return 15;
            }
            case 5: {
                return 10;
            }
            case 2: {
                return 22;
            }
            case 4: {
                return 14;
            }
            case 6: {
                return 10;
            }
        }
        return 0;
    }

    public boolean noDamageOnAttack() {
        return false;
    }

    public boolean noDamageOnBreak() {
        return false;
    }
}

