/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockMobSpawner;
import cn.nukkit.entity.BaseEntity;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.mob.EntityZombie;
import cn.nukkit.entity.passive.EntityChicken;
import cn.nukkit.entity.passive.EntityCow;
import cn.nukkit.entity.passive.EntityPig;
import cn.nukkit.entity.passive.EntitySheep;
import cn.nukkit.event.entity.CreatureSpawnEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.Utils;
import java.util.concurrent.ThreadLocalRandom;

public class ItemSpawnEgg
extends Item {
    public ItemSpawnEgg() {
        this((Integer)0, 1);
    }

    public ItemSpawnEgg(Integer meta) {
        this(meta, 1);
    }

    public ItemSpawnEgg(Integer meta, int count) {
        super(383, meta, count, "Spawn Entity Egg");
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Level level, Player player, Block block, Block target, BlockFace face, double fx, double fy, double fz) {
        if (player.isAdventure()) {
            return false;
        }
        if (target instanceof BlockMobSpawner) {
            return false;
        }
        BaseFullChunk chunk = level.getChunk((int)block.getX() >> 4, (int)block.getZ() >> 4);
        if (chunk == null) {
            return false;
        }
        CompoundTag nbt = new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", block.getX() + 0.5)).add(new DoubleTag("", target.getBoundingBox() == null ? block.getY() : target.getBoundingBox().getMaxY() + (double)1.0E-4f)).add(new DoubleTag("", block.getZ() + 0.5))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", ThreadLocalRandom.current().nextFloat() * 360.0f)).add(new FloatTag("", 0.0f)));
        if (this.hasCustomName()) {
            nbt.putString("CustomName", this.getCustomName());
        }
        CreatureSpawnEvent ev = new CreatureSpawnEvent(this.meta, block, nbt, CreatureSpawnEvent.SpawnReason.SPAWN_EGG);
        level.getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        Entity entity = Entity.createEntity(this.meta, (FullChunk)chunk, nbt, new Object[0]);
        if (entity != null) {
            if (!player.isCreative()) {
                --this.count;
            }
            entity.spawnToAll();
            if (Utils.rand(1, 20) == 1 && (entity instanceof EntityCow || entity instanceof EntityChicken || entity instanceof EntityPig || entity instanceof EntitySheep || entity instanceof EntityZombie)) {
                ((BaseEntity)entity).setBaby(true);
            }
            return true;
        }
        return false;
    }
}

