/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFire;
import cn.nukkit.block.BlockLeaves;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.event.block.BlockIgniteEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.level.Sound;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.Utils;

public class ItemFireCharge
extends Item {
    public ItemFireCharge() {
        this((Integer)0, 1);
    }

    public ItemFireCharge(Integer meta) {
        this(meta, 1);
    }

    public ItemFireCharge(Integer meta, int count) {
        super(385, 0, count, "Fire Charge");
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Level level, Player player, Block block, Block target, BlockFace face, double fx, double fy, double fz) {
        if (player.isAdventure()) {
            return false;
        }
        if (block.getId() == 0 && (target instanceof BlockSolid || target instanceof BlockSolidMeta || target instanceof BlockLeaves)) {
            if (target.getId() == 49 && level.createPortal(target)) {
                level.addSound(target, Sound.MOB_GHAST_FIREBALL);
                return true;
            }
            int did = block.down().getId();
            BlockFire fire = (BlockFire)Block.get(did == 88 || did == 491 ? 492 : 51);
            fire.x = block.x;
            fire.y = block.y;
            fire.z = block.z;
            fire.level = level;
            if (fire.isBlockTopFacingSurfaceSolid(fire.down()) || fire.canNeighborBurn()) {
                BlockIgniteEvent e = new BlockIgniteEvent(block, null, player, BlockIgniteEvent.BlockIgniteCause.FIREBALL);
                block.getLevel().getServer().getPluginManager().callEvent(e);
                if (!e.isCancelled()) {
                    level.setBlock(fire, fire, true);
                    level.scheduleUpdate(fire, fire.tickRate() + Utils.random.nextInt(10));
                    level.addSound(block, Sound.MOB_GHAST_FIREBALL);
                    if (!player.isCreative()) {
                        --this.count;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

