/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockBedrock;
import cn.nukkit.block.BlockObsidian;
import cn.nukkit.entity.Entity;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import java.util.concurrent.ThreadLocalRandom;

public class ItemEndCrystal
extends Item {
    public ItemEndCrystal() {
        this((Integer)0, 1);
    }

    public ItemEndCrystal(Integer meta) {
        this(meta, 1);
    }

    public ItemEndCrystal(Integer meta, int count) {
        super(426, meta, count, "End Crystal");
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Level level, Player player, Block block, Block target, BlockFace face, double fx, double fy, double fz) {
        Entity entity;
        if (!(target instanceof BlockBedrock) && !(target instanceof BlockObsidian)) {
            return false;
        }
        BaseFullChunk chunk = level.getChunk((int)block.getX() >> 4, (int)block.getZ() >> 4);
        if (chunk == null) {
            return false;
        }
        int tx = (int)target.x;
        int ty = (int)target.y;
        int tz = (int)target.z;
        if (level.getBlockIdAt(chunk, tx, ty + 1, tz) != 0 || level.getBlockIdAt(chunk, tx, ty + 2, tz) != 0) {
            return false;
        }
        Entity[] entities = level.getCollidingEntities(new SimpleAxisAlignedBB(target.x, target.y, target.z, target.x + 1.0, target.y + 2.0, target.z + 1.0));
        if (entities.length != 0) {
            return false;
        }
        CompoundTag nbt = new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", target.x + 0.5)).add(new DoubleTag("", ty + 1)).add(new DoubleTag("", target.z + 0.5))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", ThreadLocalRandom.current().nextFloat() * 360.0f)).add(new FloatTag("", 0.0f)));
        if (this.hasCustomName()) {
            nbt.putString("CustomName", this.getCustomName());
        }
        if ((entity = Entity.createEntity("EndCrystal", (FullChunk)chunk, nbt, new Object[0])) != null) {
            if (!player.isCreative()) {
                --this.count;
            }
            entity.spawnToAll();
            return true;
        }
        return false;
    }
}

