/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.projectile.EntityArrow;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.event.entity.EntityShootBowEvent;
import cn.nukkit.event.entity.ProjectileLaunchEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBow;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.Utils;

public class ItemCrossbow
extends ItemBow {
    public ItemCrossbow() {
        this((Integer)0, 1);
    }

    public ItemCrossbow(Integer meta) {
        this(meta, 1);
    }

    public ItemCrossbow(Integer meta, int count) {
        super(471, meta, count, "Crossbow");
    }

    @Override
    public int getMaxDurability() {
        return 465;
    }

    @Override
    public boolean onUse(Player player, int ticksUsed) {
        int needTickUsed = 25;
        Enchantment enchantment = this.getEnchantment(35);
        if (enchantment != null) {
            needTickUsed -= enchantment.getLevel() * 5;
        }
        if (ticksUsed < needTickUsed) {
            return true;
        }
        Item itemArrow = null;
        boolean offhand = false;
        Item offhandItem = player.getOffhandInventory().getItemFast(0);
        if (offhandItem.getId() == 262) {
            itemArrow = offhandItem.clone();
            itemArrow.setCount(1);
            offhand = true;
        } else {
            for (Item i : player.getInventory().getContents().values()) {
                if (i.getId() != 262) continue;
                itemArrow = i.clone();
                itemArrow.setCount(1);
                break;
            }
        }
        if (itemArrow == null) {
            if (player.isCreative()) {
                itemArrow = Item.get(262, (Integer)0, 1);
            } else {
                return true;
            }
        }
        if (!this.isLoaded()) {
            if (!player.isCreative()) {
                Enchantment durability;
                if (!(this.isUnbreakable() || (durability = this.getEnchantment(17)) != null && durability.getLevel() > 0 && 100 / (durability.getLevel() + 1) <= Utils.random.nextInt(100))) {
                    this.setDamage(this.getDamage() + 2);
                    if (this.getDamage() >= 465) {
                        --this.count;
                    }
                }
                if (offhand) {
                    player.getOffhandInventory().removeItem(itemArrow);
                } else {
                    player.getInventory().removeItem(itemArrow);
                }
            }
            player.getInventory().setItemInHand(this.loadArrow(itemArrow));
            player.getLevel().addLevelSoundEvent(player, 247);
        }
        return true;
    }

    @Override
    public boolean onClickAir(Player player, Vector3 directionVector) {
        return false;
    }

    @Override
    public boolean onRelease(Player player, int ticksUsed) {
        return true;
    }

    public Item loadArrow(Item arrow) {
        if (arrow == null) {
            throw new IllegalArgumentException("null cannot be loaded into a crossbow!");
        }
        if (arrow.getId() != 262) {
            throw new IllegalArgumentException(arrow + " cannot be loaded into a crossbow!");
        }
        if (arrow.getCount() != 1) {
            throw new IllegalArgumentException("Only one arrow per crossbow is supported!");
        }
        CompoundTag tag = this.getNamedTag() == null ? new CompoundTag() : this.getNamedTag();
        CompoundTag chargedItem = new CompoundTag("chargedItem").putByte("Count", arrow.getCount()).putShort("Damage", arrow.getDamage()).putString("Name", "minecraft:arrow");
        tag.putBoolean("Charged", true).putCompound("chargedItem", chargedItem);
        this.setCompoundTag(tag);
        return this;
    }

    public boolean isLoaded() {
        Tag itemInfo = this.getNamedTagEntry("chargedItem");
        if (itemInfo != null) {
            CompoundTag tag = (CompoundTag)itemInfo;
            return tag.getByte("Count") > 0 && !tag.getString("Name").isEmpty();
        }
        return false;
    }

    public boolean launchArrow(Player player) {
        CompoundTag chargedItem = (CompoundTag)this.getNamedTagEntry("chargedItem");
        if (chargedItem == null) {
            throw new IllegalArgumentException("A crossbow without charged item cannot be launched!");
        }
        int arrowData = chargedItem.getShort("Damage");
        CompoundTag nbt = new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", player.x)).add(new DoubleTag("", player.y + (double)player.getEyeHeight())).add(new DoubleTag("", player.z))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", -Math.sin(player.yaw / 180.0 * Math.PI) * Math.cos(player.pitch / 180.0 * Math.PI))).add(new DoubleTag("", -Math.sin(player.pitch / 180.0 * Math.PI))).add(new DoubleTag("", Math.cos(player.yaw / 180.0 * Math.PI) * Math.cos(player.pitch / 180.0 * Math.PI)))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", (float)(player.yaw > 180.0 ? 360 : 0) - (float)player.yaw)).add(new FloatTag("", (float)(-player.pitch))));
        EntityArrow arrow = (EntityArrow)Entity.createEntity(80, player.chunk, nbt, player, false, true);
        if (arrowData > 0) {
            arrow.setData(arrowData);
        }
        if (this.hasEnchantment(34)) {
            arrow.piercing = 1;
        }
        EntityShootBowEvent entityShootBowEvent = new EntityShootBowEvent(player, this, arrow, 3.5);
        Server.getInstance().getPluginManager().callEvent(entityShootBowEvent);
        if (entityShootBowEvent.isCancelled()) {
            entityShootBowEvent.getProjectile().close();
            return false;
        }
        entityShootBowEvent.getProjectile().setMotion(entityShootBowEvent.getProjectile().getMotion().multiply(entityShootBowEvent.getForce()));
        if (entityShootBowEvent.getProjectile() != null) {
            EntityProjectile proj = entityShootBowEvent.getProjectile();
            ProjectileLaunchEvent projectev = new ProjectileLaunchEvent(proj);
            Server.getInstance().getPluginManager().callEvent(projectev);
            if (projectev.isCancelled()) {
                proj.close();
                return false;
            }
            proj.spawnToAll();
            if (this.hasEnchantment(33)) {
                CompoundTag nbt1 = new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", player.x)).add(new DoubleTag("", player.y + (double)player.getEyeHeight())).add(new DoubleTag("", player.z))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", -Math.sin(player.yaw / 180.0 * Math.PI) * Math.cos(player.pitch / 180.0 * Math.PI))).add(new DoubleTag("", -Math.sin(player.pitch / 180.0 * Math.PI))).add(new DoubleTag("", Math.cos(player.yaw / 180.0 * Math.PI) * Math.cos(player.pitch / 180.0 * Math.PI)))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", (float)(player.yaw > 180.0 ? 360 : 0) - (float)player.yaw - 10.0f)).add(new FloatTag("", (float)(-player.pitch))));
                EntityArrow arrow1 = (EntityArrow)Entity.createEntity(80, player.chunk, nbt1, player, false, true);
                arrow1.setPickupMode(-1);
                if (arrowData > 0) {
                    arrow1.setData(arrowData);
                }
                if (this.hasEnchantment(34)) {
                    arrow1.piercing = 1;
                }
                arrow1.setMotion(arrow1.getMotion().multiply(entityShootBowEvent.getForce()).add(-0.3, 0.0, 0.3));
                arrow1.spawnToAll();
                CompoundTag nbt2 = new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", player.x)).add(new DoubleTag("", player.y + (double)player.getEyeHeight())).add(new DoubleTag("", player.z))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", -Math.sin(player.yaw / 180.0 * Math.PI) * Math.cos(player.pitch / 180.0 * Math.PI))).add(new DoubleTag("", -Math.sin(player.pitch / 180.0 * Math.PI))).add(new DoubleTag("", Math.cos(player.yaw / 180.0 * Math.PI) * Math.cos(player.pitch / 180.0 * Math.PI)))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", (float)(player.yaw > 180.0 ? 360 : 0) - (float)player.yaw + 10.0f)).add(new FloatTag("", (float)(-player.pitch))));
                EntityArrow arrow2 = (EntityArrow)Entity.createEntity(80, player.chunk, nbt2, player, false, true);
                arrow2.setPickupMode(-1);
                if (arrowData > 0) {
                    arrow2.setData(arrowData);
                }
                if (this.hasEnchantment(34)) {
                    arrow2.piercing = 1;
                }
                arrow2.setMotion(arrow2.getMotion().multiply(entityShootBowEvent.getForce()).add(0.3, 0.0, -0.3));
                arrow2.spawnToAll();
            }
            player.getLevel().addLevelSoundEvent(player, 248);
            this.setCompoundTag(this.getNamedTag().putBoolean("Charged", false).remove("chargedItem"));
            player.getInventory().setItemInHand(this);
        }
        return true;
    }

    @Override
    public int getEnchantAbility() {
        return 1;
    }
}

