/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockLava;
import cn.nukkit.block.BlockLayer;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockPowderSnow;
import cn.nukkit.block.BlockTrapdoor;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.entity.EntityPotionEffectEvent;
import cn.nukkit.event.player.PlayerBucketEmptyEvent;
import cn.nukkit.event.player.PlayerBucketFillEvent;
import cn.nukkit.event.player.PlayerItemConsumeEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.anvil.Anvil;
import cn.nukkit.level.particle.ExplodeParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;

public class ItemBucket
extends Item {
    public ItemBucket() {
        this((Integer)0, 1);
    }

    public ItemBucket(Integer meta) {
        this(meta, 1);
    }

    public ItemBucket(Integer meta, int count) {
        super(325, meta, count, ItemBucket.getName(meta));
    }

    protected static String getName(int meta) {
        switch (meta) {
            case 1: {
                return "Milk";
            }
            case 2: {
                return "Bucket of Cod";
            }
            case 3: {
                return "Bucket of Salmon";
            }
            case 4: {
                return "Bucket of Tropical Fish";
            }
            case 5: {
                return "Bucket of Pufferfish";
            }
            case 8: {
                return "Water Bucket";
            }
            case 10: {
                return "Lava Bucket";
            }
            case 11: {
                return "Powder Snow Bucket";
            }
            case 12: {
                return "Bucket of Axolotl";
            }
            case 13: {
                return "Bucket of Tadpoles";
            }
        }
        return "Bucket";
    }

    public static int getDamageByTarget(int target) {
        switch (target) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                return 8;
            }
            case 10: 
            case 11: {
                return 10;
            }
        }
        return 0;
    }

    public static int getBlockByDamage(int target) {
        switch (target) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                return 8;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 561;
            }
        }
        return 0;
    }

    @Override
    public int getMaxStackSize() {
        return this.meta == 0 ? 16 : 1;
    }

    @Override
    public boolean canBeActivated() {
        return this.getDamage() != 1;
    }

    @Override
    public boolean onActivate(Level level, Player player, Block block, Block target, BlockFace face, double fx, double fy, double fz) {
        if (player.isAdventure()) {
            return false;
        }
        if (target instanceof BlockPowderSnow && this.getDamage() == 0) {
            PlayerBucketFillEvent ev = new PlayerBucketFillEvent(player, block, face, this, Item.get(325, (Integer)11, 1));
            player.getServer().getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                player.getLevel().setBlock(target, BlockLayer.NORMAL, Block.get(0), true, true);
                if (!player.isCreative()) {
                    if (this.getCount() - 1 <= 0) {
                        player.getInventory().setItemInHand(ev.getItem());
                    } else {
                        player.getInventory().setItemInHand(this.decrement(1));
                        if (player.getInventory().canAddItem(ev.getItem())) {
                            player.getInventory().addItem(ev.getItem());
                        } else {
                            player.dropItem(ev.getItem());
                        }
                    }
                }
                level.addLevelSoundEvent(block, 330);
                return true;
            }
            player.setNeedSendInventory(true);
        } else {
            Block targetBlock = Block.get(ItemBucket.getBlockByDamage(this.meta));
            if (targetBlock instanceof BlockAir) {
                if (!(target instanceof BlockLiquid) || target.getDamage() != 0) {
                    target = target.getLevelBlock(BlockLayer.WATERLOGGED);
                }
                if (!(target instanceof BlockLiquid) || target.getDamage() != 0) {
                    target = block;
                }
                if (!(target instanceof BlockLiquid) || target.getDamage() != 0) {
                    target = block.getLevelBlock(BlockLayer.WATERLOGGED);
                }
                if (target instanceof BlockLiquid && target.getDamage() == 0) {
                    Item result = Item.get(325, (Integer)ItemBucket.getDamageByTarget(target.getId()), 1);
                    PlayerBucketFillEvent ev = new PlayerBucketFillEvent(player, block, face, this, result);
                    player.getServer().getPluginManager().callEvent(ev);
                    if (!ev.isCancelled()) {
                        player.getLevel().setBlock(target, target.getLayer(), Block.get(0), true, true);
                        for (BlockFace side : BlockFace.Plane.HORIZONTAL) {
                            Block b = target.getSide(Block.LAYER_NORMAL, side);
                            if (b.getId() != 9) continue;
                            level.setBlock(b, Block.get(8));
                        }
                        if (!player.isCreative()) {
                            if (this.getCount() - 1 <= 0) {
                                player.getInventory().setItemInHand(ev.getItem());
                            } else {
                                player.getInventory().setItemInHand(this.decrement(1));
                                if (player.getInventory().canAddItem(ev.getItem())) {
                                    player.getInventory().addItem(ev.getItem());
                                } else {
                                    player.dropItem(ev.getItem());
                                }
                            }
                        }
                        if (target instanceof BlockLava) {
                            level.addLevelSoundEvent(block, 91);
                        } else {
                            level.addLevelSoundEvent(block, 90);
                        }
                        return true;
                    }
                    player.setNeedSendInventory(true);
                }
            } else if (targetBlock instanceof BlockLiquid) {
                boolean canBeFlowedInto;
                Item result = Item.get(325, (Integer)0, 1);
                boolean usesWaterlogging = ((BlockLiquid)targetBlock).usesWaterLogging();
                Block placementBlock = usesWaterlogging ? (block.getId() == 418 ? block : (target.getWaterloggingType() != Block.WaterloggingType.NO_WATERLOGGING ? target.getLevelBlock(BlockLayer.WATERLOGGED) : (block.getWaterloggingType() != Block.WaterloggingType.NO_WATERLOGGING ? block.getLevelBlock(BlockLayer.WATERLOGGED) : block))) : block;
                PlayerBucketEmptyEvent ev = new PlayerBucketEmptyEvent(player, block, face, this, result, true);
                boolean bl = canBeFlowedInto = placementBlock.canBeFlowedInto() || placementBlock.getId() == 418;
                if (usesWaterlogging) {
                    ev.setCancelled(placementBlock.getWaterloggingType() == Block.WaterloggingType.NO_WATERLOGGING && !canBeFlowedInto);
                } else {
                    ev.setCancelled(!canBeFlowedInto);
                }
                if (!block.canBeFlowedInto() && !(block instanceof BlockTrapdoor)) {
                    ev.setCancelled(true);
                }
                boolean nether = false;
                if (player.getLevel().getDimension() == 1 && this.getDamage() != 10) {
                    ev.setCancelled(true);
                    nether = true;
                }
                player.getServer().getPluginManager().callEvent(ev);
                if (!ev.isCancelled()) {
                    player.getLevel().setBlock(placementBlock, placementBlock.getLayer(), targetBlock, true, true);
                    if (!player.isCreative()) {
                        if (this.getCount() - 1 <= 0) {
                            player.getInventory().setItemInHand(ev.getItem());
                        } else {
                            player.getInventory().setItemInHand(this.decrement(1));
                            if (player.getInventory().canAddItem(ev.getItem())) {
                                player.getInventory().addItem(ev.getItem());
                            } else {
                                player.dropItem(ev.getItem());
                            }
                        }
                    }
                    if (this.getDamage() == 10) {
                        level.addLevelSoundEvent(block, 93);
                    } else {
                        level.addLevelSoundEvent(block, 92);
                    }
                    if (ev.isMobSpawningAllowed()) {
                        switch (this.getDamage()) {
                            case 2: {
                                Entity e2 = Entity.createEntity("Cod", block.add(0.5, 0.0, 0.5), new Object[0]);
                                if (e2 == null) break;
                                e2.spawnToAll();
                                break;
                            }
                            case 3: {
                                Entity e3 = Entity.createEntity("Salmon", block.add(0.5, 0.0, 0.5), new Object[0]);
                                if (e3 == null) break;
                                e3.spawnToAll();
                                break;
                            }
                            case 4: {
                                Entity e4 = Entity.createEntity("TropicalFish", block.add(0.5, 0.0, 0.5), new Object[0]);
                                if (e4 == null) break;
                                e4.spawnToAll();
                                break;
                            }
                            case 5: {
                                Entity e5 = Entity.createEntity("Pufferfish", block.add(0.5, 0.0, 0.5), new Object[0]);
                                if (e5 == null) break;
                                e5.spawnToAll();
                                break;
                            }
                            case 12: {
                                Entity e12 = Entity.createEntity("Axolotl", block.add(0.5, 0.0, 0.5), new Object[0]);
                                if (e12 == null) break;
                                e12.spawnToAll();
                                break;
                            }
                            case 13: {
                                Entity e13 = Entity.createEntity("Tadpole", block.add(0.5, 0.0, 0.5), new Object[0]);
                                if (e13 == null) break;
                                e13.spawnToAll();
                            }
                        }
                    }
                    return true;
                }
                if (nether) {
                    if (!player.isCreative()) {
                        this.setDamage(0);
                        player.getInventory().setItemInHand(this);
                    }
                    player.getLevel().addLevelSoundEvent(target, 27);
                    player.getLevel().addParticle(new ExplodeParticle(target.add(0.5, 1.0, 0.5)));
                } else {
                    player.getLevel().sendBlocks(new Player[]{player}, (Vector3[])new Block[]{block.getLevelBlock(Block.LAYER_WATERLOGGED)}, 11, BlockLayer.WATERLOGGED);
                    player.setNeedSendInventory(true);
                }
            } else if (targetBlock instanceof BlockPowderSnow) {
                if (player.getLevel().getProvider() instanceof Anvil || !block.canBeReplaced()) {
                    return false;
                }
                PlayerBucketEmptyEvent ev = new PlayerBucketEmptyEvent(player, block, face, this, Item.get(325, (Integer)0, 1), true);
                player.getServer().getPluginManager().callEvent(ev);
                if (!ev.isCancelled()) {
                    player.getLevel().setBlock(block, BlockLayer.NORMAL, targetBlock, true, true);
                    if (!player.isCreative()) {
                        if (this.getCount() - 1 <= 0) {
                            player.getInventory().setItemInHand(ev.getItem());
                        } else {
                            player.getInventory().setItemInHand(this.decrement(1));
                            if (player.getInventory().canAddItem(ev.getItem())) {
                                player.getInventory().addItem(ev.getItem());
                            } else {
                                player.dropItem(ev.getItem());
                            }
                        }
                    }
                    level.addLevelSoundEvent(block, 331);
                    return true;
                }
                player.setNeedSendInventory(true);
            }
        }
        return false;
    }

    @Override
    public boolean onClickAir(Player player, Vector3 directionVector) {
        return this.getDamage() == 1;
    }

    @Override
    public boolean onUse(Player player, int ticksUsed) {
        if (player.isSpectator() || this.getDamage() != 1) {
            return false;
        }
        PlayerItemConsumeEvent consumeEvent = new PlayerItemConsumeEvent(player, this);
        player.getServer().getPluginManager().callEvent(consumeEvent);
        if (consumeEvent.isCancelled()) {
            player.setNeedSendInventory(true);
            return false;
        }
        if (!player.isCreative()) {
            player.getInventory().setItemInHand(Item.get(325));
        }
        player.removeAllEffects(EntityPotionEffectEvent.Cause.MILK);
        return true;
    }
}

