/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.projectile.EntityArrow;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.event.entity.EntityShootBowEvent;
import cn.nukkit.event.entity.ProjectileLaunchEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemTool;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.Utils;

public class ItemBow
extends ItemTool {
    public ItemBow() {
        this((Integer)0, 1);
    }

    public ItemBow(Integer meta) {
        this(meta, 1);
    }

    public ItemBow(Integer meta, int count) {
        this(261, meta, count, "Bow");
    }

    public ItemBow(int id, Integer meta, int count, String name) {
        super(id, meta, count, name);
    }

    @Override
    public int getMaxDurability() {
        return 385;
    }

    @Override
    public int getEnchantAbility() {
        return 1;
    }

    @Override
    public boolean onClickAir(Player player, Vector3 directionVector) {
        return this.playerHasArrow(player) || player.isCreative();
    }

    private boolean playerHasArrow(Player p) {
        if (p.getOffhandInventory().getItemFast(0).getId() == 262) {
            return true;
        }
        for (Item i : p.getInventory().getContents().values()) {
            if (i.getId() != 262) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onRelease(Player player, int ticksUsed) {
        EntityProjectile projectile;
        boolean infinity;
        Enchantment flameEnchant;
        Item itemArrow = null;
        boolean offhand = false;
        if (player.getOffhandInventory().getItemFast(0).getId() == 262) {
            itemArrow = player.getOffhandInventory().getItemFast(0).clone();
            itemArrow.setCount(1);
            offhand = true;
        } else {
            for (Item i : player.getInventory().getContents().values()) {
                if (i.getId() != 262) continue;
                itemArrow = i.clone();
                itemArrow.setCount(1);
                break;
            }
        }
        if (itemArrow == null) {
            if (player.isCreative()) {
                itemArrow = Item.get(262, (Integer)0, 1);
            } else {
                return false;
            }
        }
        double damage = 2.0;
        Enchantment bowDamage = this.getEnchantment(19);
        if (bowDamage != null && bowDamage.getLevel() > 0) {
            damage += (double)bowDamage.getLevel() * 0.5 + 0.5;
        }
        boolean flame = (flameEnchant = this.getEnchantment(21)) != null && flameEnchant.getLevel() > 0;
        float knockBack = 0.3f;
        Enchantment knockBackEnchantment = this.getEnchantment(20);
        if (knockBackEnchantment != null) {
            knockBack += (float)knockBackEnchantment.getLevel() * 0.1f;
        }
        CompoundTag nbt = new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", player.x)).add(new DoubleTag("", player.y + (double)player.getEyeHeight())).add(new DoubleTag("", player.z))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", -Math.sin(player.yaw / 180.0 * Math.PI) * Math.cos(player.pitch / 180.0 * Math.PI))).add(new DoubleTag("", -Math.sin(player.pitch / 180.0 * Math.PI))).add(new DoubleTag("", Math.cos(player.yaw / 180.0 * Math.PI) * Math.cos(player.pitch / 180.0 * Math.PI)))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", (float)(player.yaw > 180.0 ? 360 : 0) - (float)player.yaw)).add(new FloatTag("", (float)(-player.pitch)))).putShort("Fire", flame ? 2700 : 0).putDouble("damage", damage).putFloat("knockback", knockBack);
        double p = (double)ticksUsed / 20.0;
        double f = Math.min((p * p + p * 2.0) / 3.0, 1.0) * 2.8;
        EntityArrow arrow = (EntityArrow)Entity.createEntity(80, player.chunk, nbt, player, f > 2.3, false);
        if (itemArrow.getDamage() > 0) {
            arrow.setData(itemArrow.getDamage());
        }
        EntityShootBowEvent entityShootBowEvent = new EntityShootBowEvent(player, this, arrow, f);
        if (f < 0.1 || ticksUsed < 3) {
            entityShootBowEvent.setCancelled();
        }
        Server.getInstance().getPluginManager().callEvent(entityShootBowEvent);
        if (entityShootBowEvent.isCancelled()) {
            entityShootBowEvent.getProjectile().close();
            return false;
        }
        entityShootBowEvent.getProjectile().setMotion(entityShootBowEvent.getProjectile().getMotion().multiply(entityShootBowEvent.getForce()));
        Enchantment infinityEnchant = this.getEnchantment(22);
        boolean bl = infinity = infinityEnchant != null && infinityEnchant.getLevel() > 0;
        if (infinity && itemArrow.getDamage() == 0 && (projectile = entityShootBowEvent.getProjectile()) instanceof EntityArrow) {
            ((EntityArrow)projectile).setPickupMode(2);
        }
        if (!player.isCreative()) {
            Enchantment durability;
            if (!infinity || itemArrow.getDamage() != 0) {
                if (offhand) {
                    player.getOffhandInventory().removeItem(itemArrow);
                } else {
                    player.getInventory().removeItem(itemArrow);
                }
            }
            if (!(this.isUnbreakable() || (durability = this.getEnchantment(17)) != null && durability.getLevel() > 0 && 100 / (durability.getLevel() + 1) <= Utils.random.nextInt(100))) {
                this.setDamage(this.getDamage() + 2);
                if (this.getDamage() >= this.getMaxDurability()) {
                    --this.count;
                }
                player.getInventory().setItemInHand(this);
            }
        }
        if (entityShootBowEvent.getProjectile() != null) {
            EntityProjectile proj = entityShootBowEvent.getProjectile();
            ProjectileLaunchEvent projectev = new ProjectileLaunchEvent(proj);
            Server.getInstance().getPluginManager().callEvent(projectev);
            if (projectev.isCancelled()) {
                proj.close();
            } else {
                proj.spawnToAll();
                player.getLevel().addLevelSoundEvent(player, 21);
            }
        }
        return true;
    }
}

