/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBookWritable;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;

public class ItemBookWritten
extends ItemBookWritable {
    public static final int GENERATION_ORIGINAL = 0;
    public static final int GENERATION_COPY = 1;
    public static final int GENERATION_COPY_OF_COPY = 2;
    public static final int GENERATION_TATTERED = 3;

    public ItemBookWritten() {
        this((Integer)0, 1);
    }

    public ItemBookWritten(Integer meta) {
        this(meta, 1);
    }

    public ItemBookWritten(Integer meta, int count) {
        super(387, 0, count, "Written Book");
    }

    @Override
    public int getMaxStackSize() {
        return 16;
    }

    public Item writeBook(String author, String title, String[] pages) {
        ListTag<CompoundTag> pageList = new ListTag<CompoundTag>("pages");
        for (String page : pages) {
            pageList.add(ItemBookWritten.createPageTag(page));
        }
        return this.writeBook(author, title, pageList);
    }

    public Item writeBook(String author, String title, ListTag<CompoundTag> pages) {
        if (pages.size() > 50 || pages.size() <= 0) {
            return this;
        }
        CompoundTag tag = this.hasCompoundTag() ? this.getNamedTag() : new CompoundTag();
        tag.putString("author", author);
        tag.putString("title", title);
        tag.putList(pages);
        tag.putInt("generation", 0);
        tag.putString("xuid", "");
        return this.setNamedTag(tag);
    }

    public boolean signBook(String title, String author, String xuid, int generation) {
        this.setNamedTag((this.hasCompoundTag() ? this.getNamedTag() : new CompoundTag()).putString("title", title).putString("author", author).putInt("generation", generation).putString("xuid", xuid));
        return true;
    }

    public int getGeneration() {
        return this.hasCompoundTag() ? this.getNamedTag().getInt("generation") : -1;
    }

    public void setGeneration(int generation) {
        this.setNamedTag((this.hasCompoundTag() ? this.getNamedTag() : new CompoundTag()).putInt("generation", generation));
    }

    public String getAuthor() {
        return this.hasCompoundTag() ? this.getNamedTag().getString("author") : "";
    }

    public void setAuthor(String author) {
        this.setNamedTag((this.hasCompoundTag() ? this.getNamedTag() : new CompoundTag()).putString("author", author));
    }

    public String getTitle() {
        return this.hasCompoundTag() ? this.getNamedTag().getString("title") : "Written Book";
    }

    public void setTitle(String title) {
        this.setNamedTag((this.hasCompoundTag() ? this.getNamedTag() : new CompoundTag()).putString("title", title));
    }

    public String getXUID() {
        return this.hasCompoundTag() ? this.getNamedTag().getString("xuid") : "";
    }

    public void setXUID(String title) {
        this.setNamedTag((this.hasCompoundTag() ? this.getNamedTag() : new CompoundTag()).putString("xuid", title));
    }
}

