/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.item.Item;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import com.google.common.base.Preconditions;
import java.util.List;

public abstract class ItemBookWritable
extends Item {
    protected ItemBookWritable(int id) {
        super(id);
    }

    protected ItemBookWritable(int id, Integer meta) {
        super(id, meta);
    }

    protected ItemBookWritable(int id, Integer meta, int count) {
        super(id, meta, count);
    }

    protected ItemBookWritable(int id, Integer meta, int count, String name) {
        super(id, meta, count, name);
    }

    public boolean pageExists(int pageId) {
        CompoundTag tag;
        Preconditions.checkArgument(pageId >= 0 && pageId < 50, "Page number " + pageId + " is out of range");
        if (this.hasCompoundTag() && (tag = this.getNamedTag()).contains("pages") && tag.get("pages") instanceof ListTag) {
            return tag.getList("pages", CompoundTag.class).size() > pageId;
        }
        return false;
    }

    public String getPageText(int pageId) {
        ListTag<CompoundTag> pages;
        CompoundTag tag;
        Preconditions.checkArgument(pageId >= 0 && pageId < 50, "Page number " + pageId + " is out of range");
        if (this.hasCompoundTag() && (tag = this.getNamedTag()).contains("pages") && tag.get("pages") instanceof ListTag && (pages = tag.getList("pages", CompoundTag.class)).size() > pageId) {
            return pages.get(pageId).getString("text");
        }
        return null;
    }

    public boolean setPageText(int pageId, String pageText) {
        ListTag<Object> pages;
        CompoundTag tag;
        Preconditions.checkArgument(pageId >= 0 && pageId < 50, "Page number " + pageId + " is out of range");
        if (this.hasCompoundTag()) {
            tag = this.getNamedTag();
        } else {
            if (pageText.isEmpty()) {
                return false;
            }
            tag = new CompoundTag();
        }
        if (!tag.contains("pages") || !(tag.get("pages") instanceof ListTag)) {
            pages = new ListTag("pages");
            tag.putList(pages);
        } else {
            pages = tag.getList("pages", CompoundTag.class);
        }
        if (pages.size() <= pageId) {
            for (int current = pages.size(); current <= pageId; ++current) {
                pages.add(ItemBookWritable.createPageTag());
            }
        }
        ((CompoundTag)pages.get(pageId)).putString("text", pageText);
        this.setCompoundTag(tag);
        return true;
    }

    public boolean addPage(int pageId) {
        ListTag<Object> pages;
        CompoundTag tag;
        Preconditions.checkArgument(pageId >= 0 && pageId < 50, "Page number " + pageId + " is out of range");
        CompoundTag compoundTag = tag = this.hasCompoundTag() ? this.getNamedTag() : new CompoundTag();
        if (!tag.contains("pages") || !(tag.get("pages") instanceof ListTag)) {
            pages = new ListTag("pages");
            tag.putList(pages);
        } else {
            pages = tag.getList("pages", CompoundTag.class);
        }
        for (int current = pages.size(); current <= pageId; ++current) {
            pages.add(ItemBookWritable.createPageTag());
        }
        this.setCompoundTag(tag);
        return true;
    }

    public boolean deletePage(int pageId) {
        ListTag<CompoundTag> pages;
        CompoundTag tag;
        Preconditions.checkArgument(pageId >= 0 && pageId < 50, "Page number " + pageId + " is out of range");
        if (this.hasCompoundTag() && (tag = this.getNamedTag()).contains("pages") && tag.get("pages") instanceof ListTag && (pages = tag.getList("pages", CompoundTag.class)).size() > pageId) {
            pages.remove(pageId);
            this.setCompoundTag(tag);
        }
        return true;
    }

    public boolean insertPage(int pageId) {
        return this.insertPage(pageId, "");
    }

    public boolean insertPage(int pageId, String pageText) {
        ListTag<Object> pages;
        CompoundTag tag;
        Preconditions.checkArgument(pageId >= 0 && pageId < 50, "Page number " + pageId + " is out of range");
        CompoundTag compoundTag = tag = this.hasCompoundTag() ? this.getNamedTag() : new CompoundTag();
        if (!tag.contains("pages") || !(tag.get("pages") instanceof ListTag)) {
            pages = new ListTag("pages");
            tag.putList(pages);
        } else {
            pages = tag.getList("pages", CompoundTag.class);
        }
        if (pages.size() <= pageId) {
            for (int current = pages.size(); current <= pageId; ++current) {
                pages.add(ItemBookWritable.createPageTag());
            }
            ((CompoundTag)pages.get(pageId)).putString("text", pageText);
        } else {
            pages.add(pageId, ItemBookWritable.createPageTag(pageText));
        }
        this.setCompoundTag(tag);
        return true;
    }

    public boolean swapPages(int pageId1, int pageId2) {
        ListTag<CompoundTag> pages;
        CompoundTag tag;
        Preconditions.checkArgument(pageId1 >= 0 && pageId1 < 50, "Page number " + pageId1 + " is out of range");
        Preconditions.checkArgument(pageId2 >= 0 && pageId2 < 50, "Page number " + pageId2 + " is out of range");
        if (this.hasCompoundTag() && (tag = this.getNamedTag()).contains("pages") && tag.get("pages") instanceof ListTag && (pages = tag.getList("pages", CompoundTag.class)).size() > pageId1 && pages.size() > pageId2) {
            String pageContents1 = pages.get(pageId1).getString("text");
            String pageContents2 = pages.get(pageId2).getString("text");
            pages.get(pageId1).putString("text", pageContents2);
            pages.get(pageId2).putString("text", pageContents1);
            return true;
        }
        return false;
    }

    public List getPages() {
        ListTag<Object> pages;
        CompoundTag tag;
        CompoundTag compoundTag = tag = this.hasCompoundTag() ? this.getNamedTag() : new CompoundTag();
        if (!tag.contains("pages") || !(tag.get("pages") instanceof ListTag)) {
            pages = new ListTag("pages");
            tag.putList(pages);
        } else {
            pages = tag.getList("pages", CompoundTag.class);
        }
        return pages.parseValue();
    }

    protected static CompoundTag createPageTag() {
        return ItemBookWritable.createPageTag("");
    }

    protected static CompoundTag createPageTag(String pageText) {
        return new CompoundTag().putString("text", pageText).putString("photoname", "");
    }
}

