/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityArmorStand;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;

public class ItemArmorStand
extends Item {
    public ItemArmorStand() {
        this((Integer)0);
    }

    public ItemArmorStand(Integer meta) {
        this(meta, 1);
    }

    public ItemArmorStand(Integer meta, int count) {
        super(425, meta, count, "Armor Stand");
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Level level, Player player, Block block, Block target, BlockFace face, double fx, double fy, double fz) {
        BaseFullChunk chunk = level.getChunk((int)block.getX() >> 4, (int)block.getZ() >> 4);
        if (chunk == null) {
            return false;
        }
        for (Entity e : chunk.getEntities().values()) {
            if (!(e instanceof EntityArmorStand) || e.getY() != block.getY() || e.getX() != block.getX() + 0.5 || e.getZ() != block.getZ() + 0.5) continue;
            return false;
        }
        CompoundTag nbt = new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", block.getX() + 0.5)).add(new DoubleTag("", block.getY())).add(new DoubleTag("", block.getZ() + 0.5))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", ItemArmorStand.getDirection((float)player.getYaw()))).add(new FloatTag("", 0.0f)));
        if (this.hasCustomName()) {
            nbt.putString("CustomName", this.getCustomName());
        }
        Entity entity = Entity.createEntity("ArmorStand", (FullChunk)chunk, nbt, new Object[0]);
        if (!player.isCreative()) {
            --this.count;
        }
        if (entity != null) {
            entity.spawnToAll();
            player.getLevel().addLevelEvent(entity, 1063);
        }
        return true;
    }

    private static float getDirection(float yaw) {
        float rot = (float)Math.round(yaw / 22.5f / 2.0f) * 45.0f - 180.0f;
        if (rot < 0.0f) {
            rot += 360.0f;
        }
        return rot;
    }
}

