/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory.transaction.action;

import cn.nukkit.Player;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityContainer;
import cn.nukkit.blockentity.BlockEntityFurnace;
import cn.nukkit.entity.Entity;
import cn.nukkit.inventory.BrewingInventory;
import cn.nukkit.inventory.FurnaceInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.PlayerOffhandInventory;
import cn.nukkit.inventory.PlayerUIComponent;
import cn.nukkit.inventory.PlayerUIInventory;
import cn.nukkit.inventory.transaction.InventoryTransaction;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.item.Item;
import java.util.HashSet;

public class SlotChangeAction
extends InventoryAction {
    protected Inventory inventory;
    private final int inventorySlot;

    public SlotChangeAction(Inventory inventory, int inventorySlot, Item sourceItem, Item targetItem) {
        super(sourceItem, targetItem);
        this.inventory = inventory;
        this.inventorySlot = inventorySlot;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getSlot() {
        return this.inventorySlot;
    }

    @Override
    public boolean isValid(Player source) {
        if (this.inventory == null || source == null || source.closed) {
            return false;
        }
        if (!(source.isCreative() || this.inventory instanceof PlayerUIComponent || this.inventory instanceof PlayerUIInventory || this.inventory.getViewers().contains(source))) {
            source.getServer().getLogger().debug(source.getName() + ": got SlotChangeAction but player is not a viewer of " + this.inventory);
            return false;
        }
        if (this.inventory instanceof PlayerOffhandInventory && !source.isInventoryOpen()) {
            source.getServer().getLogger().debug(source.getName() + ": got SlotChangeAction but player has no visible inventory window");
            return false;
        }
        if (this.inventory.getHolder() instanceof BlockEntityContainer && !((BlockEntity)((Object)this.inventory.getHolder())).closed && (source.distanceSquared((BlockEntity)((Object)this.inventory.getHolder())) > 4096.0 || !source.getLevel().equals(((BlockEntity)((Object)this.inventory.getHolder())).getLevel()))) {
            source.getServer().getLogger().debug(source.getName() + ": got SlotChangeAction but player is too far away from the holder of " + this.inventory);
            return false;
        }
        if (this.inventory.getHolder() != source && this.inventory.getHolder() instanceof Entity && !((Entity)((Object)this.inventory.getHolder())).closed && (source.distanceSquared((Entity)((Object)this.inventory.getHolder())) > 4096.0 || !source.getLevel().equals(((Entity)((Object)this.inventory.getHolder())).getLevel()))) {
            source.getServer().getLogger().debug(source.getName() + ": got SlotChangeAction but player is too far away from the holder of " + this.inventory);
            return false;
        }
        Item check = this.inventory.getItem(this.inventorySlot);
        return check.equalsExact(this.sourceItem);
    }

    @Override
    public boolean execute(Player source) {
        return this.inventory.setItem(this.inventorySlot, this.targetItem, false);
    }

    @Override
    public void onExecuteSuccess(Player source) {
        int itemId;
        HashSet<Player> viewers = new HashSet<Player>(this.inventory.getViewers());
        viewers.remove(source);
        this.inventory.sendSlot(this.inventorySlot, viewers);
        if (this.inventory instanceof FurnaceInventory && this.inventorySlot == 2) {
            BlockEntityFurnace blockEntityFurnace = ((FurnaceInventory)this.inventory).getHolder();
            if (blockEntityFurnace != null && !blockEntityFurnace.closed) {
                blockEntityFurnace.releaseExperience();
            }
            switch (this.getSourceItemUnsafe().getId()) {
                case 265: {
                    source.awardAchievement("acquireIron");
                    break;
                }
                case 350: {
                    source.awardAchievement("cookFish");
                }
            }
        } else if (this.inventory instanceof BrewingInventory && this.inventorySlot >= 1 && this.inventorySlot <= 3 && ((itemId = this.getSourceItemUnsafe().getId()) == 373 || itemId == 438 || itemId == 441) && this.getSourceItemUnsafe().getDamage() != 0) {
            source.awardAchievement("potion");
        }
    }

    @Override
    public void onExecuteFail(Player source) {
        this.inventory.sendSlot(this.inventorySlot, source);
    }

    @Override
    public void onAddToTransaction(InventoryTransaction transaction) {
        transaction.addInventory(this.inventory);
    }
}

