/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory.transaction.action;

import cn.nukkit.Player;
import cn.nukkit.inventory.LoomInventory;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.item.Item;

public class LoomItemAction
extends InventoryAction {
    private final LoomInventory inventory;

    public LoomItemAction(Item sourceItem, Item targetItem, LoomInventory inventory) {
        super(sourceItem, targetItem);
        this.inventory = inventory;
    }

    @Override
    public boolean isValid(Player source) {
        return source.getWindowById(2) instanceof LoomInventory;
    }

    @Override
    public boolean execute(Player source) {
        return true;
    }

    @Override
    public void onExecuteSuccess(Player source) {
        Item banner = this.inventory.getBanner();
        Item dye = this.inventory.getDye();
        if (banner != null && !banner.isNull()) {
            banner.count -= this.sourceItem.getCount();
            this.inventory.setBanner(banner);
        }
        if (dye != null && !dye.isNull()) {
            dye.count -= this.sourceItem.getCount();
            this.inventory.setDye(dye);
        }
    }

    @Override
    public void onExecuteFail(Player source) {
        this.inventory.sendContents(source);
    }
}

