/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory.transaction;

import cn.nukkit.Player;
import cn.nukkit.event.inventory.SmithItemEvent;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.SmithingInventory;
import cn.nukkit.inventory.transaction.InventoryTransaction;
import cn.nukkit.inventory.transaction.action.CreativeInventoryAction;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.inventory.transaction.action.SmithingItemAction;
import cn.nukkit.item.Item;
import java.util.List;

public class SmithingTransaction
extends InventoryTransaction {
    private Item equipmentItem;
    private Item ingredientItem;
    private Item outputItem;

    public SmithingTransaction(Player source, List<InventoryAction> actions) {
        super(source, actions);
    }

    @Override
    public void addAction(InventoryAction action) {
        CreativeInventoryAction creativeAction;
        super.addAction(action);
        if (action instanceof SmithingItemAction) {
            switch (((SmithingItemAction)action).getType()) {
                case 0: {
                    this.equipmentItem = action.getTargetItem();
                    break;
                }
                case 1: {
                    this.ingredientItem = action.getTargetItem();
                    break;
                }
                case 2: {
                    this.outputItem = action.getSourceItem();
                }
            }
        } else if (action instanceof CreativeInventoryAction && (creativeAction = (CreativeInventoryAction)action).getActionType() == 0 && creativeAction.getSourceItemUnsafe().isNull() && !creativeAction.getTargetItemUnsafe().isNull() && creativeAction.getTargetItemUnsafe().getId() == 742) {
            this.ingredientItem = action.getTargetItem();
        }
    }

    @Override
    public boolean canExecute() {
        Inventory inventory = this.getSource().getWindowById(6);
        if (!(inventory instanceof SmithingInventory)) {
            return false;
        }
        SmithingInventory smithingInventory = (SmithingInventory)inventory;
        if (this.outputItem == null || this.outputItem.isNull() || (this.equipmentItem == null || this.equipmentItem.isNull()) && (this.ingredientItem == null || this.ingredientItem.isNull())) {
            return false;
        }
        Item air = Item.get(0);
        Item equipment = this.equipmentItem != null ? this.equipmentItem : air;
        Item ingredient = this.ingredientItem != null ? this.ingredientItem : air;
        return equipment.equals(smithingInventory.getEquipment(), true, true) && ingredient.equals(smithingInventory.getIngredient(), true, true) && this.outputItem.equals(smithingInventory.getResult(), true, true);
    }

    @Override
    public boolean execute() {
        if (this.hasExecuted() || !this.canExecute()) {
            this.source.removeAllWindows(false);
            this.sendInventories();
            return false;
        }
        SmithingInventory inventory = (SmithingInventory)this.getSource().getWindowById(6);
        SmithItemEvent event = new SmithItemEvent(inventory, this.equipmentItem, this.outputItem, this.ingredientItem, this.source);
        this.source.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            this.source.removeAllWindows(false);
            this.sendInventories();
            return true;
        }
        for (InventoryAction action : this.actions) {
            if (action.execute(this.source)) {
                action.onExecuteSuccess(this.source);
                continue;
            }
            action.onExecuteFail(this.source);
        }
        if (inventory != null) {
            inventory.sendContents(this.source);
        }
        return true;
    }

    public Item getInputItem() {
        return this.equipmentItem;
    }

    public Item getMaterialItem() {
        return this.ingredientItem;
    }

    public Item getOutputItem() {
        return this.outputItem;
    }

    public static boolean checkForItemPart(List<InventoryAction> actions) {
        return actions.stream().anyMatch(it -> it instanceof SmithingItemAction);
    }
}

