/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory.transaction;

import cn.nukkit.Player;
import cn.nukkit.event.inventory.LoomItemEvent;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.LoomInventory;
import cn.nukkit.inventory.transaction.InventoryTransaction;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.inventory.transaction.action.LoomItemAction;
import cn.nukkit.item.Item;
import java.util.List;

public class LoomTransaction
extends InventoryTransaction {
    private Item outputItem;

    public LoomTransaction(Player source, List<InventoryAction> actions) {
        super(source, actions);
    }

    @Override
    public void addAction(InventoryAction action) {
        super.addAction(action);
        if (action instanceof LoomItemAction) {
            this.outputItem = action.getSourceItem();
        }
    }

    @Override
    public boolean canExecute() {
        if (!super.canExecute()) {
            return false;
        }
        Inventory inventory = this.getSource().getWindowById(2);
        if (!(inventory instanceof LoomInventory)) {
            return false;
        }
        if (this.outputItem == null) {
            return false;
        }
        LoomInventory loomInventory = (LoomInventory)inventory;
        Item banner = loomInventory.getBanner();
        Item dye = loomInventory.getDye();
        if (banner.getId() != 446 || dye.getId() != 351 || banner.getDamage() != this.outputItem.getDamage()) {
            return false;
        }
        if (!this.outputItem.hasCompoundTag()) {
            return false;
        }
        int patternCount = this.outputItem.getNamedTag().getList("Patterns").size();
        if (banner.getNamedTag() == null) {
            return patternCount == 1;
        }
        if (patternCount > 6) {
            return false;
        }
        Item pattern = loomInventory.getPattern();
        if (pattern.getId() != 0 && pattern.getId() != 434) {
            return false;
        }
        return banner.getNamedTag().getList("Patterns").size() + 1 == patternCount;
    }

    @Override
    protected boolean callExecuteEvent() {
        LoomInventory inventory = (LoomInventory)this.getSource().getWindowById(2);
        LoomItemEvent event = new LoomItemEvent(inventory, this.outputItem, this.source);
        this.source.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            this.source.removeAllWindows(false);
            this.sendInventories();
            return false;
        }
        return true;
    }

    @Override
    protected void sendInventories() {
        this.source.removeAllWindows(false);
        super.sendInventories();
    }

    public Item getOutputItem() {
        return this.outputItem;
    }

    public static boolean checkForItemPart(List<InventoryAction> actions) {
        return actions.stream().anyMatch(it -> it instanceof LoomItemAction);
    }
}

