/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory.transaction;

import cn.nukkit.Player;
import cn.nukkit.event.inventory.EnchantItemEvent;
import cn.nukkit.inventory.EnchantInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.transaction.InventoryTransaction;
import cn.nukkit.inventory.transaction.action.EnchantingAction;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.inventory.transaction.action.SlotChangeAction;
import cn.nukkit.item.Item;
import java.util.List;
import lombok.Generated;

public class EnchantTransaction
extends InventoryTransaction {
    private Item inputItem;
    private Item outputItem;
    private Item outputItemCheck;
    private int cost = -1;

    public EnchantTransaction(Player source, List<InventoryAction> actions) {
        super(source, actions);
        for (InventoryAction action : actions) {
            SlotChangeAction slotChangeAction;
            if (!(action instanceof SlotChangeAction) || !((slotChangeAction = (SlotChangeAction)action).getInventory() instanceof EnchantInventory) || slotChangeAction.getSlot() != 0) continue;
            this.outputItemCheck = slotChangeAction.getTargetItem();
        }
    }

    @Override
    public boolean canExecute() {
        Inventory inv = this.getSource().getWindowById(3);
        if (!(inv instanceof EnchantInventory)) {
            return false;
        }
        EnchantInventory eInv = (EnchantInventory)inv;
        if (!this.getSource().isCreative()) {
            if (this.cost < 1) {
                return false;
            }
            Item reagent = eInv.getReagentSlot();
            if (reagent.count < this.cost || !reagent.equals(Item.get(351, (Integer)4), true, false)) {
                return false;
            }
        }
        return this.inputItem != null && this.outputItem != null && this.inputItem.equals(eInv.getInputSlot(), true, true) && (this.outputItemCheck == null || this.inputItem.getId() == this.outputItemCheck.getId() || this.inputItem.getId() == 340 && this.outputItemCheck.getId() == 403) && (this.outputItemCheck == null || this.inputItem.getCount() == this.outputItemCheck.getCount() || this.outputItemCheck.getId() == 403 && this.outputItemCheck.getCount() == 1);
    }

    @Override
    public boolean execute() {
        if (this.hasExecuted || !this.canExecute()) {
            this.source.removeAllWindows(false);
            this.sendInventories();
            return false;
        }
        EnchantInventory inv = (EnchantInventory)this.getSource().getWindowById(3);
        EnchantItemEvent ev = new EnchantItemEvent(inv, this.inputItem, this.outputItem, this.cost, this.source);
        this.source.getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            this.source.removeAllWindows(false);
            this.sendInventories();
            return true;
        }
        for (InventoryAction a : this.actions) {
            if (a.execute(this.source)) {
                a.onExecuteSuccess(this.source);
                continue;
            }
            a.onExecuteFail(this.source);
        }
        if (!ev.getNewItem().equals(this.outputItem, true, true)) {
            inv.setItem(0, ev.getNewItem(), true);
        }
        if (!this.source.isCreative()) {
            this.source.setExperience(this.source.getExperience(), this.source.getExperienceLevel() - ev.getXpCost());
        }
        return true;
    }

    @Override
    public void addAction(InventoryAction action) {
        super.addAction(action);
        if (action instanceof EnchantingAction) {
            switch (((EnchantingAction)action).getType()) {
                case -15: {
                    this.inputItem = action.getTargetItem();
                    break;
                }
                case -17: {
                    this.outputItem = action.getSourceItem();
                    break;
                }
                case -16: {
                    this.cost = action.getTargetItemUnsafe().getId() == 0 ? action.getSourceItemUnsafe().count : action.getSourceItemUnsafe().count - action.getTargetItemUnsafe().count;
                }
            }
        }
    }

    public boolean checkForEnchantPart(List<InventoryAction> actions) {
        for (InventoryAction action : actions) {
            if (!(action instanceof EnchantingAction)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public Item getInputItem() {
        return this.inputItem;
    }

    @Generated
    public Item getOutputItem() {
        return this.outputItem;
    }

    @Generated
    public Item getOutputItemCheck() {
        return this.outputItemCheck;
    }

    @Generated
    public int getCost() {
        return this.cost;
    }

    @Generated
    public void setInputItem(Item inputItem) {
        this.inputItem = inputItem;
    }

    @Generated
    public void setOutputItem(Item outputItem) {
        this.outputItem = outputItem;
    }

    @Generated
    public void setOutputItemCheck(Item outputItemCheck) {
        this.outputItemCheck = outputItemCheck;
    }

    @Generated
    public void setCost(int cost) {
        this.cost = cost;
    }
}

