/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.item.Item;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import lombok.Generated;

public class TradeInventoryRecipe {
    public static final int A_ITEM = 0;
    public static final int B_ITEM = 1;
    private final Item sellItem;
    private final Item buyItem;
    private final Item secondBuyItem;
    private int tier = -1;
    private int maxUses = 999;
    private int buyCountA = 0;
    private int buyCountB = 0;
    private final int uses = 0;
    private int demand = 0;
    private int rewardsExp = 0;
    private final int traderExp = 0;
    private float priceMultiplierA = 0.0f;
    private float priceMultiplierB = 0.0f;

    public TradeInventoryRecipe(Item sellItem, Item buyItem) {
        this(sellItem, buyItem, Item.get(0));
    }

    public TradeInventoryRecipe(Item sellItem, Item buyItem, Item secondBuyItem) {
        this.sellItem = sellItem;
        this.buyItem = buyItem;
        this.secondBuyItem = secondBuyItem;
    }

    public TradeInventoryRecipe setTier(int tier) {
        this.tier = tier;
        return this;
    }

    public TradeInventoryRecipe setMaxUses(int maxUses) {
        this.maxUses = maxUses;
        return this;
    }

    public TradeInventoryRecipe setBuyCount(int count, int type) {
        switch (type) {
            case 0: {
                this.buyCountA = count;
                break;
            }
            case 1: {
                this.buyCountB = count;
            }
        }
        this.buyCountA = count;
        return this;
    }

    public TradeInventoryRecipe setDemand(int demand) {
        this.demand = demand;
        return this;
    }

    public TradeInventoryRecipe setMultiplier(float multiplier, int type) {
        switch (type) {
            case 0: {
                this.priceMultiplierA = multiplier;
                break;
            }
            case 1: {
                this.priceMultiplierB = multiplier;
            }
        }
        return this;
    }

    public TradeInventoryRecipe setRewardExp(int reward) {
        this.rewardsExp = reward;
        return this;
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putCompound("buyA", NBTIO.putItemHelper(this.buyItem, -1));
        nbt.putCompound("buyB", NBTIO.putItemHelper(this.secondBuyItem, -1));
        nbt.putCompound("sell", NBTIO.putItemHelper(this.sellItem, -1));
        nbt.putInt("tier", this.tier);
        nbt.putInt("buyCountA", this.buyCountA);
        nbt.putInt("buyCountB", this.buyCountB);
        nbt.putInt("uses", 0);
        nbt.putInt("maxUses", this.maxUses);
        nbt.putInt("rewardExp", this.rewardsExp);
        nbt.putInt("demand", this.demand);
        nbt.putInt("traderExp", 0);
        nbt.putFloat("priceMultiplierA", this.priceMultiplierA);
        nbt.putFloat("priceMultiplierB", this.priceMultiplierB);
        return nbt;
    }

    public static TradeInventoryRecipe toNBT(CompoundTag nbt) {
        return new TradeInventoryRecipe(NBTIO.getItemHelper(nbt.getCompound("sell")), NBTIO.getItemHelper(nbt.getCompound("buyA")), NBTIO.getItemHelper(nbt.getCompound("buyB"))).setTier(nbt.getInt("tier")).setBuyCount(nbt.getInt("buyCountA"), 0).setBuyCount(nbt.getInt("buyCountB"), 1).setMaxUses(nbt.getInt("maxUses")).setMultiplier(nbt.getInt("priceMultiplierA"), 0).setMultiplier(nbt.getInt("priceMultiplierB"), 1).setDemand(nbt.getInt("demand")).setRewardExp(nbt.getInt("rewardExp"));
    }

    @Generated
    public Item getSellItem() {
        return this.sellItem;
    }

    @Generated
    public Item getBuyItem() {
        return this.buyItem;
    }

    @Generated
    public Item getSecondBuyItem() {
        return this.secondBuyItem;
    }
}

