/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.inventory.CraftingManager;
import cn.nukkit.inventory.RecipeType;
import cn.nukkit.inventory.ShapelessRecipe;
import cn.nukkit.item.Item;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class SmithingRecipe
extends ShapelessRecipe {
    private final Item equipment;
    private final Item ingredient;
    private final Item result;
    private final List<Item> ingredientsAggregate;

    public SmithingRecipe(String recipeId, int priority, Collection<Item> ingredients, Item result) {
        super(recipeId, priority, result, ingredients);
        this.equipment = (Item)ingredients.toArray()[0];
        this.ingredient = (Item)ingredients.toArray()[1];
        this.result = result;
        ArrayList<Item> aggregation = new ArrayList<Item>(2);
        for (Item item : new Item[]{this.equipment, this.ingredient}) {
            if (item.getCount() < 1) {
                throw new IllegalArgumentException("Recipe Ingredient amount was not 1 (value: " + item.getCount() + ")");
            }
            boolean found = false;
            for (Item existingIngredient : aggregation) {
                if (!existingIngredient.equals(item, item.hasMeta(), item.hasCompoundTag())) continue;
                existingIngredient.setCount(existingIngredient.getCount() + item.getCount());
                found = true;
                break;
            }
            if (found) continue;
            aggregation.add(item.clone());
        }
        aggregation.trimToSize();
        aggregation.sort(CraftingManager.recipeComparator);
        this.ingredientsAggregate = Collections.unmodifiableList(aggregation);
    }

    @Override
    public Item getResult() {
        return this.result;
    }

    public Item getFinalResult(Item equip) {
        int maxDurability;
        Item finalResult = this.getResult().clone();
        if (equip.hasCompoundTag()) {
            finalResult.setCompoundTag(equip.getCompoundTag());
        }
        if ((maxDurability = finalResult.getMaxDurability()) <= 0 || equip.getMaxDurability() <= 0) {
            return finalResult;
        }
        int damage = equip.getDamage();
        if (damage <= 0) {
            return finalResult;
        }
        finalResult.setDamage(Math.min(maxDurability, damage));
        return finalResult;
    }

    @Override
    public void registerToCraftingManager(CraftingManager manager) {
        manager.registerSmithingRecipe(this);
    }

    @Override
    public RecipeType getType() {
        return RecipeType.SMITHING_TRANSFORM;
    }

    public Item getEquipment() {
        return this.equipment;
    }

    public Item getIngredient() {
        return this.ingredient;
    }

    @Override
    public List<Item> getIngredientsAggregate() {
        return this.ingredientsAggregate;
    }

    public boolean matchItems(List<Item> inputList) {
        return this.matchItems(inputList, 1);
    }

    public boolean matchItems(List<Item> inputList, int multiplier) {
        ArrayList<Item> haveInputs = new ArrayList<Item>();
        for (Item item : inputList) {
            if (item.isNull()) continue;
            haveInputs.add(item.clone());
        }
        ArrayList<Item> needInputs = new ArrayList<Item>();
        if (multiplier != 1) {
            for (Item item : this.ingredientsAggregate) {
                if (item.isNull()) continue;
                Item itemClone = item.clone();
                itemClone.setCount(itemClone.getCount() * multiplier);
                needInputs.add(itemClone);
            }
        } else {
            for (Item item : this.ingredientsAggregate) {
                if (item.isNull()) continue;
                needInputs.add(item.clone());
            }
        }
        return SmithingRecipe.matchItemList(haveInputs, needInputs);
    }

    private static boolean matchItemList(List<Item> haveItems, List<Item> needItems) {
        block0: for (Item needItem : new ArrayList<Item>(needItems)) {
            for (Item haveItem : new ArrayList<Item>(haveItems)) {
                if (!needItem.equals(haveItem, needItem.hasMeta(), needItem.hasCompoundTag())) continue;
                int amount = Math.min(haveItem.getCount(), needItem.getCount());
                needItem.setCount(needItem.getCount() - amount);
                haveItem.setCount(haveItem.getCount() - amount);
                if (haveItem.getCount() == 0) {
                    haveItems.remove(haveItem);
                }
                if (needItem.getCount() != 0) continue;
                needItems.remove(needItem);
                continue block0;
            }
        }
        return haveItems.isEmpty() && needItems.isEmpty();
    }

    @Generated
    public String toString() {
        return "SmithingRecipe(equipment=" + this.getEquipment() + ", ingredient=" + this.getIngredient() + ", result=" + this.getResult() + ", ingredientsAggregate=" + this.getIngredientsAggregate() + ")";
    }
}

