/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.inventory.FakeBlockUIComponent;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.inventory.PlayerUIInventory;
import cn.nukkit.inventory.SmithingRecipe;
import cn.nukkit.item.Item;
import cn.nukkit.level.Position;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;

public class SmithingInventory
extends FakeBlockUIComponent {
    private static final int EQUIPMENT = 0;
    private static final int INGREDIENT = 1;
    public static final int SMITHING_EQUIPMENT_UI_SLOT = 51;
    public static final int SMITHING_INGREDIENT_UI_SLOT = 52;
    private Item currentResult = Item.get(0);
    private static final IntSet ITEMS = new IntOpenHashSet(new int[]{0, 742, 276, 277, 278, 279, 293, 310, 311, 312, 313, 743, 744, 745, 746, 747, 748, 749, 750, 751});

    public SmithingInventory(PlayerUIInventory playerUI, Position position) {
        super(playerUI, InventoryType.SMITHING_TABLE, 51, position);
    }

    public SmithingRecipe matchRecipe() {
        return Server.getInstance().getCraftingManager().matchSmithingRecipe(this.getEquipment(), this.getIngredient());
    }

    @Override
    public void onSlotChange(int index, Item before, boolean send) {
        if (index == 0 || index == 1) {
            this.updateResult();
        }
        super.onSlotChange(index, before, send);
    }

    public void updateResult() {
        SmithingRecipe recipe = this.matchRecipe();
        Item result = recipe == null ? Item.get(0) : recipe.getFinalResult(this.getEquipment());
        this.setResult(result);
    }

    private void setResult(Item result) {
        this.currentResult = result;
    }

    public Item getResult() {
        SmithingRecipe recipe = this.matchRecipe();
        if (recipe == null) {
            return Item.get(0);
        }
        return recipe.getFinalResult(this.getEquipment());
    }

    public Item getEquipment() {
        return this.getItem(0);
    }

    public void setEquipment(Item equipment) {
        this.setItem(0, equipment);
    }

    public Item getIngredient() {
        return this.getItem(1);
    }

    public void setIngredient(Item ingredient) {
        this.setItem(1, ingredient);
    }

    @Override
    public void onOpen(Player who) {
        super.onOpen(who);
        who.craftingType = 1003;
    }

    public Item getCurrentResult() {
        return this.currentResult;
    }

    @Override
    public boolean allowedToAdd(Item item) {
        return ITEMS.contains(item.getId());
    }
}

