/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Player;
import cn.nukkit.blockentity.BlockEntityShulkerBox;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.network.protocol.BlockEventPacket;

public class ShulkerBoxInventory
extends ContainerInventory {
    public ShulkerBoxInventory(BlockEntityShulkerBox box) {
        super(box, InventoryType.SHULKER_BOX);
    }

    @Override
    public BlockEntityShulkerBox getHolder() {
        return (BlockEntityShulkerBox)this.holder;
    }

    @Override
    public void onOpen(Player who) {
        super.onOpen(who);
        if (this.getViewers().size() == 1) {
            BlockEventPacket pk = new BlockEventPacket();
            pk.x = (int)this.getHolder().getX();
            pk.y = (int)this.getHolder().getY();
            pk.z = (int)this.getHolder().getZ();
            pk.case1 = 1;
            pk.case2 = 2;
            Level level = this.getHolder().getLevel();
            if (level != null) {
                level.addLevelSoundEvent(this.getHolder().add(0.5, 0.5, 0.5), 69);
                level.addChunkPacket((int)this.getHolder().getX() >> 4, (int)this.getHolder().getZ() >> 4, pk);
            }
        }
    }

    @Override
    public void onClose(Player who) {
        if (this.getViewers().size() == 1) {
            BlockEventPacket pk = new BlockEventPacket();
            pk.x = (int)this.getHolder().getX();
            pk.y = (int)this.getHolder().getY();
            pk.z = (int)this.getHolder().getZ();
            pk.case1 = 1;
            pk.case2 = 0;
            Level level = this.getHolder().getLevel();
            if (level != null) {
                level.addLevelSoundEvent(this.getHolder().add(0.5, 0.5, 0.5), 70);
                level.addChunkPacket((int)this.getHolder().getX() >> 4, (int)this.getHolder().getZ() >> 4, pk);
            }
        }
        super.onClose(who);
    }

    @Override
    public boolean canAddItem(Item item) {
        return this.allowedToAdd(item) && super.canAddItem(item);
    }

    @Override
    public boolean allowedToAdd(Item item) {
        int itemId = item.getId();
        return itemId != 218 && itemId != 205;
    }

    @Override
    public void onSlotChange(int index, Item before, boolean send) {
        super.onSlotChange(index, before, send);
        this.getHolder().chunk.setChanged();
    }
}

