/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Player;
import cn.nukkit.inventory.FakeBlockUIComponent;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.inventory.PlayerUIInventory;
import cn.nukkit.item.Item;
import cn.nukkit.level.Position;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;

public class LoomInventory
extends FakeBlockUIComponent {
    public static final int OFFSET = 9;
    public static final IntSet ITEMS = new IntOpenHashSet(new int[]{0, 446, 351, 434});

    public LoomInventory(PlayerUIInventory playerUI, Position position) {
        super(playerUI, InventoryType.LOOM, 9, position);
    }

    @Override
    public void onOpen(Player who) {
        super.onOpen(who);
        who.craftingType = 1004;
    }

    public Item getBanner() {
        return this.getItem(0);
    }

    public Item getDye() {
        return this.getItem(1);
    }

    public Item getPattern() {
        return this.getItem(2);
    }

    public void setBanner(Item item) {
        this.setItem(0, item);
    }

    public void setDye(Item item) {
        this.setItem(1, item);
    }

    public void setPattern(Item item) {
        this.setItem(2, item);
    }

    @Override
    public boolean allowedToAdd(Item item) {
        return ITEMS.contains(item.getId());
    }
}

