/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Player;
import cn.nukkit.blockentity.BlockEntityChest;
import cn.nukkit.inventory.ChestInventory;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.network.protocol.BlockEventPacket;
import cn.nukkit.network.protocol.InventorySlotPacket;
import java.util.HashMap;
import java.util.Map;

public class DoubleChestInventory
extends ContainerInventory
implements InventoryHolder {
    private final ChestInventory left;
    private final ChestInventory right;

    public DoubleChestInventory(BlockEntityChest left, BlockEntityChest right) {
        super(null, InventoryType.DOUBLE_CHEST);
        int idx;
        this.holder = this;
        this.left = left.getRealInventory();
        this.left.setDoubleInventory(this);
        this.right = right.getRealInventory();
        this.right.setDoubleInventory(this);
        HashMap<Integer, Item> items = new HashMap<Integer, Item>();
        for (idx = 0; idx < this.left.getSize(); ++idx) {
            if (!this.left.getContents().containsKey(idx)) continue;
            items.put(idx, this.left.getContents().get(idx));
        }
        for (idx = 0; idx < this.right.getSize(); ++idx) {
            if (!this.right.getContents().containsKey(idx)) continue;
            items.put(idx + this.left.getSize(), this.right.getContents().get(idx));
        }
        this.setContents(items);
    }

    @Override
    public Inventory getInventory() {
        return this;
    }

    @Override
    public BlockEntityChest getHolder() {
        return this.left.getHolder();
    }

    @Override
    public Item getItem(int index) {
        return index < this.left.getSize() ? this.left.getItem(index) : this.right.getItem(index - this.right.getSize());
    }

    @Override
    public Item getItemFast(int index) {
        return index < this.left.getSize() ? this.left.getItemFast(index) : this.right.getItemFast(index - this.right.getSize());
    }

    @Override
    public boolean setItem(int index, Item item, boolean send) {
        return index < this.left.getSize() ? this.left.setItem(index, item, send) : this.right.setItem(index - this.right.getSize(), item, send);
    }

    @Override
    public boolean clear(int index) {
        return index < this.left.getSize() ? this.left.clear(index) : this.right.clear(index - this.right.getSize());
    }

    @Override
    public Map<Integer, Item> getContents() {
        HashMap<Integer, Item> contents = new HashMap<Integer, Item>();
        for (int i = 0; i < this.getSize(); ++i) {
            contents.put(i, this.getItem(i));
        }
        return contents;
    }

    @Override
    public void setContents(Map<Integer, Item> items) {
        if (items.size() > this.size) {
            HashMap<Integer, Item> newItems = new HashMap<Integer, Item>();
            for (int i = 0; i < this.size; ++i) {
                newItems.put(i, items.get(i));
            }
            items = newItems;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!items.containsKey(i)) {
                if (i < this.left.size) {
                    if (!this.left.slots.containsKey(i)) continue;
                    this.clear(i);
                    continue;
                }
                if (!this.right.slots.containsKey(i - this.left.size)) continue;
                this.clear(i);
                continue;
            }
            if (this.setItem(i, items.get(i))) continue;
            this.clear(i);
        }
    }

    @Override
    public void onOpen(Player who) {
        Level level;
        super.onOpen(who);
        this.left.viewers.add(who);
        this.right.viewers.add(who);
        if (this.getViewers().size() == 1 && (level = this.left.getHolder().getLevel()) != null) {
            BlockEventPacket pk1 = new BlockEventPacket();
            pk1.x = (int)this.left.getHolder().getX();
            pk1.y = (int)this.left.getHolder().getY();
            pk1.z = (int)this.left.getHolder().getZ();
            pk1.case1 = 1;
            pk1.case2 = 2;
            BlockEventPacket pk2 = new BlockEventPacket();
            pk2.x = (int)this.right.getHolder().getX();
            pk2.y = (int)this.right.getHolder().getY();
            pk2.z = (int)this.right.getHolder().getZ();
            pk2.case1 = 1;
            pk2.case2 = 2;
            level.addLevelSoundEvent(this.left.getHolder().add(0.5, 0.5, 0.5), 67);
            level.addChunkPacket((int)this.left.getHolder().getX() >> 4, (int)this.left.getHolder().getZ() >> 4, pk1);
            level.addChunkPacket((int)this.right.getHolder().getX() >> 4, (int)this.right.getHolder().getZ() >> 4, pk2);
        }
    }

    @Override
    public void onClose(Player who) {
        Level level;
        if (this.getViewers().size() == 1 && (level = this.right.getHolder().getLevel()) != null) {
            BlockEventPacket pk1 = new BlockEventPacket();
            pk1.x = (int)this.right.getHolder().getX();
            pk1.y = (int)this.right.getHolder().getY();
            pk1.z = (int)this.right.getHolder().getZ();
            pk1.case1 = 1;
            pk1.case2 = 0;
            BlockEventPacket pk2 = new BlockEventPacket();
            pk2.x = (int)this.left.getHolder().getX();
            pk2.y = (int)this.left.getHolder().getY();
            pk2.z = (int)this.left.getHolder().getZ();
            pk2.case1 = 1;
            pk2.case2 = 0;
            level.addLevelSoundEvent(this.left.getHolder().add(0.5, 0.5, 0.5), 68);
            level.addChunkPacket((int)this.right.getHolder().getX() >> 4, (int)this.right.getHolder().getZ() >> 4, pk1);
            level.addChunkPacket((int)this.left.getHolder().getX() >> 4, (int)this.left.getHolder().getZ() >> 4, pk2);
        }
        this.left.viewers.remove(who);
        this.right.viewers.remove(who);
        super.onClose(who);
    }

    public ChestInventory getLeftSide() {
        return this.left;
    }

    public ChestInventory getRightSide() {
        return this.right;
    }

    public void sendSlot(Inventory inv, int index, Player ... players) {
        InventorySlotPacket pk = new InventorySlotPacket();
        pk.slot = inv == this.right ? this.left.getSize() + index : index;
        pk.item = inv.getItem(index);
        for (Player player : players) {
            int id = player.getWindowId(this);
            if (id == -1) {
                this.close(player);
                continue;
            }
            pk.inventoryId = id;
            player.dataPacket(pk);
        }
    }

    @Override
    public void onSlotChange(int index, Item before, boolean send) {
        super.onSlotChange(index, before, send);
        this.left.getHolder().chunk.setChanged();
        this.right.getHolder().chunk.setChanged();
    }
}

