/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Server;
import cn.nukkit.inventory.BrewingRecipe;
import cn.nukkit.inventory.CampfireRecipe;
import cn.nukkit.inventory.ContainerRecipe;
import cn.nukkit.inventory.CraftingRecipe;
import cn.nukkit.inventory.FurnaceRecipe;
import cn.nukkit.inventory.MultiRecipe;
import cn.nukkit.inventory.Recipe;
import cn.nukkit.inventory.ShapedRecipe;
import cn.nukkit.inventory.ShapelessRecipe;
import cn.nukkit.inventory.SmithingRecipe;
import cn.nukkit.item.Item;
import cn.nukkit.item.RuntimeItems;
import cn.nukkit.network.protocol.CraftingDataPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.ConfigSection;
import cn.nukkit.utils.MainLogger;
import cn.nukkit.utils.Utils;
import io.netty.util.collection.CharObjectHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftingManager {
    @Generated
    private static final Logger log = LogManager.getLogger(CraftingManager.class);
    public final Collection<Recipe> recipes = new ArrayDeque<Recipe>();
    public static DataPacket packet;
    protected final Map<Integer, Map<UUID, ShapedRecipe>> shapedRecipes = new Int2ObjectOpenHashMap<Map<UUID, ShapedRecipe>>();
    protected final Map<Integer, Map<UUID, ShapelessRecipe>> shapelessRecipes = new Int2ObjectOpenHashMap<Map<UUID, ShapelessRecipe>>();
    public final Map<UUID, MultiRecipe> multiRecipes = new HashMap<UUID, MultiRecipe>();
    public final Map<Integer, FurnaceRecipe> furnaceRecipes = new Int2ObjectOpenHashMap<FurnaceRecipe>();
    public final Map<Integer, BrewingRecipe> brewingRecipes = new Int2ObjectOpenHashMap<BrewingRecipe>();
    public final Map<Integer, ContainerRecipe> containerRecipes = new Int2ObjectOpenHashMap<ContainerRecipe>();
    private final Map<Integer, CampfireRecipe> campfireRecipes = new Int2ObjectOpenHashMap<CampfireRecipe>();
    private final Map<Integer, SmithingRecipe> smithingRecipes = new Int2ObjectOpenHashMap<SmithingRecipe>();
    private static int RECIPE_COUNT;
    static int NEXT_NETWORK_ID;
    public static final Comparator<Item> recipeComparator;

    public CraftingManager() {
        InputStream recipesStream = Server.class.getClassLoader().getResourceAsStream("recipes.json");
        if (recipesStream == null) {
            throw new AssertionError((Object)"Unable to find recipes.json");
        }
        Config recipesConfig = new Config(1);
        recipesConfig.load(recipesStream);
        this.loadRecipes(recipesConfig);
        String path = Server.getInstance().getDataPath() + "custom_recipes.json";
        File filePath = new File(path);
        if (filePath.exists()) {
            Config customRecipes = new Config(filePath, 1);
            this.loadRecipes(customRecipes);
        }
        this.registerSmithingRecipes();
        this.rebuildPacket();
        MainLogger.getLogger().info("Successfully loaded " + this.recipes.size() + " recipes");
    }

    private void registerSmithingRecipes() {
        ConfigSection smithing = new Config(2).loadFromStream(Server.class.getClassLoader().getResourceAsStream("smithing.json")).getRootSection();
        for (Map recipe : (List)smithing.get((Object)"smithing")) {
            List outputs = (List)recipe.get("output");
            if (outputs.size() > 1) continue;
            String recipeId = (String)recipe.get("id");
            Map first = (Map)outputs.get(0);
            Item item = Item.get(RuntimeItems.getMapping().fromIdentifier((String)first.get("id")).getLegacyId(), (Integer)0, 1);
            ArrayList<Item> ingredients = new ArrayList<Item>();
            for (Map ingredient : (List)recipe.get("input")) {
                Item ing = Item.get(RuntimeItems.getMapping().fromIdentifier((String)ingredient.get("id")).getLegacyId(), (Integer)0, 1);
                ingredients.add(ing);
            }
            this.registerRecipe(new SmithingRecipe(recipeId, 0, ingredients, item));
            this.registerRecipe(new SmithingRecipe(recipeId, 0, ingredients, item));
        }
    }

    private void loadRecipes(Config config) {
        List<Map> recipes = config.getMapList("recipes");
        MainLogger.getLogger().info("Loading recipes...");
        for (Map map : recipes) {
            try {
                switch (Utils.toInt(map.get("type"))) {
                    case 0: {
                        List outputs;
                        String craftingBlock = (String)map.get("block");
                        if (!"crafting_table".equals(craftingBlock) || (outputs = (List)map.get("output")).size() > 1) break;
                        Map first = (Map)outputs.get(0);
                        ArrayList<Item> sorted = new ArrayList<Item>();
                        for (Map ingredient : (List)map.get("input")) {
                            sorted.add(Item.fromJson(ingredient));
                        }
                        sorted.sort(recipeComparator);
                        Item resultItem = Item.fromJson(first);
                        this.registerRecipe(new ShapelessRecipe(null, Utils.toInt(map.get("priority")), resultItem, sorted));
                        break;
                    }
                    case 1: {
                        String craftingBlock = (String)map.get("block");
                        if (!"crafting_table".equals(craftingBlock)) break;
                        List outputs = (List)map.get("output");
                        Map first = (Map)outputs.remove(0);
                        String[] shape = ((List)map.get("shape")).toArray(new String[0]);
                        CharObjectHashMap<Item> ingredients = new CharObjectHashMap<Item>();
                        ArrayList<Item> extraResults = new ArrayList<Item>();
                        Map input = (Map)map.get("input");
                        for (Map.Entry ingredientEntry : input.entrySet()) {
                            char ingredientChar = ((String)ingredientEntry.getKey()).charAt(0);
                            Item ingredient = Item.fromJson((Map)ingredientEntry.getValue());
                            ingredients.put(Character.valueOf(ingredientChar), ingredient);
                        }
                        for (Map data : outputs) {
                            extraResults.add(Item.fromJson(data));
                        }
                        Item resultItem = Item.fromJson(first);
                        this.registerRecipe(new ShapedRecipe(null, Utils.toInt(map.get("priority")), resultItem, shape, ingredients, extraResults));
                        break;
                    }
                    case 3: {
                        String craftingBlock = (String)map.get("block");
                        if (!"furnace".equals(craftingBlock) && !"campfire".equals(craftingBlock)) break;
                        Map resultMap = (Map)map.get("output");
                        Item resultItem = Item.fromJson(resultMap);
                        Map inputMap = (Map)map.get("input");
                        Item inputItem = Item.fromJson(inputMap);
                        switch (craftingBlock) {
                            case "furnace": {
                                this.registerRecipe(new FurnaceRecipe(resultItem, inputItem));
                                break;
                            }
                            case "campfire": {
                                this.registerRecipe(new CampfireRecipe(resultItem, inputItem));
                            }
                        }
                        break;
                    }
                    case 4: {
                        this.registerRecipe(new MultiRecipe(UUID.fromString((String)map.get("uuid"))));
                        break;
                    }
                }
            }
            catch (Exception e) {
                MainLogger.getLogger().error("Exception during registering recipe", e);
            }
        }
        List<Map> potionMixes = config.getMapList("potionMixes");
        for (Map potionMix : potionMixes) {
            int fromPotionId = ((Number)potionMix.get("inputId")).intValue();
            int fromPotionMeta = ((Number)potionMix.get("inputMeta")).intValue();
            int ingredient = ((Number)potionMix.get("reagentId")).intValue();
            int ingredientMeta = ((Number)potionMix.get("reagentMeta")).intValue();
            int toPotionId = ((Number)potionMix.get("outputId")).intValue();
            int toPotionMeta = ((Number)potionMix.get("outputMeta")).intValue();
            this.registerBrewingRecipe(new BrewingRecipe(Item.get(fromPotionId, (Integer)fromPotionMeta), Item.get(ingredient, (Integer)ingredientMeta), Item.get(toPotionId, (Integer)toPotionMeta)));
        }
        List<Map> list = config.getMapList("containerMixes");
        for (Map containerMix : list) {
            int fromItemId = ((Number)containerMix.get("inputId")).intValue();
            int ingredient = ((Number)containerMix.get("reagentId")).intValue();
            int toItemId = ((Number)containerMix.get("outputId")).intValue();
            this.registerContainerRecipe(new ContainerRecipe(Item.get(fromItemId), Item.get(ingredient), Item.get(toItemId)));
        }
    }

    public void rebuildPacket() {
        CraftingDataPacket pk = new CraftingDataPacket();
        pk.cleanRecipes = true;
        for (Recipe recipe : this.getRecipes()) {
            if (recipe instanceof ShapedRecipe) {
                pk.addShapedRecipe((ShapedRecipe)recipe);
                continue;
            }
            if (!(recipe instanceof ShapelessRecipe)) continue;
            pk.addShapelessRecipe((ShapelessRecipe)recipe);
        }
        for (FurnaceRecipe furnaceRecipe : this.getFurnaceRecipes().values()) {
            pk.addFurnaceRecipe(furnaceRecipe);
        }
        for (MultiRecipe multiRecipe : this.multiRecipes.values()) {
            pk.addMultiRecipe(multiRecipe);
        }
        for (BrewingRecipe brewingRecipe : this.brewingRecipes.values()) {
            pk.addBrewingRecipe(brewingRecipe);
        }
        for (ContainerRecipe containerRecipe : this.containerRecipes.values()) {
            pk.addContainerRecipe(containerRecipe);
        }
        pk.tryEncode();
        packet = pk.compress(9);
    }

    public Collection<Recipe> getRecipes() {
        return this.recipes;
    }

    public Map<Integer, FurnaceRecipe> getFurnaceRecipes() {
        return this.furnaceRecipes;
    }

    public FurnaceRecipe matchFurnaceRecipe(Item input) {
        FurnaceRecipe recipe = this.furnaceRecipes.get(CraftingManager.getItemHash(input));
        if (recipe == null) {
            recipe = this.furnaceRecipes.get(CraftingManager.getItemHash(input.getId(), 0));
        }
        return recipe;
    }

    private static UUID getMultiItemHash(Collection<Item> items) {
        BinaryStream stream = new BinaryStream(new byte[5 * items.size()]).reset();
        for (Item item : items) {
            stream.putVarInt(CraftingManager.getFullItemHash(item));
        }
        return UUID.nameUUIDFromBytes(stream.getBuffer());
    }

    private static int getFullItemHash(Item item) {
        return CraftingManager.getItemHash(item) << 6 | item.getCount() & 0x3F;
    }

    public void registerFurnaceRecipe(FurnaceRecipe recipe) {
        Item input = recipe.getInput();
        this.furnaceRecipes.put(CraftingManager.getItemHash(input), recipe);
    }

    private static int getItemHash(Item item) {
        return CraftingManager.getItemHash(item.getId(), item.getDamage());
    }

    private static int getItemHash(int id, int meta) {
        return id << 12 | meta & 0xFFF;
    }

    public void registerShapedRecipe(ShapedRecipe recipe) {
        int resultHash = CraftingManager.getItemHash(recipe.getResult());
        Map map = this.shapedRecipes.computeIfAbsent(resultHash, k -> new HashMap());
        LinkedList<Item> inputList = new LinkedList<Item>(recipe.getIngredientsAggregate());
        map.put(CraftingManager.getMultiItemHash(inputList), recipe);
    }

    public void registerRecipe(Recipe recipe) {
        if (recipe instanceof CraftingRecipe) {
            UUID id = Utils.dataToUUID(String.valueOf(++RECIPE_COUNT), String.valueOf(recipe.getResult().getId()), String.valueOf(recipe.getResult().getDamage()), String.valueOf(recipe.getResult().getCount()), Arrays.toString(recipe.getResult().getCompoundTag()));
            ((CraftingRecipe)recipe).setId(id);
            this.recipes.add(recipe);
        }
        recipe.registerToCraftingManager(this);
    }

    public void registerShapelessRecipe(ShapelessRecipe recipe) {
        List<Item> list = recipe.getIngredientsAggregate();
        UUID hash = CraftingManager.getMultiItemHash(list);
        int resultHash = CraftingManager.getItemHash(recipe.getResult());
        Map map = this.shapelessRecipes.computeIfAbsent(resultHash, k -> new HashMap());
        map.put(hash, recipe);
    }

    private static int getPotionHash(Item ingredient, Item potion) {
        int ingredientHash = (ingredient.getId() & 0x3FF) << 6 | ingredient.getDamage() & 0x3F;
        int potionHash = (potion.getId() & 0x3FF) << 6 | potion.getDamage() & 0x3F;
        return ingredientHash << 16 | potionHash;
    }

    private static int getContainerHash(int ingredientId, int containerId) {
        return ingredientId << 15 | containerId;
    }

    public void registerBrewingRecipe(BrewingRecipe recipe) {
        Item input = recipe.getIngredient();
        Item potion = recipe.getInput();
        this.brewingRecipes.put(CraftingManager.getPotionHash(input, potion), recipe);
    }

    public void registerContainerRecipe(ContainerRecipe recipe) {
        Item input = recipe.getIngredient();
        Item potion = recipe.getInput();
        this.containerRecipes.put(CraftingManager.getContainerHash(input.getId(), potion.getId()), recipe);
    }

    public BrewingRecipe matchBrewingRecipe(Item input, Item potion) {
        int id = potion.getId();
        if (id == 373 || id == 438 || id == 441) {
            return this.brewingRecipes.get(CraftingManager.getPotionHash(input, potion));
        }
        return null;
    }

    public ContainerRecipe matchContainerRecipe(Item input, Item potion) {
        return this.containerRecipes.get(CraftingManager.getContainerHash(input.getId(), potion.getId()));
    }

    public CraftingRecipe matchRecipe(List<Item> inputList, Item primaryOutput, List<Item> extraOutputList) {
        CraftingRecipe recipe;
        UUID inputHash;
        int outputHash = CraftingManager.getItemHash(primaryOutput);
        if (this.shapedRecipes.containsKey(outputHash)) {
            inputList.sort(recipeComparator);
            inputHash = CraftingManager.getMultiItemHash(inputList);
            Map<UUID, ShapedRecipe> recipeMap = this.shapedRecipes.get(outputHash);
            if (recipeMap != null) {
                recipe = recipeMap.get(inputHash);
                if (recipe != null && (((ShapedRecipe)recipe).matchItems(inputList, extraOutputList) || this.matchItemsAccumulation(recipe, inputList, primaryOutput, extraOutputList))) {
                    return recipe;
                }
                for (ShapedRecipe shapedRecipe : recipeMap.values()) {
                    if (!shapedRecipe.matchItems(inputList, extraOutputList) && !this.matchItemsAccumulation(shapedRecipe, inputList, primaryOutput, extraOutputList)) continue;
                    return shapedRecipe;
                }
            }
        }
        if (this.shapelessRecipes.containsKey(outputHash)) {
            inputList.sort(recipeComparator);
            inputHash = CraftingManager.getMultiItemHash(inputList);
            Map<UUID, ShapelessRecipe> recipes = this.shapelessRecipes.get(outputHash);
            if (recipes == null) {
                return null;
            }
            recipe = recipes.get(inputHash);
            if (recipe != null && (((ShapelessRecipe)recipe).matchItems(inputList, extraOutputList) || this.matchItemsAccumulation(recipe, inputList, primaryOutput, extraOutputList))) {
                return recipe;
            }
            for (ShapelessRecipe shapelessRecipe : recipes.values()) {
                if (!shapelessRecipe.matchItems(inputList, extraOutputList) && !this.matchItemsAccumulation(shapelessRecipe, inputList, primaryOutput, extraOutputList)) continue;
                return shapelessRecipe;
            }
        }
        return null;
    }

    public CampfireRecipe matchCampfireRecipe(Item input) {
        CampfireRecipe recipe = this.campfireRecipes.get(CraftingManager.getItemHash(input));
        if (recipe == null) {
            recipe = this.campfireRecipes.get(CraftingManager.getItemHash(input.getId(), 0));
        }
        return recipe;
    }

    private boolean matchItemsAccumulation(CraftingRecipe recipe, List<Item> inputList, Item primaryOutput, List<Item> extraOutputList) {
        Item recipeResult = recipe.getResult();
        if (primaryOutput.equals(recipeResult, recipeResult.hasMeta(), recipeResult.hasCompoundTag()) && primaryOutput.getCount() % recipeResult.getCount() == 0) {
            int multiplier = primaryOutput.getCount() / recipeResult.getCount();
            return recipe.matchItems(inputList, extraOutputList, multiplier);
        }
        return false;
    }

    public SmithingRecipe matchSmithingRecipe(Item equipment, Item ingredient) {
        return this.smithingRecipes.get(CraftingManager.getContainerHash(ingredient.getId(), equipment.getId()));
    }

    public void registerMultiRecipe(MultiRecipe recipe) {
        this.multiRecipes.put(recipe.getId(), recipe);
    }

    public void registerCampfireRecipe(CampfireRecipe recipe) {
        this.campfireRecipes.put(CraftingManager.getItemHash(recipe.getInput()), recipe);
    }

    public void registerSmithingRecipe(SmithingRecipe recipe) {
        Item input = recipe.getIngredient();
        Item potion = recipe.getEquipment();
        this.smithingRecipes.put(CraftingManager.getContainerHash(input.getId(), potion.getId()), recipe);
    }

    @Generated
    public Map<Integer, CampfireRecipe> getCampfireRecipes() {
        return this.campfireRecipes;
    }

    @Generated
    public Map<Integer, SmithingRecipe> getSmithingRecipes() {
        return this.smithingRecipes;
    }

    static {
        RECIPE_COUNT = 0;
        recipeComparator = (i1, i2) -> {
            if (i1.getId() > i2.getId()) {
                return 1;
            }
            if (i1.getId() < i2.getId()) {
                return -1;
            }
            if (i1.getDamage() > i2.getDamage()) {
                return 1;
            }
            if (i1.getDamage() < i2.getDamage()) {
                return -1;
            }
            return Integer.compare(i1.getCount(), i2.getCount());
        };
    }
}

