/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Player;
import cn.nukkit.block.BlockTrappedChest;
import cn.nukkit.blockentity.BlockEntityChest;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.inventory.DoubleChestInventory;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.network.protocol.BlockEventPacket;

public class ChestInventory
extends ContainerInventory {
    protected DoubleChestInventory doubleInventory;

    public ChestInventory(BlockEntityChest chest) {
        super(chest, InventoryType.CHEST);
    }

    @Override
    public BlockEntityChest getHolder() {
        return (BlockEntityChest)this.holder;
    }

    @Override
    public void onOpen(Player who) {
        super.onOpen(who);
        if (this.getViewers().size() == 1) {
            BlockEventPacket pk = new BlockEventPacket();
            pk.x = (int)this.getHolder().getX();
            pk.y = (int)this.getHolder().getY();
            pk.z = (int)this.getHolder().getZ();
            pk.case1 = 1;
            pk.case2 = 2;
            Level level = this.getHolder().getLevel();
            if (level != null) {
                level.addLevelSoundEvent(this.getHolder().add(0.5, 0.5, 0.5), 67);
                level.addChunkPacket((int)this.getHolder().getX() >> 4, (int)this.getHolder().getZ() >> 4, pk);
                if (this.getHolder().getBlock() instanceof BlockTrappedChest) {
                    level.updateAroundRedstone(this.getHolder(), null);
                }
            }
        }
    }

    @Override
    public void onClose(Player who) {
        Level level;
        if (this.getViewers().size() == 1) {
            BlockEventPacket pk = new BlockEventPacket();
            pk.x = (int)this.getHolder().getX();
            pk.y = (int)this.getHolder().getY();
            pk.z = (int)this.getHolder().getZ();
            pk.case1 = 1;
            pk.case2 = 0;
            Level level2 = this.getHolder().getLevel();
            if (level2 != null) {
                level2.addLevelSoundEvent(this.getHolder().add(0.5, 0.5, 0.5), 68);
                level2.addChunkPacket((int)this.getHolder().getX() >> 4, (int)this.getHolder().getZ() >> 4, pk);
            }
        }
        super.onClose(who);
        if (this.getViewers().isEmpty() && (level = this.getHolder().getLevel()) != null && this.getHolder().getBlock() instanceof BlockTrappedChest) {
            level.updateAroundRedstone(this.getHolder(), null);
        }
    }

    public void setDoubleInventory(DoubleChestInventory doubleInventory) {
        this.doubleInventory = doubleInventory;
    }

    public DoubleChestInventory getDoubleInventory() {
        return this.doubleInventory;
    }

    @Override
    public void sendSlot(int index, Player ... players) {
        if (this.doubleInventory != null) {
            this.doubleInventory.sendSlot(this, index, players);
        } else {
            super.sendSlot(index, players);
        }
    }

    @Override
    public void onSlotChange(int index, Item before, boolean send) {
        super.onSlotChange(index, before, send);
        this.getHolder().chunk.setChanged();
    }
}

