/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.blockentity.BlockEntityCampfire;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.item.Item;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;

public class CampfireInventory
extends ContainerInventory {
    public CampfireInventory(BlockEntityCampfire campfire) {
        super(campfire, InventoryType.CAMPFIRE);
    }

    @Override
    public BlockEntityCampfire getHolder() {
        return (BlockEntityCampfire)this.holder;
    }

    @Override
    public void onSlotChange(int index, Item before, boolean send) {
        super.onSlotChange(index, before, send);
        this.getHolder().scheduleUpdate();
        this.getHolder().spawnToAll();
        this.getHolder().chunk.setChanged();
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public boolean canAddItem(Item item) {
        int count = item.getCount();
        boolean checkDamage = item.hasMeta();
        boolean checkTag = item.getCompoundTag() != null;
        int i1 = this.getSize();
        for (int i = 0; i < i1; ++i) {
            Item slot = this.getItemFast(i);
            if (item.equals(slot, checkDamage, checkTag)) {
                int diff = 1 - slot.getCount();
                if (diff > 0) {
                    count -= diff;
                }
            } else if (slot.getId() == 0) {
                --count;
            }
            if (count > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Item[] addItem(Item ... slots) {
        ArrayList<Item> itemSlots = new ArrayList<Item>();
        for (Item item : slots) {
            if (item.getId() == 0 || item.getCount() <= 0) continue;
            itemSlots.add(item.clone());
        }
        IntArrayList emptySlots = new IntArrayList();
        for (int i = 0; i < this.getSize(); ++i) {
            Item item = this.getItem(i);
            if (item.getId() == 0 || item.getCount() <= 0) {
                emptySlots.add(i);
            }
            for (Item slot : new ArrayList(itemSlots)) {
                if (!slot.equals(item) || item.getCount() >= 1) continue;
                int amount = Math.min(1 - item.getCount(), slot.getCount());
                if ((amount = Math.min(amount, 1)) <= 0) continue;
                slot.setCount(slot.getCount() - amount);
                item.setCount(item.getCount() + amount);
                this.setItem(i, item);
                if (slot.getCount() > 0) continue;
                itemSlots.remove(slot);
            }
            if (itemSlots.isEmpty()) break;
        }
        if (!itemSlots.isEmpty() && !emptySlots.isEmpty()) {
            IntListIterator intListIterator = emptySlots.iterator();
            while (intListIterator.hasNext()) {
                int slotIndex = (Integer)intListIterator.next();
                if (itemSlots.isEmpty()) continue;
                Item item = (Item)itemSlots.get(0);
                int amount = Math.min(1, item.getCount());
                item.setCount(item.getCount() - amount);
                Item item2 = item.clone();
                item2.setCount(amount);
                this.setItem(slotIndex, item2);
                if (item.getCount() > 0) continue;
                itemSlots.remove(item);
            }
        }
        return itemSlots.toArray(new Item[0]);
    }
}

