/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.blockentity.BlockEntityBrewingStand;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.item.Item;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;

public class BrewingInventory
extends ContainerInventory {
    public BrewingInventory(BlockEntityBrewingStand brewingStand) {
        super(brewingStand, InventoryType.BREWING_STAND);
    }

    @Override
    public BlockEntityBrewingStand getHolder() {
        return (BlockEntityBrewingStand)this.holder;
    }

    public Item getIngredient() {
        return this.getItem(0);
    }

    public void setIngredient(Item item) {
        this.setItem(0, item);
    }

    public void setFuel(Item fuel) {
        this.setItem(4, fuel);
    }

    public Item getFuel() {
        return this.getItem(4);
    }

    @Override
    public void onSlotChange(int index, Item before, boolean send) {
        super.onSlotChange(index, before, send);
        if (index >= 1 && index <= 3) {
            this.getHolder().updateBlock();
        }
        this.getHolder().scheduleUpdate();
        this.getHolder().chunk.setChanged();
    }

    @Override
    public Item[] addItem(Item ... slots) {
        ArrayList<Item> itemSlots = new ArrayList<Item>();
        for (Item slot : slots) {
            if (slot.getId() == 0 || slot.getCount() <= 0) continue;
            itemSlots.add(slot.clone());
        }
        IntArrayList emptySlots = new IntArrayList();
        boolean isFuel = slots.length > 0 && slots[0].getId() == 377;
        for (int i = isFuel ? 4 : 1; i < (isFuel ? 5 : this.getSize() - 1); ++i) {
            Item item = this.getItem(i);
            if (item.getId() == 0 || item.getCount() <= 0) {
                emptySlots.add(i);
            }
            for (Item slot : new ArrayList(itemSlots)) {
                if (!slot.equals(item) || item.getCount() >= item.getMaxStackSize()) continue;
                int amount = Math.min(item.getMaxStackSize() - item.getCount(), slot.getCount());
                if ((amount = Math.min(amount, this.maxStackSize)) <= 0) continue;
                slot.setCount(slot.getCount() - amount);
                item.setCount(item.getCount() + amount);
                this.setItem(i, item);
                if (slot.getCount() > 0) continue;
                itemSlots.remove(slot);
            }
            if (itemSlots.isEmpty()) break;
        }
        if (!itemSlots.isEmpty() && !emptySlots.isEmpty()) {
            IntListIterator intListIterator = emptySlots.iterator();
            while (intListIterator.hasNext()) {
                int slotIndex = (Integer)intListIterator.next();
                if (itemSlots.isEmpty()) continue;
                Item slot = (Item)itemSlots.get(0);
                int amount = Math.min(slot.getMaxStackSize(), slot.getCount());
                amount = Math.min(amount, this.maxStackSize);
                slot.setCount(slot.getCount() - amount);
                Item item = slot.clone();
                item.setCount(amount);
                this.setItem(slotIndex, item);
                if (slot.getCount() > 0) continue;
                itemSlots.remove(slot);
            }
        }
        return itemSlots.toArray(new Item[0]);
    }
}

