/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.entity.EntityInventoryChangeEvent;
import cn.nukkit.event.inventory.InventoryOpenEvent;
import cn.nukkit.inventory.DoubleChestInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.network.protocol.InventoryContentPacket;
import cn.nukkit.network.protocol.InventorySlotPacket;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class BaseInventory
implements Inventory {
    protected final InventoryType type;
    protected int maxStackSize = 64;
    protected int size;
    protected final String name;
    protected final String title;
    public final Map<Integer, Item> slots = new HashMap<Integer, Item>();
    protected final Set<Player> viewers = new HashSet<Player>();
    protected InventoryHolder holder;
    final Item air = new ItemBlock(Block.get(0, null), 0, 0);

    public BaseInventory(InventoryHolder holder, InventoryType type) {
        this(holder, type, new HashMap<Integer, Item>());
    }

    public BaseInventory(InventoryHolder holder, InventoryType type, Map<Integer, Item> items) {
        this(holder, type, items, null);
    }

    public BaseInventory(InventoryHolder holder, InventoryType type, Map<Integer, Item> items, Integer overrideSize) {
        this(holder, type, items, overrideSize, null);
    }

    public BaseInventory(InventoryHolder holder, InventoryType type, Map<Integer, Item> items, Integer overrideSize, String overrideTitle) {
        this.holder = holder;
        this.type = type;
        this.size = overrideSize != null ? overrideSize.intValue() : this.type.getDefaultSize();
        this.title = overrideTitle != null ? overrideTitle : this.type.getDefaultTitle();
        this.name = this.type.getDefaultTitle();
        if (!(this instanceof DoubleChestInventory)) {
            this.setContents(items);
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Item getItem(int index) {
        Item get = this.slots.get(index);
        return get == null ? new ItemBlock(Block.get(0), null, 0) : get.clone();
    }

    @Override
    public Item getItemFast(int index) {
        Item get = this.slots.get(index);
        return get == null ? this.air : get;
    }

    @Override
    public Map<Integer, Item> getContents() {
        return new HashMap<Integer, Item>(this.slots);
    }

    @Override
    public void setContents(Map<Integer, Item> items) {
        if (items.size() > this.size) {
            items = new TreeMap<Integer, Item>(items);
            TreeMap<Integer, Item> newItems = new TreeMap<Integer, Item>();
            int i = 0;
            for (Map.Entry<Integer, Item> entry : items.entrySet()) {
                newItems.put(entry.getKey(), entry.getValue());
                if (++i < this.size) continue;
                break;
            }
            items = newItems;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!items.containsKey(i)) {
                if (!this.slots.containsKey(i)) continue;
                this.clear(i);
                continue;
            }
            if (this.setItem(i, items.get(i))) continue;
            this.clear(i);
        }
    }

    @Override
    public boolean setItem(int index, Item item, boolean send) {
        if (index < 0 || index >= this.size) {
            return false;
        }
        if (item.getId() == 0 || item.getCount() <= 0) {
            return this.clear(index, send);
        }
        InventoryHolder holder = this.getHolder();
        if (holder instanceof Entity) {
            EntityInventoryChangeEvent ev = new EntityInventoryChangeEvent((Entity)((Object)holder), this.getItem(index), item, index);
            Server.getInstance().getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                this.sendSlot(index, this.getViewers());
                return false;
            }
            item = ev.getNewItem();
        }
        if (holder instanceof BlockEntity) {
            ((BlockEntity)((Object)holder)).setDirty();
        }
        Item old = this.getItem(index);
        this.slots.put(index, item.clone());
        this.onSlotChange(index, old, send);
        return true;
    }

    @Override
    public boolean contains(Item item) {
        int count = Math.max(1, item.getCount());
        boolean checkDamage = item.hasMeta() && item.getDamage() >= 0;
        boolean checkTag = item.getCompoundTag() != null;
        for (Item i : this.getContents().values()) {
            if (!item.equals(i, checkDamage, checkTag) || (count -= i.getCount()) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<Integer, Item> all(Item item) {
        HashMap<Integer, Item> slots = new HashMap<Integer, Item>();
        boolean checkDamage = item.hasMeta() && item.getDamage() >= 0;
        boolean checkTag = item.getCompoundTag() != null;
        for (Map.Entry<Integer, Item> entry : this.getContents().entrySet()) {
            if (!item.equals(entry.getValue(), checkDamage, checkTag)) continue;
            slots.put(entry.getKey(), entry.getValue());
        }
        return slots;
    }

    @Override
    public void remove(Item item) {
        boolean checkDamage = item.hasMeta();
        boolean checkTag = item.getCompoundTag() != null;
        for (Map.Entry<Integer, Item> entry : this.getContents().entrySet()) {
            if (!item.equals(entry.getValue(), checkDamage, checkTag)) continue;
            this.clear(entry.getKey());
        }
    }

    @Override
    public int first(Item item, boolean exact) {
        int count = Math.max(1, item.getCount());
        boolean checkDamage = item.hasMeta();
        boolean checkTag = item.getCompoundTag() != null;
        for (Map.Entry<Integer, Item> entry : this.getContents().entrySet()) {
            if (!item.equals(entry.getValue(), checkDamage, checkTag) || entry.getValue().getCount() != count && (exact || entry.getValue().getCount() <= count)) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public int firstEmpty(Item item) {
        for (int i = 0; i < this.size; ++i) {
            if (this.getItemFast(i).getId() != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void decreaseCount(int slot) {
        Item item = this.getItem(slot);
        if (item.getCount() > 0) {
            --item.count;
            this.setItem(slot, item);
        }
    }

    @Override
    public boolean canAddItem(Item item) {
        int count = item.getCount();
        boolean checkDamage = item.hasMeta();
        boolean checkTag = item.getCompoundTag() != null;
        int i1 = this.getSize();
        for (int i = 0; i < i1; ++i) {
            Item slot = this.getItemFast(i);
            if (item.equals(slot, checkDamage, checkTag)) {
                int diff = slot.getMaxStackSize() - slot.getCount();
                if (diff > 0) {
                    count -= diff;
                }
            } else if (slot.getId() == 0) {
                count -= this.getMaxStackSize();
            }
            if (count > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Item[] addItem(Item ... slots) {
        ArrayList<Item> itemSlots = new ArrayList<Item>();
        for (Item item : slots) {
            if (item.getId() == 0 || item.getCount() <= 0) continue;
            itemSlots.add(item.clone());
        }
        IntArrayList emptySlots = new IntArrayList();
        for (int i = 0; i < this.getSize(); ++i) {
            Item item = this.getItem(i);
            if (item.getId() == 0 || item.getCount() <= 0) {
                emptySlots.add(i);
            }
            for (Item slot : new ArrayList(itemSlots)) {
                if (!slot.equals(item) || item.getCount() >= item.getMaxStackSize()) continue;
                int amount = Math.min(item.getMaxStackSize() - item.getCount(), slot.getCount());
                if ((amount = Math.min(amount, this.maxStackSize)) <= 0) continue;
                slot.setCount(slot.getCount() - amount);
                item.setCount(item.getCount() + amount);
                this.setItem(i, item);
                if (slot.getCount() > 0) continue;
                itemSlots.remove(slot);
            }
            if (itemSlots.isEmpty()) break;
        }
        if (!itemSlots.isEmpty() && !emptySlots.isEmpty()) {
            IntListIterator intListIterator = emptySlots.iterator();
            while (intListIterator.hasNext()) {
                int slotIndex = (Integer)intListIterator.next();
                if (itemSlots.isEmpty()) continue;
                Item item = (Item)itemSlots.get(0);
                int amount = Math.min(item.getMaxStackSize(), item.getCount());
                amount = Math.min(amount, this.maxStackSize);
                item.setCount(item.getCount() - amount);
                Item item2 = item.clone();
                item2.setCount(amount);
                this.setItem(slotIndex, item2);
                if (item.getCount() > 0) continue;
                itemSlots.remove(item);
            }
        }
        return itemSlots.toArray(new Item[0]);
    }

    @Override
    public Item[] removeItem(Item ... slots) {
        ArrayList<Item> itemSlots = new ArrayList<Item>();
        for (Item slot : slots) {
            if (slot.getId() == 0 || slot.getCount() <= 0) continue;
            itemSlots.add(slot.clone());
        }
        for (int i = 0; i < this.size; ++i) {
            Item item = this.getItem(i);
            if (item.getId() == 0 || item.getCount() <= 0) continue;
            for (Item slot : new ArrayList(itemSlots)) {
                if (!slot.equals(item, item.hasMeta(), item.getCompoundTag() != null)) continue;
                int amount = Math.min(item.getCount(), slot.getCount());
                slot.setCount(slot.getCount() - amount);
                item.setCount(item.getCount() - amount);
                this.setItem(i, item);
                if (slot.getCount() > 0) continue;
                itemSlots.remove(slot);
            }
            if (itemSlots.isEmpty()) break;
        }
        return itemSlots.toArray(new Item[0]);
    }

    @Override
    public boolean clear(int index, boolean send) {
        if (this.slots.containsKey(index)) {
            Item item = new ItemBlock(Block.get(0), null, 0);
            Item old = this.slots.get(index);
            InventoryHolder holder = this.getHolder();
            if (holder instanceof Entity) {
                EntityInventoryChangeEvent ev = new EntityInventoryChangeEvent((Entity)((Object)holder), old, item, index);
                Server.getInstance().getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    this.sendSlot(index, this.getViewers());
                    return false;
                }
                item = ev.getNewItem();
            }
            if (holder instanceof BlockEntity) {
                ((BlockEntity)((Object)holder)).setDirty();
            }
            if (item.getId() != 0) {
                this.slots.put(index, ((Item)item).clone());
            } else {
                this.slots.remove(index);
            }
            this.onSlotChange(index, old, send);
        }
        return true;
    }

    @Override
    public void clearAll() {
        for (Integer index : this.getContents().keySet()) {
            this.clear(index);
        }
    }

    @Override
    public Set<Player> getViewers() {
        return this.viewers;
    }

    @Override
    public InventoryHolder getHolder() {
        return this.holder;
    }

    @Override
    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    @Override
    public boolean open(Player who) {
        InventoryOpenEvent ev = new InventoryOpenEvent(this, who);
        who.getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        this.onOpen(who);
        return true;
    }

    @Override
    public void close(Player who) {
        this.onClose(who);
    }

    @Override
    public void onOpen(Player who) {
        this.viewers.add(who);
    }

    @Override
    public void onClose(Player who) {
        this.viewers.remove(who);
    }

    @Override
    public void onSlotChange(int index, Item before, boolean send) {
        if (send) {
            this.sendSlot(index, this.getViewers());
        }
    }

    @Override
    public void sendContents(Player player) {
        this.sendContents(new Player[]{player});
    }

    @Override
    public void sendContents(Player ... players) {
        InventoryContentPacket pk = new InventoryContentPacket();
        pk.slots = new Item[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            pk.slots[i] = this.getItem(i);
        }
        for (Player player : players) {
            int id = player.getWindowId(this);
            if (id == -1) {
                this.close(player);
                continue;
            }
            pk.inventoryId = id;
            player.dataPacket(pk);
        }
    }

    @Override
    public boolean isFull() {
        if (this.slots.size() < this.getSize()) {
            return false;
        }
        for (Item item : this.slots.values()) {
            if (item != null && item.getId() != 0 && item.getCount() >= item.getMaxStackSize() && item.getCount() >= this.maxStackSize) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        if (this.maxStackSize <= 0) {
            return false;
        }
        for (Item item : this.slots.values()) {
            if (item == null || item.getId() == 0 || item.getCount() <= 0) continue;
            return false;
        }
        return true;
    }

    public int getFreeSpace(Item item) {
        int maxStackSize = Math.min(item.getMaxStackSize(), this.maxStackSize);
        int space = (this.getSize() - this.slots.size()) * maxStackSize;
        for (Item slot : this.getContents().values()) {
            if (slot == null || slot.getId() == 0) {
                space += maxStackSize;
                continue;
            }
            if (!slot.equals(item, true, true)) continue;
            space += maxStackSize - slot.getCount();
        }
        return space;
    }

    @Override
    public void sendContents(Collection<Player> players) {
        this.sendContents(players.toArray(new Player[0]));
    }

    @Override
    public void sendSlot(int index, Player player) {
        InventorySlotPacket pk = new InventorySlotPacket();
        pk.slot = index;
        pk.item = this.getItem(index);
        int id = player.getWindowId(this);
        if (id == -1) {
            this.close(player);
            return;
        }
        pk.inventoryId = id;
        player.dataPacket(pk);
    }

    @Override
    public void sendSlot(int index, Player ... players) {
        InventorySlotPacket pk = new InventorySlotPacket();
        pk.slot = index;
        pk.item = this.getItem(index);
        for (Player player : players) {
            int id = player.getWindowId(this);
            if (id == -1) {
                this.close(player);
                continue;
            }
            pk.inventoryId = id;
            player.dataPacket(pk);
        }
    }

    @Override
    public void sendSlot(int index, Collection<Player> players) {
        this.sendSlot(index, players.toArray(new Player[0]));
    }

    @Override
    public InventoryType getType() {
        return this.type;
    }
}

