/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockBarrel;
import cn.nukkit.blockentity.BlockEntityBarrel;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;

public class BarrelInventory
extends ContainerInventory {
    public BarrelInventory(BlockEntityBarrel barrel) {
        super(barrel, InventoryType.BARREL);
    }

    @Override
    public BlockEntityBarrel getHolder() {
        return (BlockEntityBarrel)this.holder;
    }

    @Override
    public void onOpen(Player who) {
        BlockBarrel blockBarrel;
        super.onOpen(who);
        if (this.getViewers().size() != 1) {
            return;
        }
        BlockEntityBarrel barrel = this.getHolder();
        Level level = barrel.getLevel();
        if (level == null) {
            return;
        }
        Block block = barrel.getBlock();
        if (block instanceof BlockBarrel && !(blockBarrel = (BlockBarrel)block).isOpen()) {
            blockBarrel.setOpen(true);
            level.setBlock(blockBarrel, blockBarrel, true, true);
            level.addLevelSoundEvent(blockBarrel, 270);
        }
    }

    @Override
    public void onClose(Player who) {
        BlockBarrel blockBarrel;
        super.onClose(who);
        if (!this.getViewers().isEmpty()) {
            return;
        }
        BlockEntityBarrel barrel = this.getHolder();
        Level level = barrel.getLevel();
        if (level == null) {
            return;
        }
        Block block = barrel.getBlock();
        if (block instanceof BlockBarrel && (blockBarrel = (BlockBarrel)block).isOpen()) {
            blockBarrel.setOpen(false);
            level.setBlock(blockBarrel, blockBarrel, true, true);
            level.addLevelSoundEvent(blockBarrel, 271);
        }
    }

    @Override
    public void onSlotChange(int index, Item before, boolean send) {
        super.onSlotChange(index, before, send);
        this.getHolder().chunk.setChanged();
    }
}

