/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.form.window;

import cn.nukkit.form.element.Element;
import cn.nukkit.form.element.ElementButtonImageData;
import cn.nukkit.form.element.ElementDropdown;
import cn.nukkit.form.element.ElementInput;
import cn.nukkit.form.element.ElementLabel;
import cn.nukkit.form.element.ElementSlider;
import cn.nukkit.form.element.ElementStepSlider;
import cn.nukkit.form.element.ElementToggle;
import cn.nukkit.form.response.FormResponseCustom;
import cn.nukkit.form.response.FormResponseData;
import cn.nukkit.form.window.FormWindow;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FormWindowCustom
extends FormWindow {
    private final String type = "custom_form";
    private String title = "";
    private ElementButtonImageData icon;
    private List<Element> content;
    private FormResponseCustom response;

    public FormWindowCustom(String title) {
        this(title, new ArrayList<Element>());
    }

    public FormWindowCustom(String title, List<Element> contents) {
        this(title, contents, (ElementButtonImageData)null);
    }

    public FormWindowCustom(String title, List<Element> contents, String icon) {
        this(title, contents, icon.isEmpty() ? null : new ElementButtonImageData("url", icon));
    }

    public FormWindowCustom(String title, List<Element> contents, ElementButtonImageData icon) {
        this.title = title;
        this.content = contents;
        this.icon = icon;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<Element> getElements() {
        return this.content;
    }

    public void addElement(Element element) {
        this.content.add(element);
    }

    public ElementButtonImageData getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        if (!icon.isEmpty()) {
            this.icon = new ElementButtonImageData("url", icon);
        }
    }

    public void setIcon(ElementButtonImageData icon) {
        this.icon = icon;
    }

    @Override
    public FormResponseCustom getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(String data) {
        if (data.equals("null")) {
            this.closed = true;
            return;
        }
        List elementResponses = (List)GSON.fromJson(data, new ListTypeToken().getType());
        int i = 0;
        HashMap<Integer, FormResponseData> dropdownResponses = new HashMap<Integer, FormResponseData>();
        HashMap<Integer, String> inputResponses = new HashMap<Integer, String>();
        HashMap<Integer, Float> sliderResponses = new HashMap<Integer, Float>();
        HashMap<Integer, FormResponseData> stepSliderResponses = new HashMap<Integer, FormResponseData>();
        HashMap<Integer, Boolean> toggleResponses = new HashMap<Integer, Boolean>();
        HashMap<Integer, Object> responses = new HashMap<Integer, Object>();
        HashMap<Integer, String> labelResponses = new HashMap<Integer, String>();
        for (String elementData : elementResponses) {
            Object answer;
            Element e;
            if (i >= this.content.size() || (e = this.content.get(i)) == null) break;
            if (e instanceof ElementLabel) {
                labelResponses.put(i, ((ElementLabel)e).getText());
                responses.put(i, ((ElementLabel)e).getText());
            } else if (e instanceof ElementDropdown) {
                answer = ((ElementDropdown)e).getOptions().get(Integer.parseInt(elementData));
                dropdownResponses.put(i, new FormResponseData(Integer.parseInt(elementData), (String)answer));
                responses.put(i, answer);
            } else if (e instanceof ElementInput) {
                inputResponses.put(i, elementData);
                responses.put(i, elementData);
            } else if (e instanceof ElementSlider) {
                answer = Float.valueOf(Float.parseFloat(elementData));
                sliderResponses.put(i, (Float)answer);
                responses.put(i, answer);
            } else if (e instanceof ElementStepSlider) {
                answer = ((ElementStepSlider)e).getSteps().get(Integer.parseInt(elementData));
                stepSliderResponses.put(i, new FormResponseData(Integer.parseInt(elementData), (String)answer));
                responses.put(i, answer);
            } else if (e instanceof ElementToggle) {
                answer = Boolean.parseBoolean(elementData);
                toggleResponses.put(i, (Boolean)answer);
                responses.put(i, answer);
            }
            ++i;
        }
        this.response = new FormResponseCustom(responses, dropdownResponses, inputResponses, sliderResponses, stepSliderResponses, toggleResponses, labelResponses);
    }

    public void setElementsFromResponse() {
        if (this.response != null) {
            this.response.getResponses().forEach((i, response) -> {
                Element e = this.content.get((int)i);
                if (e != null) {
                    if (e instanceof ElementDropdown) {
                        ((ElementDropdown)e).setDefaultOptionIndex(((ElementDropdown)e).getOptions().indexOf(response));
                    } else if (e instanceof ElementInput) {
                        ((ElementInput)e).setDefaultText((String)response);
                    } else if (e instanceof ElementSlider) {
                        ((ElementSlider)e).setDefaultValue(((Float)response).floatValue());
                    } else if (e instanceof ElementStepSlider) {
                        ((ElementStepSlider)e).setDefaultOptionIndex(((ElementStepSlider)e).getSteps().indexOf(response));
                    } else if (e instanceof ElementToggle) {
                        ((ElementToggle)e).setDefaultValue((Boolean)response);
                    }
                }
            });
        }
    }

    private static class ListTypeToken
    extends TypeToken<List<String>> {
        private ListTypeToken() {
        }
    }
}

