/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.form.element;

import cn.nukkit.form.element.Element;
import com.google.gson.annotations.SerializedName;

public class ElementSlider
extends Element {
    private final String type = "slider";
    private String text = "";
    private float min = 0.0f;
    private float max = 100.0f;
    private int step;
    @SerializedName(value="default")
    private float defaultValue;

    public ElementSlider(String text, float min2, float max) {
        this(text, min2, max, -1);
    }

    public ElementSlider(String text, float min2, float max, int step) {
        this(text, min2, max, step, -1.0f);
    }

    public ElementSlider(String text, float min2, float max, int step, float defaultValue) {
        this.text = text;
        this.min = Math.max(min2, 0.0f);
        this.max = Math.max(max, this.min);
        if ((float)step != -1.0f && step > 0) {
            this.step = step;
        }
        if (defaultValue != -1.0f) {
            this.defaultValue = defaultValue;
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min2) {
        this.min = min2;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(float defaultValue) {
        this.defaultValue = defaultValue;
    }
}

